/*
 * Decompiled with CFR 0.152.
 */
package mage.server;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.management.MBeanServer;
import mage.cards.ExpansionSet;
import mage.cards.Sets;
import mage.cards.decks.DeckValidatorFactory;
import mage.cards.repository.CardScanner;
import mage.cards.repository.PluginClassloaderRegistery;
import mage.cards.repository.RepositoryUtil;
import mage.game.match.MatchType;
import mage.game.tournament.TournamentType;
import mage.interfaces.MageServer;
import mage.remote.Connection;
import mage.server.AuthorizedUserRepository;
import mage.server.DisconnectReason;
import mage.server.ExtensionPackage;
import mage.server.ExtensionPackageLoader;
import mage.server.MageServerImpl;
import mage.server.MainManagerFactory;
import mage.server.Session;
import mage.server.User;
import mage.server.draft.CubeFactory;
import mage.server.game.GameFactory;
import mage.server.game.PlayerFactory;
import mage.server.managers.ConfigSettings;
import mage.server.managers.ManagerFactory;
import mage.server.record.UserStatsRepository;
import mage.server.tournament.TournamentFactory;
import mage.server.util.ConfigFactory;
import mage.server.util.ConfigWrapper;
import mage.server.util.PluginClassLoader;
import mage.server.util.ServerMessagesUtil;
import mage.server.util.config.GamePlugin;
import mage.server.util.config.Plugin;
import mage.utils.MageVersion;
import mage.utils.SystemUtil;
import org.apache.log4j.Logger;
import org.jboss.remoting.Client;
import org.jboss.remoting.ClientDisconnectedException;
import org.jboss.remoting.ConnectionListener;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.callback.ServerInvokerCallbackHandler;
import org.jboss.remoting.transport.Connector;
import org.jboss.remoting.transport.bisocket.BisocketServerInvoker;
import org.jboss.remoting.transporter.TransporterClient;
import org.jboss.remoting.transporter.TransporterServer;
import org.w3c.dom.Element;

public final class Main {
    private static final Logger logger = Logger.getLogger(Main.class);
    private static final MageVersion version = new MageVersion(Main.class);
    private static final int SERVER_WORKER_THREAD_IDLE_TIMEOUT_SECS = 300;
    private static final String testModeArg = "-testMode=";
    private static final String testModeProp = "xmage.testMode";
    private static final String detailsModeArg = "-detailsMode=";
    private static final String detailsModeProp = "xmage.detailsMode";
    private static final String adminPasswordArg = "-adminPassword=";
    private static final String adminPasswordProp = "xmage.adminPassword";
    private static final String configPathProp = "xmage.config.path";
    private static final File pluginFolder = new File("plugins");
    private static final File extensionFolder = new File("extensions");
    private static final String defaultConfigPath = Paths.get("config", "config.xml").toString();
    public static final PluginClassLoader classLoader = new PluginClassLoader();
    private static TransporterServer server;
    private static boolean testMode;
    private static boolean detailsMode;

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) {
        void var10_34;
        void var9_27;
        System.setProperty("java.util.Arrays.useLegacyMergeSort", "true");
        logger.info((Object)("Starting MAGE SERVER version: " + version));
        logger.info((Object)("Java version: " + System.getProperty("java.version")));
        logger.info((Object)("Logging level: " + logger.getEffectiveLevel()));
        logger.info((Object)("Default charset: " + Charset.defaultCharset()));
        String adminPassword = "";
        testMode |= version.isDeveloperBuild();
        detailsMode = false;
        if (System.getProperty(testModeProp) != null) {
            testMode = Boolean.parseBoolean(System.getProperty(testModeProp));
        }
        if (System.getProperty(adminPasswordProp) != null) {
            adminPassword = SystemUtil.sanitize((String)System.getProperty(adminPasswordProp));
        }
        if (System.getProperty(detailsModeProp) != null) {
            detailsMode = Boolean.parseBoolean(System.getProperty(detailsModeProp));
        }
        String configPath = System.getProperty(configPathProp) != null ? System.getProperty(configPathProp) : defaultConfigPath;
        for (String arg : args) {
            if (arg.startsWith(testModeArg)) {
                testMode = Boolean.parseBoolean(arg.replace(testModeArg, ""));
            } else if (arg.startsWith(adminPasswordArg)) {
                adminPassword = arg.replace(adminPasswordArg, "");
                adminPassword = SystemUtil.sanitize((String)adminPassword);
            }
            if (!arg.startsWith(detailsModeArg)) continue;
            detailsMode = Boolean.parseBoolean(arg.replace(detailsModeArg, ""));
        }
        logger.info((Object)String.format("Reading configuration from path=%s", configPath));
        ConfigWrapper config = new ConfigWrapper(ConfigFactory.loadFromFile(configPath));
        if (config.isAuthenticationActivated().booleanValue()) {
            logger.info((Object)"Check authorized user DB version ...");
            if (!AuthorizedUserRepository.getInstance().checkAlterAndMigrateAuthorizedUser()) {
                logger.fatal((Object)"Failed to start server.");
                return;
            }
            logger.info((Object)"Done.");
        }
        RepositoryUtil.bootstrapLocalDb();
        logger.info((Object)"Done.");
        logger.info((Object)"Loading extension packages...");
        if (!extensionFolder.exists() && !extensionFolder.mkdirs()) {
            logger.error((Object)"Could not create extensions directory.");
        }
        File[] extensionDirectories = extensionFolder.listFiles();
        ArrayList<ExtensionPackage> extensions = new ArrayList<ExtensionPackage>();
        if (extensionDirectories != null) {
            for (File file : extensionDirectories) {
                if (!file.isDirectory()) continue;
                try {
                    logger.info((Object)(" - Loading extension from " + file));
                    extensions.add(ExtensionPackageLoader.loadExtension(file));
                }
                catch (IOException iOException) {
                    logger.error((Object)("Could not load extension in " + file + '!'), (Throwable)iOException);
                }
            }
        }
        logger.info((Object)"Done.");
        if (!extensions.isEmpty()) {
            logger.info((Object)"Registering custom sets...");
            for (ExtensionPackage pkg : extensions) {
                for (ExpansionSet expansionSet : pkg.getSets()) {
                    logger.info((Object)("- Loading " + expansionSet.getName() + " (" + expansionSet.getCode() + ')'));
                    Sets.getInstance().addSet(expansionSet);
                }
                PluginClassloaderRegistery.registerPluginClassloader(pkg.getClassLoader());
            }
            logger.info((Object)"Done.");
        }
        logger.info((Object)"Loading cards...");
        CardScanner.scan();
        logger.info((Object)"Done.");
        logger.info((Object)"Updating user stats DB...");
        UserStatsRepository.instance.updateUserStats();
        logger.info((Object)"Done.");
        Main.deleteSavedGames();
        int gameTypes = 0;
        for (GamePlugin plugin : config.getGameTypes()) {
            ++gameTypes;
            GameFactory.instance.addGameType(plugin.getName(), Main.loadGameType(plugin), Main.loadPlugin(plugin));
        }
        int tourneyTypes = 0;
        for (GamePlugin gamePlugin : config.getTournamentTypes()) {
            ++tourneyTypes;
            TournamentFactory.instance.addTournamentType(gamePlugin.getName(), Main.loadTournamentType(gamePlugin), Main.loadPlugin(gamePlugin));
        }
        int playerTypes = 0;
        for (Plugin plugin : config.getPlayerTypes()) {
            ++playerTypes;
            PlayerFactory.instance.addPlayerType(plugin.getName(), Main.loadPlugin(plugin));
        }
        boolean bl = false;
        for (Plugin plugin : config.getDraftCubes()) {
            void var9_26;
            ++var9_26;
            CubeFactory.instance.addDraftCube(plugin.getName(), Main.loadPlugin(plugin));
        }
        boolean bl2 = false;
        for (Plugin plugin : config.getDeckTypes()) {
            void var10_33;
            ++var10_33;
            DeckValidatorFactory.instance.addDeckType(plugin.getName(), Main.loadPlugin(plugin));
        }
        for (ExtensionPackage pkg : extensions) {
            for (Map.Entry<String, Class> entry : pkg.getDraftCubes().entrySet()) {
                logger.info((Object)("Loading extension: [" + entry.getKey() + "] " + entry.getValue().toString()));
                ++var9_27;
                CubeFactory.instance.addDraftCube(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Class> entry : pkg.getDeckTypes().entrySet()) {
                logger.info((Object)("Loading extension: [" + entry.getKey() + "] " + entry.getValue().toString()));
                ++var10_34;
                DeckValidatorFactory.instance.addDeckType(entry.getKey(), entry.getValue());
            }
        }
        logger.info((Object)("Config - server address:   " + config.getServerAddress()));
        logger.info((Object)("Config - server port:      " + config.getPort()));
        logger.info((Object)("Config - max game threads: " + config.getMaxGameThreads()));
        logger.info((Object)("Config - max seconds idle: " + config.getMaxSecondsIdle()));
        logger.info((Object)("Config - max AI opponents: " + config.getMaxAiOpponents()));
        logger.info((Object)("Config - min usr name le.: " + config.getMinUserNameLength()));
        logger.info((Object)("Config - max usr name le.: " + config.getMaxUserNameLength()));
        logger.info((Object)("Config - min pswrd length: " + config.getMinPasswordLength()));
        logger.info((Object)("Config - max pswrd length: " + config.getMaxPasswordLength()));
        logger.info((Object)("Config - inv.usr name pat: " + config.getInvalidUserNamePattern()));
        logger.info((Object)("Config - save game active: " + (config.isSaveGameActivated() != false ? "true" : "false")));
        logger.info((Object)("Config - backlog size    : " + config.getBacklogSize()));
        logger.info((Object)("Config - lease period    : " + config.getLeasePeriod()));
        logger.info((Object)("Config - sock wrt timeout: " + config.getSocketWriteTimeout()));
        logger.info((Object)("Config - max pool size   : " + config.getMaxPoolSize()));
        logger.info((Object)("Config - num accp.threads: " + config.getNumAcceptThreads()));
        logger.info((Object)("Config - second.bind port: " + config.getSecondaryBindPort()));
        logger.info((Object)("Config - users registr.:   " + (config.isAuthenticationActivated() != false ? "true" : "false")));
        logger.info((Object)("Config - users anon:       " + (config.isAuthenticationActivated() == false ? "true" : "false")));
        logger.info((Object)("Config - mailgun api key : " + config.getMailgunApiKey()));
        logger.info((Object)("Config - mailgun domain  : " + config.getMailgunDomain()));
        logger.info((Object)("Config - mail smtp Host  : " + config.getMailSmtpHost()));
        logger.info((Object)("Config - mail smtpPort   : " + config.getMailSmtpPort()));
        logger.info((Object)("Config - mail user       : " + config.getMailUser()));
        logger.info((Object)("Config - mail passw. len.: " + config.getMailPassword().length()));
        logger.info((Object)("Config - mail from addre.: " + config.getMailFromAddress()));
        logger.info((Object)("Config - google account  : " + config.getGoogleAccount()));
        logger.info((Object)("Loaded game types: " + gameTypes + ", tourneys: " + tourneyTypes + ", players: " + playerTypes + ", cubes: " + (int)var9_27 + ", decks: " + (int)var10_34));
        if (gameTypes == 0) {
            logger.error((Object)"ERROR, can't load any game types. Check your config.xml in server's config folder (example: old jar versions after update).");
        }
        Connection connection = new Connection("&maxPoolSize=" + config.getMaxPoolSize());
        connection.setHost(config.getServerAddress());
        connection.setPort(config.getPort());
        MainManagerFactory managerFactory = new MainManagerFactory(config);
        try {
            InvokerLocator serverLocator = new InvokerLocator(connection.getURI());
            if (!Main.isAlreadyRunning(config, serverLocator)) {
                server = new MageTransporterServer(managerFactory, serverLocator, new MageServerImpl(managerFactory, adminPassword, testMode, detailsMode), MageServer.class.getName(), new MageServerInvocationHandler(managerFactory));
                server.start();
                logger.info((Object)("Started MAGE server - listening on " + connection.toString()));
                if (testMode) {
                    logger.info((Object)"MAGE server running in test mode");
                }
                Main.initStatistics();
            } else {
                logger.fatal((Object)"Unable to start MAGE server - another server is already started");
            }
        }
        catch (Exception ex) {
            logger.fatal((Object)("Failed to start server - " + connection.toString()), (Throwable)ex);
        }
    }

    static void initStatistics() {
        ServerMessagesUtil.instance.setStartDate(System.currentTimeMillis());
    }

    static boolean isAlreadyRunning(ConfigSettings config, InvokerLocator serverLocator) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("writeTimeout", String.valueOf(config.getSocketWriteTimeout()));
        metadata.put("generalizeSocketException", "true");
        try {
            MageServer testServer = (MageServer)TransporterClient.createTransporterClient((String)serverLocator.getLocatorURI(), MageServer.class, metadata);
            if (testServer != null) {
                testServer.getServerState();
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static Class<?> loadPlugin(Plugin plugin) {
        try {
            logger.debug((Object)("Loading plugin: " + plugin.getClassName()));
            if (plugin.getName() == null || plugin.getName().isEmpty() || plugin.getJar() == null || plugin.getJar().isEmpty() || plugin.getClassName() == null || plugin.getClassName().isEmpty()) {
                logger.error((Object)String.format("Can't load plugin, found miss fields in config.xml: %s, %s, %s", plugin.getName(), plugin.getJar(), plugin.getClassName()));
                return null;
            }
            classLoader.addURL(new File(pluginFolder, plugin.getJar()).toURI().toURL());
            return Class.forName(plugin.getClassName(), true, classLoader);
        }
        catch (ClassNotFoundException ex) {
            logger.warn((Object)new StringBuilder("Plugin not Found: ").append(plugin.getClassName()).append(" - ").append(plugin.getJar()).append(" - check plugin folder"), (Throwable)ex);
        }
        catch (MalformedURLException ex) {
            logger.fatal((Object)("Error loading plugin " + plugin.getJar()), (Throwable)ex);
        }
        return null;
    }

    private static MatchType loadGameType(GamePlugin plugin) {
        try {
            classLoader.addURL(new File(pluginFolder, plugin.getJar()).toURI().toURL());
            logger.debug((Object)("Loading game type: " + plugin.getClassName()));
            return (MatchType)Class.forName(plugin.getTypeName(), true, classLoader).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException ex) {
            logger.warn((Object)("Game type not found:" + plugin.getJar() + " - check plugin folder"), (Throwable)ex);
        }
        catch (Exception ex) {
            logger.fatal((Object)("Error loading game type " + plugin.getJar()), (Throwable)ex);
        }
        return null;
    }

    private static TournamentType loadTournamentType(GamePlugin plugin) {
        try {
            classLoader.addURL(new File(pluginFolder, plugin.getJar()).toURI().toURL());
            return (TournamentType)Class.forName(plugin.getTypeName(), true, classLoader).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException ex) {
            logger.warn((Object)("Tournament type not found:" + plugin.getName() + " / " + plugin.getJar() + " - check plugin folder"), (Throwable)ex);
        }
        catch (Exception ex) {
            logger.fatal((Object)("Error loading game type " + plugin.getJar()), (Throwable)ex);
        }
        return null;
    }

    private static void deleteSavedGames() {
        File[] files;
        File directory = new File("saved/");
        if (!directory.exists()) {
            directory.mkdirs();
        }
        if ((files = directory.listFiles((dir, name) -> name.endsWith(".game"))) != null) {
            for (File file : files) {
                file.delete();
            }
        }
    }

    public static MageVersion getVersion() {
        return version;
    }

    public static boolean isTestMode() {
        return testMode;
    }

    static class MageServerInvocationHandler
    implements ServerInvocationHandler {
        private final ManagerFactory managerFactory;

        public MageServerInvocationHandler(ManagerFactory managerFactory) {
            this.managerFactory = managerFactory;
        }

        public void setMBeanServer(MBeanServer server) {
            if (server != null) {
                logger.info((Object)("Default domain: " + server.getDefaultDomain()));
            }
        }

        public void setInvoker(ServerInvoker invoker) {
            ((BisocketServerInvoker)invoker).setSecondaryBindPort(this.managerFactory.configSettings().getSecondaryBindPort());
            ((BisocketServerInvoker)invoker).setBacklog(this.managerFactory.configSettings().getBacklogSize());
            ((BisocketServerInvoker)invoker).setNumAcceptThreads(this.managerFactory.configSettings().getNumAcceptThreads());
            ((BisocketServerInvoker)invoker).setIdleTimeout(300);
        }

        public void addListener(InvokerCallbackHandler callbackHandler) {
            ServerInvokerCallbackHandler handler = (ServerInvokerCallbackHandler)callbackHandler;
            try {
                String sessionId = handler.getClientSessionId();
                this.managerFactory.sessionManager().createSession(sessionId, callbackHandler);
            }
            catch (Throwable ex) {
                logger.fatal((Object)"", ex);
            }
        }

        public Object invoke(InvocationRequest invocation) throws Throwable {
            String host;
            String sessionId = invocation.getSessionId();
            Map map = invocation.getRequestPayload();
            if (map != null) {
                InetAddress clientAddress = (InetAddress)invocation.getRequestPayload().get("clientAddress");
                host = clientAddress.getHostAddress();
            } else {
                host = "localhost";
            }
            Optional<Session> session = this.managerFactory.sessionManager().getSession(sessionId);
            if (!session.isPresent()) {
                logger.error((Object)("Session not found : " + sessionId));
            } else {
                session.get().setHost(host);
            }
            return null;
        }

        public void removeListener(InvokerCallbackHandler callbackHandler) {
            ServerInvokerCallbackHandler handler = (ServerInvokerCallbackHandler)callbackHandler;
            String sessionId = handler.getClientSessionId();
            DisconnectReason reason = DisconnectReason.DisconnectedByUser;
            if ("keep_my_old_session".equals(sessionId)) {
                reason = DisconnectReason.DisconnectedByUserButKeepTables;
            }
            this.managerFactory.sessionManager().disconnect(sessionId, reason, true);
        }
    }

    static class MageTransporterServer
    extends TransporterServer {
        protected Connector connector;

        public MageTransporterServer(ManagerFactory managerFactory, InvokerLocator locator, Object target, String subsystem, MageServerInvocationHandler serverInvocationHandler) throws Exception {
            super(locator, target, subsystem);
            this.connector.addInvocationHandler("callback", (ServerInvocationHandler)serverInvocationHandler);
            boolean isTestMode = ((MageServerImpl)target).getServerState().isTestMode();
            this.connector.setLeasePeriod(isTestMode ? 3600000L : (long)managerFactory.configSettings().getLeasePeriod());
            this.connector.addConnectionListener((ConnectionListener)new MageServerConnectionListener(managerFactory));
        }

        protected Connector getConnector(InvokerLocator locator, Map config, Element xmlConfig) throws Exception {
            Connector c;
            this.connector = c = super.getConnector(locator, config, xmlConfig);
            return c;
        }
    }

    static class MageServerConnectionListener
    implements ConnectionListener {
        private final ManagerFactory managerFactory;

        public MageServerConnectionListener(ManagerFactory managerFactory) {
            this.managerFactory = managerFactory;
        }

        public void handleConnectionException(Throwable throwable, Client client) {
            String sessionId = client.getSessionId();
            Session session = this.managerFactory.sessionManager().getSession(sessionId).orElse(null);
            if (session == null) {
                logger.debug((Object)("Connection error, session not found : " + sessionId + " - " + throwable));
                return;
            }
            StringBuilder sessionInfo = new StringBuilder();
            User user = this.managerFactory.userManager().getUser(session.getUserId()).orElse(null);
            if (user != null) {
                sessionInfo.append(user.getName()).append(" [").append(user.getGameInfo()).append(']');
            } else {
                sessionInfo.append("[no user]");
            }
            sessionInfo.append(" at ").append(session.getHost());
            if (throwable instanceof ClientDisconnectedException) {
                logger.info((Object)("CLIENT DISCONNECTED - " + sessionInfo));
                logger.debug((Object)"- cause: client called disconnect command");
                this.managerFactory.sessionManager().disconnect(client.getSessionId(), DisconnectReason.LostConnection, true);
            } else if (throwable == null) {
                logger.info((Object)("LOST CONNECTION (bad network) - " + sessionInfo));
                logger.debug((Object)"- cause: lease expired");
                this.managerFactory.sessionManager().disconnect(client.getSessionId(), DisconnectReason.LostConnection, true);
            } else {
                logger.info((Object)("LOST CONNECTION (unknown) - " + sessionInfo));
                logger.debug((Object)("- cause: unknown error - " + throwable));
                this.managerFactory.sessionManager().disconnect(client.getSessionId(), DisconnectReason.LostConnection, true);
            }
        }
    }
}

