/*
 * Decompiled with CFR 0.152.
 */
package mage.server;

import java.util.concurrent.TimeUnit;
import mage.server.ChatManagerImpl;
import mage.server.MailClientImpl;
import mage.server.MailgunClientImpl;
import mage.server.SessionManagerImpl;
import mage.server.TableManagerImpl;
import mage.server.UserManagerImpl;
import mage.server.draft.DraftManagerImpl;
import mage.server.game.GameManagerImpl;
import mage.server.game.GamesRoomManagerImpl;
import mage.server.game.ReplayManagerImpl;
import mage.server.managers.ChatManager;
import mage.server.managers.ConfigSettings;
import mage.server.managers.DraftManager;
import mage.server.managers.GameManager;
import mage.server.managers.GamesRoomManager;
import mage.server.managers.MailClient;
import mage.server.managers.ManagerFactory;
import mage.server.managers.ReplayManager;
import mage.server.managers.SessionManager;
import mage.server.managers.TableManager;
import mage.server.managers.ThreadExecutor;
import mage.server.managers.TournamentManager;
import mage.server.managers.UserManager;
import mage.server.tournament.TournamentManagerImpl;
import mage.server.util.ThreadExecutorImpl;
import org.apache.log4j.Logger;

public class MainManagerFactory
implements ManagerFactory {
    private final Logger logger = Logger.getLogger(MainManagerFactory.class);
    private static final int SERVER_HEALTH_CHECK_TIMEOUT_MINS = 10;
    private final ConfigSettings configSettings;
    private final ThreadExecutor threadExecutor;
    private final ChatManager chatManager;
    private final DraftManager draftManager;
    private final GameManager gameManager;
    private final GamesRoomManager gamesRoomManager;
    private final MailClient mailClient;
    private final MailClient mailgunClient;
    private final ReplayManager replayManager;
    private final SessionManager sessionManager;
    private final TableManager tableManager;
    private final UserManager userManager;
    private final TournamentManager tournamentManager;

    public MainManagerFactory(ConfigSettings configSettings) {
        this.configSettings = configSettings;
        this.threadExecutor = new ThreadExecutorImpl(configSettings);
        this.mailClient = new MailClientImpl(configSettings);
        this.mailgunClient = new MailgunClientImpl(configSettings);
        this.chatManager = new ChatManagerImpl(this);
        this.draftManager = new DraftManagerImpl(this);
        this.gameManager = new GameManagerImpl(this);
        this.replayManager = new ReplayManagerImpl(this);
        this.sessionManager = new SessionManagerImpl(this);
        this.tournamentManager = new TournamentManagerImpl(this);
        GamesRoomManagerImpl gamesRoomManager = new GamesRoomManagerImpl(this);
        TableManagerImpl tableManager = new TableManagerImpl(this);
        UserManagerImpl userManager = new UserManagerImpl(this);
        this.gamesRoomManager = gamesRoomManager;
        this.tableManager = tableManager;
        this.userManager = userManager;
        this.startThreads(gamesRoomManager, tableManager, userManager);
    }

    private void startThreads(GamesRoomManagerImpl gamesRoomManager, TableManagerImpl tableManager, UserManagerImpl userManager) {
        userManager.init();
        tableManager.init();
        gamesRoomManager.init();
        this.threadExecutor().getServerHealthExecutor().scheduleAtFixedRate(() -> {
            try {
                this.tableManager().checkHealth();
                this.chatManager().checkHealth();
                this.userManager().checkHealth();
                this.sessionManager().checkHealth();
            }
            catch (Exception ex) {
                this.logger.fatal((Object)("Server health check: catch unknown error - " + ex), (Throwable)ex);
            }
        }, 10L, 10L, TimeUnit.MINUTES);
    }

    @Override
    public ChatManager chatManager() {
        return this.chatManager;
    }

    @Override
    public DraftManager draftManager() {
        return this.draftManager;
    }

    @Override
    public GameManager gameManager() {
        return this.gameManager;
    }

    @Override
    public GamesRoomManager gamesRoomManager() {
        return this.gamesRoomManager;
    }

    @Override
    public MailClient mailClient() {
        return this.mailClient;
    }

    @Override
    public MailClient mailgunClient() {
        return this.mailgunClient;
    }

    @Override
    public ReplayManager replayManager() {
        return this.replayManager;
    }

    @Override
    public SessionManager sessionManager() {
        return this.sessionManager;
    }

    @Override
    public TableManager tableManager() {
        return this.tableManager;
    }

    @Override
    public UserManager userManager() {
        return this.userManager;
    }

    @Override
    public ConfigSettings configSettings() {
        return this.configSettings;
    }

    @Override
    public ThreadExecutor threadExecutor() {
        return this.threadExecutor;
    }

    @Override
    public TournamentManager tournamentManager() {
        return this.tournamentManager;
    }
}

