/*
 * Decompiled with CFR 0.152.
 */
package mage.server;

import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mage.MageException;
import mage.interfaces.callback.ClientCallback;
import mage.interfaces.callback.ClientCallbackMethod;
import mage.players.net.UserData;
import mage.players.net.UserGroup;
import mage.server.AuthorizedUser;
import mage.server.AuthorizedUserRepository;
import mage.server.DisconnectReason;
import mage.server.Main;
import mage.server.RandomString;
import mage.server.User;
import mage.server.game.GamesRoom;
import mage.server.managers.ConfigSettings;
import mage.server.managers.ManagerFactory;
import mage.util.ThreadUtils;
import mage.utils.SystemUtil;
import org.apache.log4j.Logger;
import org.jboss.remoting.callback.AsynchInvokerCallbackHandler;
import org.jboss.remoting.callback.Callback;
import org.jboss.remoting.callback.HandleCallbackException;
import org.jboss.remoting.callback.InvokerCallbackHandler;

public class Session {
    private static final Logger logger = Logger.getLogger(Session.class);
    private static final Pattern alphabetsPattern = Pattern.compile("[a-zA-Z]");
    private static final Pattern digitsPattern = Pattern.compile("[0-9]");
    public static final String REGISTRATION_DISABLED_MESSAGE = "Registration has been disabled on the server. You can use any name and empty password to login.";
    private static final boolean ANON_IDENTIFY_BY_HOST = true;
    private static final boolean SUPER_DUPER_BUGGY_AND_FASTEST_ASYNC_CONNECTION = false;
    private final ManagerFactory managerFactory;
    private final String sessionId;
    private UUID userId;
    private String host;
    private final AtomicInteger messageId = new AtomicInteger(0);
    private final Date timeConnected;
    private boolean isAdmin = false;
    private final AsynchInvokerCallbackHandler callbackHandler;
    private boolean valid = true;
    private final ReentrantLock lock;
    private final ReentrantLock callBackLock;
    private String lastCallbackInfo = "";

    public Session(ManagerFactory managerFactory, String sessionId, InvokerCallbackHandler callbackHandler) {
        this.managerFactory = managerFactory;
        this.sessionId = sessionId;
        this.callbackHandler = (AsynchInvokerCallbackHandler)callbackHandler;
        this.isAdmin = false;
        this.timeConnected = new Date();
        this.lock = new ReentrantLock();
        this.callBackLock = new ReentrantLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String registerUser(String userName, String password, String email) {
        if (!this.managerFactory.configSettings().isAuthenticationActivated().booleanValue()) {
            String returnMessage = REGISTRATION_DISABLED_MESSAGE;
            this.sendErrorMessageToClient(returnMessage);
            return returnMessage;
        }
        AuthorizedUserRepository authorizedUserRepository = AuthorizedUserRepository.getInstance();
        synchronized (authorizedUserRepository) {
            String returnMessage = this.validateUserName(userName);
            if (returnMessage != null) {
                this.sendErrorMessageToClient(returnMessage);
                return returnMessage;
            }
            RandomString randomString = new RandomString(10);
            password = randomString.nextString();
            returnMessage = this.validatePassword(password, userName);
            if (returnMessage != null) {
                this.sendErrorMessageToClient("Auto-generated password fail, try again: " + returnMessage);
                return returnMessage;
            }
            returnMessage = Session.validateEmail(email);
            if (returnMessage != null) {
                this.sendErrorMessageToClient(returnMessage);
                return returnMessage;
            }
            AuthorizedUserRepository.getInstance().add(userName, password, email);
            String text = "You are successfully registered as " + userName + '.';
            text = text + "  Your initial, generated password is: " + password;
            String subject = "XMage Registration Completed";
            boolean success = !this.managerFactory.configSettings().getMailUser().isEmpty() ? this.managerFactory.mailClient().sendMessage(email, subject, text) : this.managerFactory.mailgunClient().sendMessage(email, subject, text);
            if (success) {
                String ok = "Email with initial password sent to " + email + " for a user " + userName;
                logger.info((Object)ok);
                this.sendInfoMessageToClient(ok);
            } else if (Main.isTestMode()) {
                String ok = "Email sending failed. Server is in test mode. Your account registered with a password " + password + " for a user " + userName;
                logger.info((Object)ok);
                this.sendInfoMessageToClient(ok);
            } else {
                String err = "Email sending failed. Try use another email address or service. Or reset password by email " + email + " for a user " + userName;
                logger.error((Object)err);
                this.sendErrorMessageToClient(err);
                return err;
            }
            return null;
        }
    }

    private String validateUserNameLength(String userName) {
        ConfigSettings config = this.managerFactory.configSettings();
        if (userName.length() < config.getMinUserNameLength()) {
            return "User name may not be shorter than " + config.getMinUserNameLength() + " characters";
        }
        if (userName.length() > config.getMaxUserNameLength()) {
            return "User name may not be longer than " + config.getMaxUserNameLength() + " characters";
        }
        if (userName.length() <= 2) {
            return "User name is too short (2 characters or fewer)";
        }
        if (userName.length() >= 250) {
            return "User name is too long (250 characters or more)";
        }
        return null;
    }

    private String validateUserName(String userName) {
        if (userName.equals("Admin")) {
            return "User name already in use";
        }
        String returnMessage = this.validateUserNameLength(userName);
        if (returnMessage != null) {
            return returnMessage;
        }
        Pattern invalidUserNamePattern = Pattern.compile(this.managerFactory.configSettings().getInvalidUserNamePattern(), 2);
        Matcher m = invalidUserNamePattern.matcher(userName);
        if (m.find()) {
            return "User name '" + userName + "' includes not allowed characters: use a-z, A-Z and 0-9";
        }
        AuthorizedUser authorizedUser = AuthorizedUserRepository.getInstance().getByName(userName);
        if (authorizedUser != null) {
            return "User name '" + userName + "' already in use";
        }
        return null;
    }

    private String validatePassword(String password, String userName) {
        ConfigSettings config = this.managerFactory.configSettings();
        if (password.length() < config.getMinPasswordLength()) {
            return "Password may not be shorter than " + config.getMinPasswordLength() + " characters";
        }
        if (password.length() > config.getMaxPasswordLength()) {
            return "Password may not be longer than " + config.getMaxPasswordLength() + " characters";
        }
        if (password.equals(userName)) {
            return "Password may not be the same as your username";
        }
        Matcher alphabetsMatcher = alphabetsPattern.matcher(password);
        Matcher digitsMatcher = digitsPattern.matcher(password);
        if (!alphabetsMatcher.find() || !digitsMatcher.find()) {
            return "Password has to include at least one alphabet (a-zA-Z) and also at least one digit (0-9)";
        }
        return null;
    }

    private static String validateEmail(String email) {
        if (email == null || email.isEmpty()) {
            return "Email address cannot be blank";
        }
        AuthorizedUser authorizedUser = AuthorizedUserRepository.getInstance().getByEmail(email);
        if (authorizedUser != null) {
            return "Email address '" + email + "' is associated with another user";
        }
        return null;
    }

    public String connectUser(String userName, String password, String restoreSessionId) throws MageException {
        String errorMessage = this.validateUserNameLength(userName);
        if (errorMessage != null) {
            return errorMessage;
        }
        errorMessage = this.connectUserHandling(userName, password, restoreSessionId);
        return errorMessage;
    }

    public boolean isLocked() {
        return this.lock.isLocked();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String connectUserHandling(String userName, String password, String restoreSessionId) {
        this.isAdmin = false;
        AuthorizedUser authorizedUser = null;
        if (this.managerFactory.configSettings().isAuthenticationActivated().booleanValue()) {
            authorizedUser = AuthorizedUserRepository.getInstance().getByName(userName);
            String errorMsg = "Wrong username or password. You must register your account first.";
            if (authorizedUser == null) {
                return errorMsg;
            }
            if (!Main.isTestMode() && !authorizedUser.doCredentialsMatch(userName, password)) {
                return errorMsg;
            }
            if (!authorizedUser.active) {
                return "Your profile has been deactivated by admin.";
            }
            if (authorizedUser.lockedUntil != null) {
                if (authorizedUser.lockedUntil.compareTo(Calendar.getInstance().getTime()) > 0) {
                    return "Your profile has need deactivated by admin until " + SystemUtil.dateFormat.format(authorizedUser.lockedUntil);
                }
                this.managerFactory.userManager().createUser(userName, this.host, authorizedUser).ifPresent(user -> user.setLockedUntil(null));
            }
        }
        boolean isReconnection = false;
        User newUser = this.managerFactory.userManager().createUser(userName, this.host, authorizedUser).orElse(null);
        if (newUser == null) {
            User anotherUser = this.managerFactory.userManager().getUserByName(userName).orElse(null);
            if (anotherUser == null) return "Can't find connected user name " + userName;
            boolean canDisconnectAuthDueAnotherInstance = this.managerFactory.configSettings().isAuthenticationActivated();
            boolean canDisconnectAnonDueSameHost = this.managerFactory.configSettings().isAuthenticationActivated() == false && Objects.equals(anotherUser.getHost(), this.host);
            boolean canDisconnectAnyDueSessionRestore = Objects.equals(restoreSessionId, anotherUser.getRestoreSessionId());
            if (!canDisconnectAuthDueAnotherInstance && !canDisconnectAnonDueSameHost && !canDisconnectAnyDueSessionRestore) return "User " + userName + " already connected or your IP address changed - try another user";
            anotherUser.updateLastActivity(null);
            if (!anotherUser.getSessionId().isEmpty()) {
                String instanceReason = canDisconnectAnyDueSessionRestore ? " (session reconnect)" : (canDisconnectAnonDueSameHost ? " (same host)" : (canDisconnectAuthDueAnotherInstance ? " (same user)" : ""));
                String mes = "";
                mes = mes + String.format("Disconnecting another user instance for %s (reason: %s)", userName, instanceReason);
                if (logger.isDebugEnabled()) {
                    mes = mes + String.format("\n - reason: auth (%s), anon host (%s), any session (%s)", canDisconnectAuthDueAnotherInstance ? "yes" : "no", canDisconnectAnonDueSameHost ? "yes" : "no", canDisconnectAnyDueSessionRestore ? "yes" : "no");
                    mes = mes + String.format("\n - sessionId: %s => %s", anotherUser.getSessionId(), this.sessionId);
                    mes = mes + String.format("\n - name: %s => %s", anotherUser.getName(), userName);
                    mes = mes + String.format("\n - host: %s => %s", anotherUser.getHost(), this.host);
                }
                logger.info((Object)mes);
                DisconnectReason reason = DisconnectReason.AnotherUserInstance;
                if (Objects.equals(anotherUser.getHost(), this.host)) {
                    reason = DisconnectReason.AnotherUserInstanceSilent;
                }
                this.managerFactory.userManager().disconnect(anotherUser.getId(), reason);
            }
            isReconnection = true;
            newUser = anotherUser;
        }
        newUser.setRestoreSessionId("");
        this.userId = newUser.getId();
        if (!this.managerFactory.userManager().connectToSession(this.sessionId, this.userId)) {
            return "Error link user " + userName + " with session " + this.sessionId;
        }
        GamesRoom lobby = this.managerFactory.gamesRoomManager().getRoom(this.managerFactory.gamesRoomManager().getMainRoomId()).orElse(null);
        if (lobby != null) {
            this.managerFactory.chatManager().joinChat(lobby.getChatId(), this.userId);
        } else {
            logger.warn((Object)"main room not found");
        }
        newUser.setUserState(User.UserState.Connected);
        newUser.setRestoreSessionId(newUser.getSessionId());
        User reconnectUser = newUser;
        if (isReconnection) {
            this.managerFactory.threadExecutor().getCallExecutor().execute(reconnectUser::onReconnect);
        }
        if (!isReconnection) return null;
        this.managerFactory.chatManager().sendReconnectMessage(this.userId);
        return null;
    }

    public void connectAdmin() {
        this.isAdmin = true;
        User user = this.managerFactory.userManager().createUser("Admin", this.host, null).orElse(this.managerFactory.userManager().getUserByName("Admin").get());
        UserData adminUserData = UserData.getDefaultUserDataView();
        adminUserData.setGroupId(UserGroup.ADMIN.getGroupId());
        user.setUserData(adminUserData);
        if (!this.managerFactory.userManager().connectToSession(this.sessionId, user.getId())) {
            logger.info((Object)"Error connecting as admin");
        } else {
            user.setUserState(User.UserState.Connected);
        }
        this.userId = user.getId();
    }

    public boolean setUserData(String userName, UserData userData, String clientVersion, String userIdStr) {
        Optional<User> _user = this.managerFactory.userManager().getUserByName(userName);
        _user.ifPresent(user -> {
            if (clientVersion != null) {
                user.setClientVersion(clientVersion);
            }
            user.setUserIdStr(userIdStr);
            if (user.getUserData() == null || user.getUserData().getGroupId() == UserGroup.DEFAULT.getGroupId()) {
                user.setUserData(userData);
            } else {
                user.getUserData().update(userData);
            }
            if (user.getUserData().getAvatarId() < 10 || user.getUserData().getAvatarId() > 32) {
                user.getUserData().setAvatarId(10);
            }
            if (user.getUserData().getAvatarId() == 11) {
                user.getUserData().setAvatarId(this.updateAvatar(user.getName()));
            }
        });
        return _user.isPresent();
    }

    private int updateAvatar(String userName) {
        switch (userName) {
            case "North": {
                return 1006;
            }
            case "BetaSteward": {
                return 1008;
            }
            case "Bandit": {
                return 1020;
            }
            case "fireshoes": {
                return 1021;
            }
            case "noxx": {
                return 1000;
            }
            case "magenoxx": {
                return 1018;
            }
        }
        return 11;
    }

    public String getId() {
        return this.sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireCallback(ClientCallback call) {
        boolean lockSet = false;
        try {
            if (this.valid && this.callBackLock.tryLock(50L, TimeUnit.MILLISECONDS)) {
                this.lastCallbackInfo = call.getInfo();
                call.setMessageId(this.messageId.incrementAndGet());
                lockSet = true;
                Callback callback = new Callback((Object)call);
                boolean sendAsync = false;
                this.callbackHandler.handleCallbackOneway(callback, sendAsync);
            }
        }
        catch (InterruptedException ex) {
            if (!call.getMethod().equals((Object)ClientCallbackMethod.GAME_INIT)) {
                if (call.getMethod().equals((Object)ClientCallbackMethod.START_GAME)) {
                } else {
                    logger.warn((Object)("SESSION LOCK, possible connection problem - fireCallback - userId: " + this.userId + ", prev call: " + this.lastCallbackInfo + ", current call: " + call.getInfo()), (Throwable)ex);
                }
            }
        }
        catch (HandleCallbackException ex) {
            logger.warn((Object)("SESSION CALLBACK EXCEPTION - " + ThreadUtils.findRootException(ex) + ", userId " + this.userId + ", messageId: " + call.getMessageId()));
            this.valid = false;
            this.managerFactory.sessionManager().disconnect(this.sessionId, DisconnectReason.LostConnection, true);
        }
        catch (Throwable ex) {
            logger.error((Object)("SESSION CALLBACK UNKNOWN EXCEPTION - " + ThreadUtils.findRootException(ex) + ", userId " + this.userId + ", messageId: " + call.getMessageId()), ex);
            this.valid = false;
            this.managerFactory.sessionManager().disconnect(this.sessionId, DisconnectReason.LostConnection, true);
        }
        finally {
            if (lockSet) {
                this.callBackLock.unlock();
            }
        }
    }

    public UUID getUserId() {
        return this.userId;
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public String getHost() {
        return this.host;
    }

    public Date getConnectionTime() {
        return this.timeConnected;
    }

    void setHost(String hostAddress) {
        this.host = hostAddress;
    }

    public void sendErrorMessageToClient(String message) {
        LinkedList<String> messageData = new LinkedList<String>();
        messageData.add("Error while connecting to server");
        messageData.add(message);
        this.fireCallback(new ClientCallback(ClientCallbackMethod.SHOW_USERMESSAGE, null, messageData));
    }

    public void sendInfoMessageToClient(String message) {
        LinkedList<String> messageData = new LinkedList<String>();
        messageData.add("Information about connecting to the server");
        messageData.add(message);
        this.fireCallback(new ClientCallback(ClientCallbackMethod.SHOW_USERMESSAGE, null, messageData));
    }

    public static Throwable getBasicCause(Throwable cause) {
        Throwable t = cause;
        while (t.getCause() != null) {
            if (!Objects.equals(t = t.getCause(), cause)) continue;
            throw new IllegalArgumentException("Infinite cycle detected in causal chain");
        }
        return t;
    }
}

