/*
 * Decompiled with CFR 0.152.
 */
package mage.server;

import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import mage.MageException;
import mage.players.net.UserData;
import mage.server.DisconnectReason;
import mage.server.Session;
import mage.server.User;
import mage.server.managers.ManagerFactory;
import mage.server.managers.SessionManager;
import mage.util.ThreadUtils;
import org.apache.log4j.Logger;
import org.jboss.remoting.callback.InvokerCallbackHandler;

public class SessionManagerImpl
implements SessionManager {
    private static final Logger logger = Logger.getLogger(SessionManagerImpl.class);
    private final ManagerFactory managerFactory;
    private final ConcurrentHashMap<String, Session> sessions = new ConcurrentHashMap();

    public SessionManagerImpl(ManagerFactory managerFactory) {
        this.managerFactory = managerFactory;
    }

    @Override
    public Optional<Session> getSession(String sessionId) {
        return Optional.ofNullable(this.sessions.getOrDefault(sessionId, null));
    }

    @Override
    public void createSession(String sessionId, InvokerCallbackHandler callbackHandler) {
        Session session = new Session(this.managerFactory, sessionId, callbackHandler);
        this.sessions.put(sessionId, session);
    }

    @Override
    public boolean registerUser(String sessionId, String userName, String password, String email) throws MageException {
        Session session = this.sessions.get(sessionId);
        if (session == null) {
            logger.error((Object)(userName + " tried to register with no sessionId"));
            return false;
        }
        String returnMessage = session.registerUser(userName, password, email);
        if (returnMessage != null) {
            logger.debug((Object)(userName + " not registered: " + returnMessage));
            return false;
        }
        logger.info((Object)(userName + " registered"));
        logger.debug((Object)("- userId:    " + session.getUserId()));
        logger.debug((Object)("- sessionId: " + sessionId));
        logger.debug((Object)("- host:      " + session.getHost()));
        return true;
    }

    @Override
    public boolean connectUser(String sessionId, String restoreSessionId, String userName, String password, String userInfo, boolean detailsMode) throws MageException {
        Session session = this.sessions.get(sessionId);
        if (session != null) {
            String errorMessage = session.connectUser(userName, password, restoreSessionId);
            if (errorMessage == null) {
                logger.info((Object)(userName + " connected to server" + (restoreSessionId.isEmpty() ? "" : " with restored session")));
                if (detailsMode) {
                    logger.info((Object)("- details: " + userInfo));
                }
                logger.debug((Object)("- userId:    " + session.getUserId()));
                logger.debug((Object)("- sessionId: " + sessionId));
                logger.debug((Object)("- restoreSessionId: " + restoreSessionId));
                logger.debug((Object)("- host:      " + session.getHost()));
                return true;
            }
            logger.debug((Object)(userName + " not connected: " + errorMessage));
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                logger.fatal((Object)"waiting of error message had failed", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            session.sendErrorMessageToClient(errorMessage);
        } else {
            logger.error((Object)(userName + " tried to connect with no sessionId"));
        }
        return false;
    }

    @Override
    public boolean connectAdmin(String sessionId) {
        Session session = this.sessions.get(sessionId);
        if (session != null) {
            session.connectAdmin();
            logger.warn((Object)("Admin connected from " + session.getHost()));
            return true;
        }
        return false;
    }

    @Override
    public boolean setUserData(String userName, String sessionId, UserData userData, String clientVersion, String userIdStr) throws MageException {
        return this.getSession(sessionId).map(session -> session.setUserData(userName, userData, clientVersion, userIdStr)).orElse(false);
    }

    @Override
    public void disconnect(String sessionId, DisconnectReason reason, boolean checkUserDisconnection) {
        Session session = this.getSession(sessionId).orElse(null);
        if (session == null) {
            return;
        }
        if (!this.isValidSession(sessionId)) {
            logger.info((Object)("DISCONNECT session, already invalid: " + (Object)((Object)reason) + " - sessionId: " + sessionId));
            return;
        }
        if (checkUserDisconnection) {
            this.managerFactory.userManager().getUser(session.getUserId()).ifPresent(user -> user.onLostConnection(reason));
        }
        this.sessions.remove(sessionId);
    }

    @Override
    public void disconnectAnother(String sessionId, String userSessionId) {
        if (!this.checkAdminAccess(sessionId)) {
            return;
        }
        User admin = this.getUserFromSession(sessionId).orElse(null);
        User user = this.getUserFromSession(userSessionId).orElse(null);
        if (admin == null || user == null) {
            return;
        }
        user.showUserMessage("Admin action", "Your session was disconnected by admin");
        ThreadUtils.sleep(1000);
        logger.warn((Object)(user.getName() + " disconnected by admin"));
        this.disconnect(userSessionId, DisconnectReason.DisconnectedByAdmin, true);
        admin.showUserMessage("Admin result", "User " + user.getName() + " was disconnected");
    }

    private Optional<User> getUserFromSession(String sessionId) {
        return this.getSession(sessionId).flatMap(s -> this.managerFactory.userManager().getUser(s.getUserId()));
    }

    @Override
    public boolean checkAdminAccess(String sessionId) {
        Session session = this.sessions.get(sessionId);
        if (session == null) {
            logger.error((Object)("Wrong admin access with unknown session: " + sessionId), new Throwable());
        } else if (!session.isAdmin()) {
            String info = String.format("sessionId %s for userId %s at %s", session.getId(), session.getUserId(), session.getHost());
            logger.error((Object)("Wrong admin access with user session: " + info), new Throwable());
        }
        return session != null && session.isAdmin();
    }

    @Override
    public boolean isValidSession(String sessionId) {
        return this.sessions.containsKey(sessionId);
    }

    @Override
    public Optional<User> getUser(String sessionId) {
        Session session = this.sessions.get(sessionId);
        if (session != null) {
            return this.managerFactory.userManager().getUser(this.sessions.get(sessionId).getUserId());
        }
        logger.error((Object)String.format("Session %s could not be found", sessionId));
        return Optional.empty();
    }

    @Override
    public boolean extendUserSession(String sessionId, String pingInfo) {
        return this.getSession(sessionId).map(session -> this.managerFactory.userManager().extendUserSession(session.getUserId(), pingInfo)).orElse(false);
    }

    @Override
    public void sendErrorMessageToClient(String sessionId, String message) {
        Session session = this.sessions.get(sessionId);
        if (session == null) {
            logger.error((Object)("Following error message is not delivered because session " + sessionId + " is not found: " + message));
            return;
        }
        session.sendErrorMessageToClient(message);
    }

    @Override
    public void checkHealth() {
    }
}

