/*
 * Decompiled with CFR 0.152.
 */
package mage.server;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import mage.MageException;
import mage.cards.decks.DeckCardLists;
import mage.constants.TableState;
import mage.game.Game;
import mage.game.GameException;
import mage.game.Table;
import mage.game.draft.Draft;
import mage.game.match.Match;
import mage.game.match.MatchOptions;
import mage.game.tournament.Tournament;
import mage.game.tournament.TournamentOptions;
import mage.game.tournament.TournamentPlayer;
import mage.players.PlayerType;
import mage.server.ChatSession;
import mage.server.Session;
import mage.server.TableController;
import mage.server.User;
import mage.server.game.GameController;
import mage.server.managers.ManagerFactory;
import mage.server.managers.TableManager;
import org.apache.log4j.Logger;

public class TableManagerImpl
implements TableManager {
    private final ManagerFactory managerFactory;
    private final Logger logger = Logger.getLogger(TableManagerImpl.class);
    private final DateFormat formatter = new SimpleDateFormat("HH:mm:ss");
    private final ConcurrentHashMap<UUID, TableController> controllers = new ConcurrentHashMap();
    private final ReadWriteLock controllersLock = new ReentrantReadWriteLock();
    private final ConcurrentHashMap<UUID, Table> tables = new ConcurrentHashMap();
    private final ReadWriteLock tablesLock = new ReentrantReadWriteLock();

    public TableManagerImpl(ManagerFactory managerFactory) {
        this.managerFactory = managerFactory;
    }

    public void init() {
    }

    @Override
    public Table createTable(UUID roomId, UUID userId, MatchOptions options) {
        TableController tableController = new TableController(this.managerFactory, roomId, userId, options);
        this.putControllers(tableController.getTable().getId(), tableController);
        this.putTables(tableController.getTable().getId(), tableController.getTable());
        return tableController.getTable();
    }

    @Override
    public Table createTable(UUID roomId, MatchOptions options) {
        TableController tableController = new TableController(this.managerFactory, roomId, null, options);
        this.putControllers(tableController.getTable().getId(), tableController);
        this.putTables(tableController.getTable().getId(), tableController.getTable());
        return tableController.getTable();
    }

    @Override
    public Table createTournamentTable(UUID roomId, UUID userId, TournamentOptions options) {
        TableController tableController = new TableController(this.managerFactory, roomId, userId, options);
        this.putControllers(tableController.getTable().getId(), tableController);
        this.putTables(tableController.getTable().getId(), tableController.getTable());
        return tableController.getTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putTables(UUID tableId, Table table) {
        Lock w = this.tablesLock.writeLock();
        w.lock();
        try {
            this.tables.put(tableId, table);
        }
        finally {
            w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putControllers(UUID controllerId, TableController tableController) {
        Lock w = this.controllersLock.writeLock();
        w.lock();
        try {
            this.controllers.put(controllerId, tableController);
        }
        finally {
            w.unlock();
        }
    }

    @Override
    public Table getTable(UUID tableId) {
        return this.tables.get(tableId);
    }

    @Override
    public Optional<Match> getMatch(UUID tableId) {
        if (this.controllers.containsKey(tableId)) {
            return Optional.of(this.controllers.get(tableId).getMatch());
        }
        return Optional.empty();
    }

    @Override
    public Collection<Table> getTables() {
        ArrayList<Table> newTables = new ArrayList<Table>();
        Lock r = this.tablesLock.readLock();
        r.lock();
        try {
            newTables.addAll(this.tables.values());
        }
        finally {
            r.unlock();
        }
        return newTables;
    }

    @Override
    public Collection<TableController> getControllers() {
        ArrayList<TableController> newControllers = new ArrayList<TableController>();
        Lock r = this.controllersLock.readLock();
        r.lock();
        try {
            newControllers.addAll(this.controllers.values());
        }
        finally {
            r.unlock();
        }
        return newControllers;
    }

    @Override
    public Optional<TableController> getController(UUID tableId) {
        if (this.controllers.containsKey(tableId)) {
            return Optional.of(this.controllers.get(tableId));
        }
        return Optional.empty();
    }

    @Override
    public boolean joinTable(UUID userId, UUID tableId, String name, PlayerType playerType, int skill, DeckCardLists deckList, String password) throws MageException {
        if (this.controllers.containsKey(tableId)) {
            return this.controllers.get(tableId).joinTable(userId, name, playerType, skill, deckList, password);
        }
        return false;
    }

    @Override
    public boolean joinTournament(UUID userId, UUID tableId, String name, PlayerType playerType, int skill, DeckCardLists deckList, String password) throws GameException {
        if (this.controllers.containsKey(tableId)) {
            return this.controllers.get(tableId).joinTournament(userId, name, playerType, skill, deckList, password);
        }
        return false;
    }

    @Override
    public boolean submitDeck(UUID userId, UUID tableId, DeckCardLists deckList) throws MageException {
        if (this.controllers.containsKey(tableId)) {
            return this.controllers.get(tableId).submitDeck(userId, deckList);
        }
        this.managerFactory.userManager().getUser(userId).ifPresent(user -> {
            user.removeSideboarding(tableId);
            user.showUserMessage("Submit deck", "Table no longer active");
        });
        return true;
    }

    @Override
    public void updateDeck(UUID userId, UUID tableId, DeckCardLists deckList) throws MageException {
        if (this.controllers.containsKey(tableId)) {
            this.controllers.get(tableId).updateDeck(userId, deckList);
        }
    }

    @Override
    public void userQuitTournamentSubTables(UUID userId) {
        for (TableController controller : this.getControllers()) {
            if (controller.getTable() != null) {
                if (!controller.getTable().isTournamentSubTable()) continue;
                controller.leaveTable(userId);
                continue;
            }
            this.logger.error((Object)("TableManagerImpl.userQuitTournamentSubTables table == null - userId " + userId));
        }
    }

    @Override
    public void userQuitTournamentSubTables(UUID tournamentId, UUID userId) {
        for (TableController controller : this.getControllers()) {
            if (!controller.getTable().isTournamentSubTable() || !controller.getTable().getTournament().getId().equals(tournamentId) || !controller.hasPlayer(userId)) continue;
            controller.leaveTable(userId);
        }
    }

    @Override
    public boolean isTableOwner(UUID tableId, UUID userId) {
        if (this.controllers.containsKey(tableId)) {
            return this.controllers.get(tableId).isOwner(userId);
        }
        return false;
    }

    @Override
    public boolean removeTable(UUID userId, UUID tableId) {
        if (this.isTableOwner(tableId, userId) || this.managerFactory.userManager().isAdmin(userId)) {
            this.logger.debug((Object)("Table remove request - userId: " + userId + " tableId: " + tableId));
            TableController tableController = this.controllers.get(tableId);
            if (tableController != null) {
                tableController.leaveTableAll();
                this.managerFactory.chatManager().destroyChatSession(tableController.getChatId());
                this.removeTable(tableId);
            }
            return true;
        }
        return false;
    }

    @Override
    public void leaveTable(UUID userId, UUID tableId) {
        TableController tableController = this.controllers.get(tableId);
        if (tableController != null) {
            tableController.leaveTable(userId);
        }
    }

    @Override
    public Optional<UUID> getChatId(UUID tableId) {
        if (this.controllers.containsKey(tableId)) {
            return Optional.of(this.controllers.get(tableId).getChatId());
        }
        return Optional.empty();
    }

    @Override
    public void startMatch(UUID userId, UUID roomId, UUID tableId) {
        if (this.controllers.containsKey(tableId)) {
            this.controllers.get(tableId).startMatch(userId);
            this.managerFactory.chatManager().destroyChatSession(this.controllers.get(tableId).getChatId());
        }
    }

    @Override
    public void startTournamentSubMatch(UUID roomId, UUID tableId) {
        if (this.controllers.containsKey(tableId)) {
            this.controllers.get(tableId).startMatch();
        }
    }

    @Override
    public void startTournament(UUID userId, UUID roomId, UUID tableId) {
        if (this.controllers.containsKey(tableId)) {
            this.controllers.get(tableId).startTournament(userId);
            this.managerFactory.chatManager().destroyChatSession(this.controllers.get(tableId).getChatId());
        }
    }

    @Override
    public void startDraft(UUID tableId, Draft draft) {
        if (this.controllers.containsKey(tableId)) {
            this.controllers.get(tableId).startDraft(draft);
        }
    }

    @Override
    public boolean watchTable(UUID userId, UUID tableId) {
        if (this.controllers.containsKey(tableId)) {
            return this.controllers.get(tableId).watchTable(userId);
        }
        return false;
    }

    @Override
    public void endGame(UUID tableId) {
        if (this.controllers.containsKey(tableId) && this.controllers.get(tableId).endGameAndStartNextGame()) {
            this.removeTable(tableId);
        }
    }

    @Override
    public void endDraft(UUID tableId, Draft draft) {
        if (this.controllers.containsKey(tableId)) {
            this.controllers.get(tableId).endDraft(draft);
        }
    }

    @Override
    public void endTournament(UUID tableId, Tournament tournament) {
        if (this.controllers.containsKey(tableId)) {
            this.controllers.get(tableId).endTournament(tournament);
        }
    }

    @Override
    public void swapSeats(UUID tableId, UUID userId, int seatNum1, int seatNum2) {
        if (this.controllers.containsKey(tableId) && this.isTableOwner(tableId, userId)) {
            this.controllers.get(tableId).swapSeats(seatNum1, seatNum2);
        }
    }

    @Override
    public void construct(UUID tableId) {
        if (this.controllers.containsKey(tableId)) {
            this.controllers.get(tableId).construct();
        }
    }

    @Override
    public void initTournament(UUID tableId) {
        if (this.controllers.containsKey(tableId)) {
            this.controllers.get(tableId).initTournament();
        }
    }

    @Override
    public void addPlayer(UUID userId, UUID tableId, TournamentPlayer player) throws GameException {
        if (this.controllers.containsKey(tableId)) {
            this.controllers.get(tableId).addPlayer(userId, player.getPlayer(), player.getPlayerType(), player.getDeck());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTable(UUID tableId) {
        TableController tableController = this.controllers.get(tableId);
        if (tableController != null) {
            Lock w = this.controllersLock.writeLock();
            w.lock();
            try {
                this.controllers.remove(tableId);
            }
            finally {
                w.unlock();
            }
            tableController.cleanUp();
            Table table = this.tables.get(tableId);
            w = this.tablesLock.writeLock();
            w.lock();
            try {
                this.tables.remove(tableId);
            }
            finally {
                w.unlock();
            }
            Match match = table.getMatch();
            Game game = null;
            if (match != null && (game = match.getGame()) != null && !game.hasEnded()) {
                game.end();
            }
            if (table.getState() != TableState.FINISHED) {
                if (game != null) {
                    this.managerFactory.gameManager().removeGame(game.getId());
                }
                this.managerFactory.gamesRoomManager().removeTable(tableId);
            }
        }
    }

    @Override
    public void debugServerState() {
        this.logger.debug((Object)"--- Server state ----------------------------------------------");
        Collection<User> users = this.managerFactory.userManager().getUsers();
        this.logger.debug((Object)("--------User: " + users.size() + " [userId | since | lock | name -----------------------"));
        for (User user : users) {
            Optional<Session> optional = this.managerFactory.sessionManager().getSession(user.getSessionId());
            String sessionState = "N";
            if (optional.isPresent()) {
                sessionState = optional.get().isLocked() ? "L" : "+";
            }
            this.logger.debug((Object)(user.getId() + " | " + this.formatter.format(user.getConnectionTime()) + " | " + sessionState + " | " + user.getName() + " (" + user.getUserState().toString() + " - " + user.getPingInfo() + ')'));
        }
        List<ChatSession> chatSessions = this.managerFactory.chatManager().getChatSessions();
        this.logger.debug((Object)("------- ChatSessions: " + chatSessions.size() + " ----------------------------------"));
        for (ChatSession chatSession : chatSessions) {
            this.logger.debug((Object)(chatSession.getChatId() + " " + this.formatter.format(chatSession.getCreateTime()) + ' ' + chatSession.getInfo() + ' ' + chatSession.getUsers().values().toString()));
        }
        this.logger.debug((Object)("------- Games: " + this.managerFactory.gameManager().getNumberActiveGames() + " --------------------------------------------"));
        this.logger.debug((Object)(" Active Game Worker: " + this.managerFactory.threadExecutor().getActiveThreads(this.managerFactory.threadExecutor().getGameExecutor())));
        for (Map.Entry entry : this.managerFactory.gameManager().getGameController().entrySet()) {
            this.logger.debug((Object)(entry.getKey() + ((GameController)entry.getValue()).getPlayerNameList()));
        }
        this.logger.debug((Object)"--- Server state END ------------------------------------------");
    }

    private void removeOutdatedTables() {
        if (this.logger.isDebugEnabled()) {
            this.debugServerState();
        }
        this.logger.debug((Object)"TABLE HEALTH CHECK");
        for (Table table : this.getTables()) {
            try {
                if (table.getState() == TableState.FINISHED || (System.currentTimeMillis() - table.getStartTime().getTime()) / 1000L <= 30L) continue;
                this.logger.debug((Object)(table.getId() + " [" + table.getName() + "] " + this.formatter.format(table.getStartTime() != null ? table.getStartTime() : table.getCreateTime()) + " (" + table.getState().toString() + ") " + (table.isTournament() ? "- Tournament" : "")));
                this.getController(table.getId()).ifPresent(tableController -> {
                    if (table.isTournament() && !tableController.isTournamentStillValid() || !table.isTournament() && !tableController.isMatchTableStillValid()) {
                        try {
                            this.logger.warn((Object)("Removing unhealthy tableId " + table.getId()));
                            this.removeTable(table.getId());
                        }
                        catch (Exception e) {
                            this.logger.error((Object)e);
                        }
                    }
                });
            }
            catch (Exception ex) {
                this.logger.debug((Object)("Table Health check error tableId: " + table.getId()));
                this.logger.debug((Object)Arrays.toString(ex.getStackTrace()));
            }
        }
        this.logger.debug((Object)"TABLE HEALTH CHECK - END");
    }

    @Override
    public void checkHealth() {
        this.removeOutdatedTables();
    }
}

