/*
 * Decompiled with CFR 0.152.
 */
package mage.server.draft;

import java.lang.reflect.Constructor;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import mage.cards.decks.Deck;
import mage.game.draft.DraftCube;
import org.apache.log4j.Logger;

public enum CubeFactory {
    instance;

    private static final Logger logger;
    private final Map<String, Class> draftCubes = new LinkedHashMap<String, Class>();

    public DraftCube createDraftCube(String draftCubeName) {
        DraftCube draftCube;
        try {
            Constructor con = this.draftCubes.get(draftCubeName).getConstructor(new Class[0]);
            draftCube = (DraftCube)con.newInstance(new Object[0]);
        }
        catch (Exception ex) {
            logger.fatal((Object)"CubeFactory error", (Throwable)ex);
            return null;
        }
        logger.debug((Object)("Draft cube created: " + draftCube.getName()));
        return draftCube;
    }

    public DraftCube createDeckDraftCube(String draftCubeName, Deck cubeFromDeck) {
        DraftCube draftCube;
        try {
            Constructor con = this.draftCubes.get(draftCubeName).getConstructor(Deck.class);
            draftCube = (DraftCube)con.newInstance(cubeFromDeck);
        }
        catch (Exception ex) {
            logger.fatal((Object)"CubeFactory error", (Throwable)ex);
            return null;
        }
        logger.debug((Object)("Draft cube created: " + draftCube.getName()));
        return draftCube;
    }

    public Set<String> getDraftCubes() {
        return this.draftCubes.keySet();
    }

    public void addDraftCube(String configName, Class configCubeClass) {
        if (configCubeClass == null) {
            return;
        }
        DraftCube draftCube = null;
        try {
            Constructor con = configCubeClass.getConstructor(new Class[0]);
            draftCube = (DraftCube)con.newInstance(new Object[0]);
            if (this.draftCubes.containsKey(draftCube.getName())) {
                throw new IllegalArgumentException("already exists " + draftCube.getName());
            }
        }
        catch (Exception e) {
            logger.error((Object)("Can't create draft cube named by " + configName), (Throwable)e);
            return;
        }
        this.draftCubes.put(draftCube.getName(), configCubeClass);
    }

    static {
        logger = Logger.getLogger(CubeFactory.class);
    }
}

