/*
 * Decompiled with CFR 0.152.
 */
package mage.server.draft;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import mage.MageException;
import mage.game.draft.Draft;
import mage.game.draft.DraftPlayer;
import mage.players.Player;
import mage.server.draft.DraftSession;
import mage.server.game.GameController;
import mage.server.managers.ManagerFactory;
import mage.view.DraftPickView;
import org.apache.log4j.Logger;

public class DraftController {
    private static final Logger logger = Logger.getLogger(GameController.class);
    private final ManagerFactory managerFactory;
    private final ConcurrentMap<UUID, DraftSession> draftSessions = new ConcurrentHashMap<UUID, DraftSession>();
    private final ConcurrentMap<UUID, UUID> userPlayerMap;
    private final UUID draftSessionId;
    private final Draft draft;
    private final UUID tableId;

    public DraftController(ManagerFactory managerFactory, Draft draft, ConcurrentMap<UUID, UUID> userPlayerMap, UUID tableId) {
        this.managerFactory = managerFactory;
        this.draftSessionId = UUID.randomUUID();
        this.userPlayerMap = userPlayerMap;
        this.draft = draft;
        this.tableId = tableId;
        this.init();
    }

    private void init() {
        this.draft.addTableEventListener(event -> {
            try {
                switch (event.getEventType()) {
                    case UPDATE: {
                        this.updateDraft();
                        break;
                    }
                    case END: {
                        this.endDraft();
                    }
                }
            }
            catch (MageException ex) {
                logger.fatal((Object)"Table event listener error", (Throwable)ex);
            }
        });
        this.draft.addPlayerQueryEventListener(event -> {
            try {
                switch (event.getQueryType()) {
                    case DRAFT_PICK_CARD: {
                        this.pickCard(event.getPlayerId(), event.getMax());
                    }
                }
            }
            catch (MageException ex) {
                logger.fatal((Object)"Table event listener error", (Throwable)ex);
            }
        });
        for (DraftPlayer player : this.draft.getPlayers()) {
            if (player.getPlayer().isHuman()) continue;
            player.setJoined();
            logger.debug((Object)("player " + player.getPlayer().getId() + " has joined draft " + this.draft.getId()));
        }
        this.checkStart();
    }

    private UUID getPlayerId(UUID userId) {
        return (UUID)this.userPlayerMap.get(userId);
    }

    public void join(UUID userId) {
        UUID playerId = (UUID)this.userPlayerMap.get(userId);
        DraftSession draftSession = new DraftSession(this.managerFactory, this.draft, userId, playerId);
        this.draftSessions.put(playerId, draftSession);
        this.managerFactory.userManager().getUser(userId).ifPresent(user -> {
            user.addDraft(playerId, draftSession);
            logger.debug((Object)("User " + user.getName() + " has joined draft " + this.draft.getId()));
            this.draft.getPlayer(playerId).setJoined();
        });
        this.checkStart();
    }

    public Optional<DraftSession> getDraftSession(UUID playerId) {
        if (this.draftSessions.containsKey(playerId)) {
            return Optional.of(this.draftSessions.get(playerId));
        }
        return Optional.empty();
    }

    public boolean replacePlayer(Player oldPlayer, Player newPlayer) {
        if (this.draft.replacePlayer(oldPlayer, newPlayer)) {
            DraftSession draftSession = (DraftSession)this.draftSessions.get(oldPlayer.getId());
            if (draftSession != null) {
                draftSession.draftOver();
                this.draftSessions.remove(oldPlayer.getId());
            }
            return true;
        }
        return false;
    }

    private synchronized void checkStart() {
        if (!this.draft.isStarted() && this.allJoined()) {
            this.draft.setStarted();
            this.managerFactory.threadExecutor().getTourneyExecutor().execute(this::startDraft);
        }
    }

    private void startDraft() {
        Thread.currentThread().setName("TOURNEY DRAFT " + this.tableId);
        for (Map.Entry entry : this.draftSessions.entrySet()) {
            if (((DraftSession)entry.getValue()).init()) continue;
            logger.fatal((Object)("Unable to initialize client for playerId " + entry.getKey()));
            return;
        }
        this.draft.start();
    }

    private boolean allJoined() {
        if (!this.draft.allJoined()) {
            return false;
        }
        for (DraftPlayer player : this.draft.getPlayers()) {
            if (!player.getPlayer().isHuman() || this.draftSessions.containsKey(player.getPlayer().getId())) continue;
            return false;
        }
        return true;
    }

    private void leave(UUID userId) {
        this.draft.leave(this.getPlayerId(userId));
    }

    private void endDraft() throws MageException {
        for (DraftSession draftSession : this.draftSessions.values()) {
            draftSession.draftOver();
            draftSession.removeDraft();
        }
        this.managerFactory.tableManager().endDraft(this.tableId, this.draft);
        this.managerFactory.draftManager().removeDraft(this.draft.getId());
    }

    public void kill(UUID userId) {
        if (this.userPlayerMap.containsKey(userId)) {
            ((DraftSession)this.draftSessions.get(this.userPlayerMap.get(userId))).setKilled();
            this.draftSessions.remove(this.userPlayerMap.get(userId));
            this.leave(userId);
            this.userPlayerMap.remove(userId);
        }
    }

    public void timeout(UUID userId) {
        if (this.userPlayerMap.containsKey(userId)) {
            UUID cardId;
            DraftSession draftSession = (DraftSession)this.draftSessions.get(this.userPlayerMap.get(userId));
            if (draftSession != null && (cardId = draftSession.getMarkedCard()) != null) {
                this.sendCardPick(userId, cardId, null);
                return;
            }
            this.draft.autoPick((UUID)this.userPlayerMap.get(userId));
            logger.debug((Object)("Draft pick timeout - autopick for player: " + this.userPlayerMap.get(userId)));
        }
    }

    public UUID getSessionId() {
        return this.draftSessionId;
    }

    public DraftPickView sendCardPick(UUID userId, UUID cardId, Set<UUID> hiddenCards) {
        DraftSession draftSession = (DraftSession)this.draftSessions.get(this.userPlayerMap.get(userId));
        if (draftSession != null) {
            draftSession.setMarkedCard(null);
            return draftSession.sendCardPick(cardId, hiddenCards);
        }
        return null;
    }

    public void sendCardMark(UUID userId, UUID cardId) {
        ((DraftSession)this.draftSessions.get(this.userPlayerMap.get(userId))).setMarkedCard(cardId);
    }

    public void setBoosterLoaded(UUID userId) {
        ((DraftSession)this.draftSessions.get(this.userPlayerMap.get(userId))).setBoosterLoaded();
    }

    private synchronized void updateDraft() throws MageException {
        for (Map.Entry entry : this.draftSessions.entrySet()) {
            ((DraftSession)entry.getValue()).update();
        }
    }

    private synchronized void pickCard(UUID playerId, int timeout) throws MageException {
        if (this.draftSessions.containsKey(playerId)) {
            ((DraftSession)this.draftSessions.get(playerId)).pickCard(timeout);
        }
    }

    public UUID getTableId() {
        return this.tableId;
    }

    public void abortDraft() {
        this.draft.setAbort(true);
        try {
            this.endDraft();
        }
        catch (MageException mageException) {
            // empty catch block
        }
    }
}

