/*
 * Decompiled with CFR 0.152.
 */
package mage.server.draft;

import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import mage.game.draft.Draft;
import mage.server.draft.DraftController;
import mage.server.managers.DraftManager;
import mage.server.managers.ManagerFactory;
import mage.view.DraftPickView;

public class DraftManagerImpl
implements DraftManager {
    private final ManagerFactory managerFactory;
    private final ConcurrentMap<UUID, DraftController> draftControllers = new ConcurrentHashMap<UUID, DraftController>();

    public DraftManagerImpl(ManagerFactory managerFactory) {
        this.managerFactory = managerFactory;
    }

    @Override
    public UUID createDraftSession(Draft draft, ConcurrentHashMap<UUID, UUID> userPlayerMap, UUID tableId) {
        DraftController draftController = new DraftController(this.managerFactory, draft, userPlayerMap, tableId);
        this.draftControllers.put(draft.getId(), draftController);
        return draftController.getSessionId();
    }

    @Override
    public void joinDraft(UUID draftId, UUID userId) {
        ((DraftController)this.draftControllers.get(draftId)).join(userId);
    }

    @Override
    public void destroyChatSession(UUID gameId) {
        this.draftControllers.remove(gameId);
    }

    @Override
    public DraftPickView sendCardPick(UUID draftId, UUID userId, UUID cardId, Set<UUID> hiddenCards) {
        return ((DraftController)this.draftControllers.get(draftId)).sendCardPick(userId, cardId, hiddenCards);
    }

    @Override
    public void sendCardMark(UUID draftId, UUID userId, UUID cardId) {
        ((DraftController)this.draftControllers.get(draftId)).sendCardMark(userId, cardId);
    }

    @Override
    public void setBoosterLoaded(UUID draftId, UUID userId) {
        ((DraftController)this.draftControllers.get(draftId)).setBoosterLoaded(userId);
    }

    @Override
    public void removeSession(UUID userId) {
        for (DraftController controller : this.draftControllers.values()) {
            controller.kill(userId);
        }
    }

    @Override
    public void kill(UUID draftId, UUID userId) {
        ((DraftController)this.draftControllers.get(draftId)).kill(userId);
    }

    @Override
    public void timeout(UUID gameId, UUID userId) {
        if (this.draftControllers.containsKey(gameId)) {
            ((DraftController)this.draftControllers.get(gameId)).timeout(userId);
        }
    }

    @Override
    public void removeDraft(UUID draftId) {
        this.draftControllers.remove(draftId);
    }

    @Override
    public DraftController getControllerByDraftId(UUID draftId) {
        return (DraftController)this.draftControllers.get(draftId);
    }

    @Override
    public Optional<DraftController> getController(UUID tableId) {
        return this.draftControllers.values().stream().filter(controller -> controller.getTableId().equals(tableId)).findFirst();
    }
}

