/*
 * Decompiled with CFR 0.152.
 */
package mage.server.game;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import mage.MageException;
import mage.cards.decks.DeckCardLists;
import mage.constants.TableState;
import mage.game.GameException;
import mage.game.Table;
import mage.game.match.MatchOptions;
import mage.game.tournament.TournamentOptions;
import mage.players.PlayerType;
import mage.server.RoomImpl;
import mage.server.User;
import mage.server.game.GamesRoom;
import mage.server.game.TableListSorter;
import mage.server.managers.ManagerFactory;
import mage.util.XmageThreadFactory;
import mage.view.MatchView;
import mage.view.RoomUsersView;
import mage.view.TableView;
import mage.view.UsersView;
import org.apache.log4j.Logger;

public class GamesRoomImpl
extends RoomImpl
implements GamesRoom,
Serializable {
    private static final Logger LOGGER = Logger.getLogger(GamesRoomImpl.class);
    private static final int MAX_FINISHED_TABLES = 25;
    private static List<TableView> lobbyTables = new ArrayList<TableView>();
    private static List<MatchView> lobbyMatches = new ArrayList<MatchView>();
    private static List<RoomUsersView> lobbyUsers = new ArrayList<RoomUsersView>();
    private static final ScheduledExecutorService UPDATE_LOBBY_EXECUTOR = Executors.newSingleThreadScheduledExecutor(new XmageThreadFactory("XMAGE lobby refresh"));
    private final ManagerFactory managerFactory;
    private final ConcurrentHashMap<UUID, Table> tables = new ConcurrentHashMap();

    public GamesRoomImpl(ManagerFactory managerFactory) {
        super(managerFactory.chatManager());
        this.managerFactory = managerFactory;
        UPDATE_LOBBY_EXECUTOR.scheduleAtFixedRate(() -> {
            try {
                this.updateLobby();
            }
            catch (Exception e) {
                LOGGER.fatal((Object)("Games room update error: " + e.getMessage()), (Throwable)e);
            }
        }, 2L, 2L, TimeUnit.SECONDS);
    }

    @Override
    public List<TableView> getTables() {
        return lobbyTables;
    }

    private void updateLobby() {
        ArrayList<Table> allTables = new ArrayList<Table>(this.tables.values());
        allTables.sort(new TableListSorter());
        ArrayList<MatchView> matchList = new ArrayList<MatchView>();
        ArrayList<TableView> tableList = new ArrayList<TableView>();
        for (Table table : allTables) {
            if (table.getState() != TableState.FINISHED) {
                tableList.add(new TableView(table));
                continue;
            }
            if (matchList.size() < 25) {
                matchList.add(new MatchView(table));
                continue;
            }
            if (table.isTournament()) {
                this.managerFactory.tournamentManager().removeTournament(table.getTournament().getId());
            }
            this.removeTable(table.getId());
        }
        lobbyTables = tableList;
        lobbyMatches = matchList;
        ArrayList<UsersView> users = new ArrayList<UsersView>();
        for (User user : this.managerFactory.userManager().getUsers()) {
            if (!user.isOnlineUser()) continue;
            try {
                users.add(new UsersView(user.getUserData().getFlagName(), user.getName(), user.getMatchHistory(), user.getMatchQuitRatio(), user.getTourneyHistory(), user.getTourneyQuitRatio(), user.getGameInfo(), user.getPingInfo(), user.getUserData().getGeneralRating(), user.getUserData().getConstructedRating(), user.getUserData().getLimitedRating()));
            }
            catch (Exception ex) {
                LOGGER.fatal((Object)("User update exception: " + user.getName() + " - " + ex.toString()), (Throwable)ex);
                users.add(new UsersView(user.getUserData() != null && user.getUserData().getFlagName() != null ? user.getUserData().getFlagName() : "world", user.getName() != null ? user.getName() : "<no name>", user.getMatchHistory() != null ? user.getMatchHistory() : "<no match history>", user.getMatchQuitRatio(), user.getTourneyHistory() != null ? user.getTourneyHistory() : "<no tourney history>", user.getTourneyQuitRatio(), "[exception]", user.getPingInfo() != null ? user.getPingInfo() : "<no ping>", user.getUserData() != null ? user.getUserData().getGeneralRating() : 0, user.getUserData() != null ? user.getUserData().getConstructedRating() : 0, user.getUserData() != null ? user.getUserData().getLimitedRating() : 0));
            }
        }
        users.sort((one, two) -> one.getUserName().compareToIgnoreCase(two.getUserName()));
        ArrayList<RoomUsersView> arrayList = new ArrayList<RoomUsersView>();
        arrayList.add(new RoomUsersView(users, this.managerFactory.gameManager().getNumberActiveGames(), this.managerFactory.threadExecutor().getActiveThreads(this.managerFactory.threadExecutor().getGameExecutor()), this.managerFactory.configSettings().getMaxGameThreads()));
        lobbyUsers = arrayList;
    }

    @Override
    public List<MatchView> getFinished() {
        return lobbyMatches;
    }

    @Override
    public boolean joinTable(UUID userId, UUID tableId, String name, PlayerType playerType, int skill, DeckCardLists deckList, String password) throws MageException {
        if (this.tables.containsKey(tableId)) {
            return this.managerFactory.tableManager().joinTable(userId, tableId, name, playerType, skill, deckList, password);
        }
        return false;
    }

    @Override
    public TableView createTable(UUID userId, MatchOptions options) {
        Table table = this.managerFactory.tableManager().createTable(this.getRoomId(), userId, options);
        this.tables.put(table.getId(), table);
        return new TableView(table);
    }

    @Override
    public boolean joinTournamentTable(UUID userId, UUID tableId, String name, PlayerType playerType, int skill, DeckCardLists deckList, String password) throws GameException {
        if (this.tables.containsKey(tableId)) {
            return this.managerFactory.tableManager().joinTournament(userId, tableId, name, playerType, skill, deckList, password);
        }
        return false;
    }

    @Override
    public TableView createTournamentTable(UUID userId, TournamentOptions options) {
        Table table = this.managerFactory.tableManager().createTournamentTable(this.getRoomId(), userId, options);
        this.tables.put(table.getId(), table);
        return new TableView(table);
    }

    @Override
    public Optional<TableView> getTable(UUID tableId) {
        if (this.tables.containsKey(tableId)) {
            return Optional.of(new TableView(this.tables.get(tableId)));
        }
        return Optional.empty();
    }

    @Override
    public void removeTable(UUID userId, UUID tableId) {
        this.tables.remove(tableId);
    }

    @Override
    public void removeTable(UUID tableId) {
        Table table = this.tables.get(tableId);
        if (table != null) {
            table.cleanUp();
            this.tables.remove(tableId);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Table removed: " + tableId));
            }
        }
    }

    @Override
    public void leaveTable(UUID userId, UUID tableId) {
        this.managerFactory.tableManager().leaveTable(userId, tableId);
    }

    @Override
    public boolean watchTable(UUID userId, UUID tableId) throws MageException {
        return this.managerFactory.tableManager().watchTable(userId, tableId);
    }

    @Override
    public List<RoomUsersView> getRoomUsersInfo() {
        return lobbyUsers;
    }
}

