/*
 * Decompiled with CFR 0.152.
 */
package mage.server.game;

import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import mage.server.game.GamesRoom;
import mage.server.game.GamesRoomImpl;
import mage.server.managers.GamesRoomManager;
import mage.server.managers.ManagerFactory;
import org.apache.log4j.Logger;

public class GamesRoomManagerImpl
implements GamesRoomManager {
    private final ManagerFactory managerFactory;
    private final ConcurrentHashMap<UUID, GamesRoom> rooms = new ConcurrentHashMap();
    private UUID mainRoomId;
    private UUID mainChatId;
    private static final Logger logger = Logger.getLogger(GamesRoomManagerImpl.class);

    public GamesRoomManagerImpl(ManagerFactory managerFactory) {
        this.managerFactory = managerFactory;
    }

    public void init() {
        GamesRoomImpl mainRoom = new GamesRoomImpl(this.managerFactory);
        this.mainRoomId = mainRoom.getRoomId();
        this.mainChatId = mainRoom.getChatId();
        this.rooms.put(this.mainRoomId, mainRoom);
    }

    @Override
    public UUID createRoom() {
        GamesRoomImpl room = new GamesRoomImpl(this.managerFactory);
        this.rooms.put(room.getRoomId(), room);
        return room.getRoomId();
    }

    @Override
    public UUID getMainRoomId() {
        return this.mainRoomId;
    }

    @Override
    public UUID getMainChatId() {
        return this.mainChatId;
    }

    @Override
    public Optional<GamesRoom> getRoom(UUID roomId) {
        if (this.rooms.containsKey(roomId)) {
            return Optional.of(this.rooms.get(roomId));
        }
        logger.warn((Object)("room not found : " + roomId));
        return Optional.empty();
    }

    @Override
    public void removeTable(UUID tableId) {
        for (GamesRoom room : this.rooms.values()) {
            room.removeTable(tableId);
        }
    }
}

