/*
 * Decompiled with CFR 0.152.
 */
package mage.server.game;

import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import mage.server.game.ReplaySession;
import mage.server.managers.ManagerFactory;
import mage.server.managers.ReplayManager;

public class ReplayManagerImpl
implements ReplayManager {
    private final ConcurrentHashMap<String, ReplaySession> replaySessions = new ConcurrentHashMap();
    private final ManagerFactory managerFactory;

    public ReplayManagerImpl(ManagerFactory managerFactory) {
        this.managerFactory = managerFactory;
    }

    @Override
    public void replayGame(UUID gameId, UUID userId) {
        ReplaySession replaySession = new ReplaySession(this.managerFactory, gameId, userId);
        this.replaySessions.put(gameId.toString() + userId.toString(), replaySession);
        this.managerFactory.userManager().getUser(userId).ifPresent(user -> user.ccReplayGame(gameId));
    }

    @Override
    public void startReplay(UUID gameId, UUID userId) {
        this.replaySessions.get(gameId.toString() + userId.toString()).replay();
    }

    @Override
    public void stopReplay(UUID gameId, UUID userId) {
        this.replaySessions.get(gameId.toString() + userId.toString()).stop();
    }

    @Override
    public void nextPlay(UUID gameId, UUID userId) {
        this.replaySessions.get(gameId.toString() + userId.toString()).next();
    }

    @Override
    public void previousPlay(UUID gameId, UUID userId) {
        this.replaySessions.get(gameId.toString() + userId.toString()).previous();
    }

    @Override
    public void skipForward(UUID gameId, UUID userId, int moves) {
        this.replaySessions.get(gameId.toString() + userId.toString()).next(moves);
    }

    @Override
    public void endReplay(UUID gameId, UUID userId) {
        this.replaySessions.remove(gameId.toString() + userId.toString());
    }
}

