/*
 * Decompiled with CFR 0.152.
 */
package mage.server.game;

import java.util.UUID;
import mage.game.Game;
import mage.game.GameState;
import mage.interfaces.callback.ClientCallback;
import mage.interfaces.callback.ClientCallbackMethod;
import mage.server.game.GameCallback;
import mage.server.game.GameReplay;
import mage.server.managers.ManagerFactory;
import mage.view.GameView;

public class ReplaySession
implements GameCallback {
    private final ManagerFactory managerFactory;
    private final GameReplay replay;
    protected final UUID userId;

    ReplaySession(ManagerFactory managerFactory, UUID gameId, UUID userId) {
        this.managerFactory = managerFactory;
        this.replay = new GameReplay(gameId);
        this.userId = userId;
    }

    public void replay() {
        this.replay.start();
        this.managerFactory.userManager().getUser(this.userId).ifPresent(user -> user.fireCallback(new ClientCallback(ClientCallbackMethod.REPLAY_INIT, this.replay.getGame().getId(), (Object)new GameView(this.replay.next(), this.replay.getGame(), null, null))));
    }

    public void stop() {
        this.endGameWithResult("stopped replay");
    }

    public synchronized void next() {
        this.updateGame(this.replay.next(), this.replay.getGame());
    }

    public synchronized void next(int moves) {
        for (int i = 0; i < moves; ++i) {
            this.replay.next();
        }
        this.updateGame(this.replay.next(), this.replay.getGame());
    }

    public synchronized void previous() {
        this.updateGame(this.replay.previous(), this.replay.getGame());
    }

    @Override
    public void endGameWithResult(String result) {
        this.managerFactory.userManager().getUser(this.userId).ifPresent(user -> user.fireCallback(new ClientCallback(ClientCallbackMethod.REPLAY_DONE, this.replay.getGame().getId(), (Object)result)));
        this.managerFactory.replayManager().endReplay(this.replay.getGame().getId(), this.userId);
    }

    private void updateGame(GameState state, Game game) {
        if (state == null) {
            this.endGameWithResult("game ended");
        } else {
            this.managerFactory.userManager().getUser(this.userId).ifPresent(user -> user.fireCallback(new ClientCallback(ClientCallbackMethod.REPLAY_UPDATE, this.replay.getGame().getId(), (Object)new GameView(state, game, null, null))));
        }
    }
}

