/*
 * Decompiled with CFR 0.152.
 */
package mage.server.record;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.jdbc.JdbcConnectionSource;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.SelectArg;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.support.DatabaseConnection;
import com.j256.ormlite.table.TableUtils;
import java.io.File;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import mage.cards.repository.DatabaseUtils;
import mage.cards.repository.RepositoryUtil;
import mage.server.record.TableRecord;
import org.apache.log4j.Logger;

public enum TableRecordRepository {
    instance;

    private static final String VERSION_ENTITY_NAME = "table_record";
    private static final long DB_VERSION = 0L;
    private Dao<TableRecord, Object> recordsDao;

    private TableRecordRepository() {
        File file = new File("db");
        if (!file.exists()) {
            file.mkdirs();
        }
        try {
            JdbcConnectionSource connectionSource = new JdbcConnectionSource(DatabaseUtils.prepareSqliteConnection("table_record.db"));
            boolean obsolete = RepositoryUtil.isDatabaseObsolete((ConnectionSource)connectionSource, VERSION_ENTITY_NAME, 0L);
            if (obsolete) {
                TableUtils.dropTable((ConnectionSource)connectionSource, TableRecord.class, (boolean)true);
            }
            TableUtils.createTableIfNotExists((ConnectionSource)connectionSource, TableRecord.class);
            this.recordsDao = DaoManager.createDao((ConnectionSource)connectionSource, TableRecord.class);
        }
        catch (SQLException ex) {
            Logger.getLogger(TableRecordRepository.class).error((Object)"Error creating table_record repository - ", (Throwable)ex);
        }
    }

    public void add(TableRecord tableHistory) {
        try {
            this.recordsDao.create((Object)tableHistory);
        }
        catch (SQLException ex) {
            Logger.getLogger(TableRecordRepository.class).error((Object)"Error adding a table_record to DB - ", (Throwable)ex);
        }
    }

    public List<TableRecord> getAfter(long endTimeMs) {
        try {
            QueryBuilder qb = this.recordsDao.queryBuilder();
            qb.where().gt("endTimeMs", (Object)new SelectArg((Object)endTimeMs));
            qb.orderBy("endTimeMs", true);
            return this.recordsDao.query(qb.prepare());
        }
        catch (SQLException ex) {
            Logger.getLogger(TableRecordRepository.class).error((Object)"Error getting table_records from DB - ", (Throwable)ex);
            return Collections.emptyList();
        }
    }

    public void closeDB() {
        try {
            if (this.recordsDao != null && this.recordsDao.getConnectionSource() != null) {
                DatabaseConnection conn = this.recordsDao.getConnectionSource().getReadWriteConnection(this.recordsDao.getTableName());
                conn.executeStatement("SHUTDOWN IMMEDIATELY", -1);
                this.recordsDao.getConnectionSource().releaseConnection(conn);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(TableRecordRepository.class).error((Object)"Error closing table_record repository - ", (Throwable)ex);
        }
    }
}

