/*
 * Decompiled with CFR 0.152.
 */
package mage.server.record;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.jdbc.JdbcConnectionSource;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.SelectArg;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.support.DatabaseConnection;
import com.j256.ormlite.table.TableUtils;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import mage.cards.repository.DatabaseUtils;
import mage.cards.repository.RepositoryUtil;
import mage.game.result.ResultProtos;
import mage.server.rating.GlickoRating;
import mage.server.rating.GlickoRatingSystem;
import mage.server.record.TableRecord;
import mage.server.record.TableRecordRepository;
import mage.server.record.UserStats;
import org.apache.log4j.Logger;

public enum UserStatsRepository {
    instance;

    private static final String VERSION_ENTITY_NAME = "user_stats";
    private static final long DB_VERSION = 0L;
    private Dao<UserStats, Object> statsDao;

    private UserStatsRepository() {
        File file = new File("db");
        if (!file.exists()) {
            file.mkdirs();
        }
        try {
            JdbcConnectionSource connectionSource = new JdbcConnectionSource(DatabaseUtils.prepareSqliteConnection("user_stats.db"));
            boolean obsolete = RepositoryUtil.isDatabaseObsolete((ConnectionSource)connectionSource, VERSION_ENTITY_NAME, 0L);
            if (obsolete) {
                TableUtils.dropTable((ConnectionSource)connectionSource, UserStats.class, (boolean)true);
            }
            TableUtils.createTableIfNotExists((ConnectionSource)connectionSource, UserStats.class);
            this.statsDao = DaoManager.createDao((ConnectionSource)connectionSource, UserStats.class);
        }
        catch (SQLException ex) {
            Logger.getLogger(UserStatsRepository.class).error((Object)"Error creating user_stats repository - ", (Throwable)ex);
        }
    }

    public void add(UserStats userStats) {
        try {
            this.statsDao.create((Object)userStats);
        }
        catch (SQLException ex) {
            Logger.getLogger(UserStatsRepository.class).error((Object)"Error adding a user_stats to DB - ", (Throwable)ex);
        }
    }

    public void update(UserStats userStats) {
        try {
            this.statsDao.update((Object)userStats);
        }
        catch (SQLException ex) {
            Logger.getLogger(UserStatsRepository.class).error((Object)"Error updating a user_stats in DB - ", (Throwable)ex);
        }
    }

    public UserStats getUser(String userName) {
        try {
            QueryBuilder qb = this.statsDao.queryBuilder();
            qb.limit(Long.valueOf(1L)).where().eq("userName", (Object)new SelectArg((Object)userName));
            List users = this.statsDao.query(qb.prepare());
            if (!users.isEmpty()) {
                return (UserStats)users.get(0);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UserStatsRepository.class).error((Object)"Error getting a user from DB - ", (Throwable)ex);
        }
        return null;
    }

    public List<UserStats> getAllUsers() {
        try {
            QueryBuilder qb = this.statsDao.queryBuilder();
            return this.statsDao.query(qb.prepare());
        }
        catch (SQLException ex) {
            Logger.getLogger(UserStatsRepository.class).error((Object)"Error getting all users from DB - ", (Throwable)ex);
            return Collections.emptyList();
        }
    }

    public long getLatestEndTimeMs() {
        try {
            QueryBuilder qb = this.statsDao.queryBuilder();
            qb.orderBy("endTimeMs", false).limit(Long.valueOf(1L));
            List users = this.statsDao.query(qb.prepare());
            if (!users.isEmpty()) {
                return ((UserStats)users.get(0)).getEndTimeMs();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UserStatsRepository.class).error((Object)"Error getting the latest end time from DB - ", (Throwable)ex);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> updateUserStats() {
        HashSet<String> updatedUsers = new HashSet<String>();
        UserStatsRepository userStatsRepository = this;
        synchronized (userStatsRepository) {
            long latestEndTimeMs = this.getLatestEndTimeMs();
            List<TableRecord> records = TableRecordRepository.instance.getAfter(latestEndTimeMs);
            for (TableRecord record : records) {
                ResultProtos.UserStatsProto.Builder builder;
                ResultProtos.UserStatsProto proto;
                UserStats userStats;
                ResultProtos.TableProto table = record.getProto();
                if (table.getControllerName().equals("System")) continue;
                if (table.hasMatch()) {
                    ResultProtos.MatchProto match = table.getMatch();
                    for (ResultProtos.MatchPlayerProto matchPlayerProto : match.getPlayersList()) {
                        userStats = this.getUser(matchPlayerProto.getName());
                        proto = userStats != null ? userStats.getProto() : ResultProtos.UserStatsProto.newBuilder().setName(matchPlayerProto.getName()).build();
                        builder = ResultProtos.UserStatsProto.newBuilder(proto).setMatches(proto.getMatches() + 1);
                        switch (matchPlayerProto.getQuit()) {
                            case IDLE_TIMEOUT: {
                                builder.setMatchesIdleTimeout(proto.getMatchesIdleTimeout() + 1);
                                break;
                            }
                            case TIMER_TIMEOUT: {
                                builder.setMatchesTimerTimeout(proto.getMatchesTimerTimeout() + 1);
                                break;
                            }
                            case QUIT: {
                                builder.setMatchesQuit(proto.getMatchesQuit() + 1);
                            }
                        }
                        if (userStats == null) {
                            this.add(new UserStats(builder.build(), table.getEndTimeMs()));
                        } else {
                            this.update(new UserStats(builder.build(), table.getEndTimeMs()));
                        }
                        updatedUsers.add(matchPlayerProto.getName());
                    }
                    this.updateRating(match, table.getEndTimeMs());
                    continue;
                }
                if (!table.hasTourney()) continue;
                ResultProtos.TourneyProto tourney = table.getTourney();
                for (ResultProtos.TourneyPlayerProto tourneyPlayerProto : tourney.getPlayersList()) {
                    userStats = this.getUser(tourneyPlayerProto.getName());
                    proto = userStats != null ? userStats.getProto() : ResultProtos.UserStatsProto.newBuilder().setName(tourneyPlayerProto.getName()).build();
                    builder = ResultProtos.UserStatsProto.newBuilder(proto).setTourneys(proto.getTourneys() + 1);
                    switch (tourneyPlayerProto.getQuit()) {
                        case DURING_ROUND: {
                            builder.setTourneysQuitDuringRound(proto.getTourneysQuitDuringRound() + 1);
                            break;
                        }
                        case DURING_DRAFTING: {
                            builder.setTourneysQuitDuringDrafting(proto.getTourneysQuitDuringDrafting() + 1);
                            break;
                        }
                        case DURING_CONSTRUCTION: {
                            builder.setTourneysQuitDuringConstruction(proto.getTourneysQuitDuringConstruction() + 1);
                        }
                    }
                    if (userStats == null) {
                        this.add(new UserStats(builder.build(), table.getEndTimeMs()));
                    } else {
                        this.update(new UserStats(builder.build(), table.getEndTimeMs()));
                    }
                    updatedUsers.add(tourneyPlayerProto.getName());
                }
                for (ResultProtos.TourneyRoundProto tourneyRoundProto : tourney.getRoundsList()) {
                    for (ResultProtos.MatchProto match : tourneyRoundProto.getMatchesList()) {
                        this.updateRating(match, table.getEndTimeMs());
                    }
                }
            }
        }
        return new ArrayList<String>(updatedUsers);
    }

    private void updateRating(ResultProtos.MatchProto match, long tableEndTimeMs) {
        long matchEndTimeMs = match.hasEndTimeMs() ? match.getEndTimeMs() : tableEndTimeMs;
        if (!match.hasMatchOptions()) {
            return;
        }
        ResultProtos.MatchOptionsProto matchOptions = match.getMatchOptions();
        if (!matchOptions.getRated()) {
            return;
        }
        if (match.getPlayersCount() != 2) {
            return;
        }
        ResultProtos.MatchPlayerProto player1 = match.getPlayers(0);
        ResultProtos.MatchPlayerProto player2 = match.getPlayers(1);
        if (!player1.getHuman() || !player2.getHuman()) {
            return;
        }
        double outcome = player1.getQuit() == ResultProtos.MatchQuitStatus.NO_MATCH_QUIT && player1.getWins() > player2.getWins() || player2.getQuit() != ResultProtos.MatchQuitStatus.NO_MATCH_QUIT ? 1.0 : (player2.getQuit() == ResultProtos.MatchQuitStatus.NO_MATCH_QUIT && player1.getWins() < player2.getWins() || player1.getQuit() != ResultProtos.MatchQuitStatus.NO_MATCH_QUIT ? 0.0 : 0.5);
        UserStats player1Stats = this.getOrCreateUserStats(player1.getName(), tableEndTimeMs);
        ResultProtos.UserStatsProto player1StatsProto = player1Stats.getProto();
        UserStats player2Stats = this.getOrCreateUserStats(player2.getName(), tableEndTimeMs);
        ResultProtos.UserStatsProto player2StatsProto = player2Stats.getProto();
        ResultProtos.UserStatsProto.Builder player1StatsBuilder = ResultProtos.UserStatsProto.newBuilder(player1StatsProto);
        ResultProtos.UserStatsProto.Builder player2StatsBuilder = ResultProtos.UserStatsProto.newBuilder(player2StatsProto);
        ResultProtos.GlickoRatingProto player1GeneralRatingProto = null;
        if (player1StatsProto.hasGeneralGlickoRating()) {
            player1GeneralRatingProto = player1StatsProto.getGeneralGlickoRating();
        }
        ResultProtos.GlickoRatingProto player2GeneralRatingProto = null;
        if (player2StatsProto.hasGeneralGlickoRating()) {
            player2GeneralRatingProto = player2StatsProto.getGeneralGlickoRating();
        }
        ResultProtos.GlickoRatingProto.Builder player1GeneralGlickoRatingBuilder = player1StatsBuilder.getGeneralGlickoRatingBuilder();
        ResultProtos.GlickoRatingProto.Builder player2GeneralGlickoRatingBuilder = player2StatsBuilder.getGeneralGlickoRatingBuilder();
        this.updateRating(player1GeneralRatingProto, player2GeneralRatingProto, outcome, matchEndTimeMs, player1GeneralGlickoRatingBuilder, player2GeneralGlickoRatingBuilder);
        if (matchOptions.hasLimited()) {
            if (matchOptions.getLimited()) {
                ResultProtos.GlickoRatingProto player1LimitedRatingProto = null;
                if (player1StatsProto.hasLimitedGlickoRating()) {
                    player1LimitedRatingProto = player1StatsProto.getLimitedGlickoRating();
                }
                ResultProtos.GlickoRatingProto player2LimitedRatingProto = null;
                if (player2StatsProto.hasLimitedGlickoRating()) {
                    player2LimitedRatingProto = player2StatsProto.getLimitedGlickoRating();
                }
                ResultProtos.GlickoRatingProto.Builder player1LimitedGlickoRatingBuilder = player1StatsBuilder.getLimitedGlickoRatingBuilder();
                ResultProtos.GlickoRatingProto.Builder player2LimitedGlickoRatingBuilder = player2StatsBuilder.getLimitedGlickoRatingBuilder();
                this.updateRating(player1LimitedRatingProto, player2LimitedRatingProto, outcome, matchEndTimeMs, player1LimitedGlickoRatingBuilder, player2LimitedGlickoRatingBuilder);
            } else {
                ResultProtos.GlickoRatingProto player1ConstructedRatingProto = null;
                if (player1StatsProto.hasConstructedGlickoRating()) {
                    player1ConstructedRatingProto = player1StatsProto.getConstructedGlickoRating();
                }
                ResultProtos.GlickoRatingProto player2ConstructedRatingProto = null;
                if (player2StatsProto.hasConstructedGlickoRating()) {
                    player2ConstructedRatingProto = player2StatsProto.getConstructedGlickoRating();
                }
                ResultProtos.GlickoRatingProto.Builder player1ConstructedGlickoRatingBuilder = player1StatsBuilder.getConstructedGlickoRatingBuilder();
                ResultProtos.GlickoRatingProto.Builder player2ConstructedGlickoRatingBuilder = player2StatsBuilder.getConstructedGlickoRatingBuilder();
                this.updateRating(player1ConstructedRatingProto, player2ConstructedRatingProto, outcome, matchEndTimeMs, player1ConstructedGlickoRatingBuilder, player2ConstructedGlickoRatingBuilder);
            }
        }
        this.update(new UserStats(player1StatsBuilder.build(), player1Stats.getEndTimeMs()));
        this.update(new UserStats(player2StatsBuilder.build(), player2Stats.getEndTimeMs()));
    }

    private void updateRating(ResultProtos.GlickoRatingProto player1RatingProto, ResultProtos.GlickoRatingProto player2RatingProto, double outcome, long tableEndTimeMs, ResultProtos.GlickoRatingProto.Builder player1GlickoRatingBuilder, ResultProtos.GlickoRatingProto.Builder player2GlickoRatingBuilder) {
        GlickoRating player1GlickoRating = player1RatingProto != null ? new GlickoRating(player1RatingProto.getRating(), player1RatingProto.getRatingDeviation(), player1RatingProto.getLastGameTimeMs()) : GlickoRatingSystem.getInitialRating();
        GlickoRating player2GlickoRating = player2RatingProto != null ? new GlickoRating(player2RatingProto.getRating(), player2RatingProto.getRatingDeviation(), player2RatingProto.getLastGameTimeMs()) : GlickoRatingSystem.getInitialRating();
        GlickoRatingSystem glickoRatingSystem = new GlickoRatingSystem();
        glickoRatingSystem.updateRating(player1GlickoRating, player2GlickoRating, outcome, tableEndTimeMs);
        player1GlickoRatingBuilder.setRating(player1GlickoRating.getRating()).setRatingDeviation(player1GlickoRating.getRatingDeviation()).setLastGameTimeMs(tableEndTimeMs);
        player2GlickoRatingBuilder.setRating(player2GlickoRating.getRating()).setRatingDeviation(player2GlickoRating.getRatingDeviation()).setLastGameTimeMs(tableEndTimeMs);
    }

    private UserStats getOrCreateUserStats(String playerName, long endTimeMs) {
        UserStats userStats = this.getUser(playerName);
        if (userStats == null) {
            ResultProtos.UserStatsProto userStatsProto = ResultProtos.UserStatsProto.newBuilder().setName(playerName).build();
            userStats = new UserStats(userStatsProto, endTimeMs);
            this.add(userStats);
        }
        return userStats;
    }

    public void closeDB() {
        try {
            if (this.statsDao != null && this.statsDao.getConnectionSource() != null) {
                DatabaseConnection conn = this.statsDao.getConnectionSource().getReadWriteConnection(this.statsDao.getTableName());
                conn.executeStatement("SHUTDOWN IMMEDIATELY", -1);
                this.statsDao.getConnectionSource().releaseConnection(conn);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UserStatsRepository.class).error((Object)"Error closing user_stats repository - ", (Throwable)ex);
        }
    }
}

