/*
 * Decompiled with CFR 0.152.
 */
package mage.server.tournament;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import mage.cards.Sets;
import mage.game.draft.DraftCube;
import mage.game.tournament.Tournament;
import mage.game.tournament.TournamentOptions;
import mage.game.tournament.TournamentType;
import mage.server.draft.CubeFactory;
import mage.view.TournamentTypeView;
import org.apache.log4j.Logger;

public enum TournamentFactory {
    instance;

    private static final Logger logger;
    private final Map<String, Class<Tournament>> tournaments = new HashMap<String, Class<Tournament>>();
    private final Map<String, TournamentType> tournamentTypes = new HashMap<String, TournamentType>();
    private final List<TournamentTypeView> tournamentTypeViews = new ArrayList<TournamentTypeView>();

    public Tournament createTournament(String tournamentType, TournamentOptions options) {
        Tournament tournament;
        try {
            Constructor<Tournament> con = this.tournaments.get(tournamentType).getConstructor(TournamentOptions.class);
            tournament = con.newInstance(options);
            tournament.setTournamentType(this.tournamentTypes.get(tournamentType));
            if (tournament.getTournamentType().isLimited()) {
                StringBuilder rv;
                LinkedHashMap<String, Integer> setInfo = new LinkedHashMap<String, Integer>();
                for (String setCode : options.getLimitedOptions().getSetCodes()) {
                    tournament.getSets().add(Sets.findSet(setCode));
                    int count = setInfo.getOrDefault(setCode, 0);
                    setInfo.put(setCode, count + 1);
                }
                tournament.getOptions().getLimitedOptions().setNumberBoosters(tournament.getTournamentType().getNumBoosters());
                if (tournament.getTournamentType().isCubeBooster()) {
                    DraftCube draftCube = tournament.getOptions().getLimitedOptions().getCubeFromDeck() != null ? CubeFactory.instance.createDeckDraftCube(tournament.getOptions().getLimitedOptions().getDraftCubeName(), tournament.getOptions().getLimitedOptions().getCubeFromDeck()) : CubeFactory.instance.createDraftCube(tournament.getOptions().getLimitedOptions().getDraftCubeName());
                    String boosterInfo = "";
                    if (draftCube != null) {
                        draftCube.validateData();
                        tournament.getOptions().getLimitedOptions().setDraftCube(draftCube);
                        boosterInfo = draftCube.getName();
                    }
                    tournament.setBoosterInfo(boosterInfo);
                } else if (tournament.getTournamentType().isRandom()) {
                    rv = new StringBuilder("Chaos Draft using sets: ");
                    for (Map.Entry entry : setInfo.entrySet()) {
                        rv.append((String)entry.getKey());
                        rv.append(';');
                    }
                    tournament.setBoosterInfo(rv.toString());
                } else if (tournament.getTournamentType().isReshuffled()) {
                    rv = new StringBuilder("Chaos Reshuffled Draft using sets: ");
                    for (Map.Entry entry : setInfo.entrySet()) {
                        rv.append((String)entry.getKey());
                        rv.append(';');
                    }
                    tournament.setBoosterInfo(rv.toString());
                } else {
                    StringBuilder sb = new StringBuilder();
                    for (Map.Entry entry : setInfo.entrySet()) {
                        sb.append(((Integer)entry.getValue()).toString()).append('x').append((String)entry.getKey()).append(' ');
                    }
                    tournament.setBoosterInfo(sb.toString());
                }
            } else {
                tournament.setBoosterInfo("");
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't create new tourney: " + e, e);
        }
        return tournament;
    }

    public List<TournamentTypeView> getTournamentTypes() {
        return this.tournamentTypeViews;
    }

    public void addTournamentType(String name, TournamentType tournamentType, Class tournament) {
        if (tournamentType != null && tournament != null) {
            this.tournaments.put(name, tournament);
            this.tournamentTypes.put(name, tournamentType);
            this.tournamentTypeViews.add(new TournamentTypeView(tournamentType));
        }
    }

    static {
        logger = Logger.getLogger(TournamentFactory.class);
    }
}

