/*
 * Decompiled with CFR 0.152.
 */
package mage.server.tournament;

import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import mage.cards.decks.Deck;
import mage.game.tournament.Tournament;
import mage.server.managers.ManagerFactory;
import mage.server.managers.TournamentManager;
import mage.server.tournament.TournamentController;
import mage.view.TournamentView;
import org.apache.log4j.Logger;

public class TournamentManagerImpl
implements TournamentManager {
    private final ManagerFactory managerFactory;
    private final ConcurrentMap<UUID, TournamentController> controllers = new ConcurrentHashMap<UUID, TournamentController>();

    public TournamentManagerImpl(ManagerFactory managerFactory) {
        this.managerFactory = managerFactory;
    }

    @Override
    public Optional<TournamentController> getTournamentController(UUID tournamentId) {
        return Optional.ofNullable(this.controllers.get(tournamentId));
    }

    @Override
    public void createTournamentSession(Tournament tournament, ConcurrentHashMap<UUID, UUID> userPlayerMap, UUID tableId) {
        TournamentController tournamentController = new TournamentController(this.managerFactory, tournament, userPlayerMap, tableId);
        this.controllers.put(tournament.getId(), tournamentController);
    }

    @Override
    public void joinTournament(UUID tournamentId, UUID userId) {
        ((TournamentController)this.controllers.get(tournamentId)).join(userId);
    }

    @Override
    public void quit(UUID tournamentId, UUID userId) {
        TournamentController tournamentController = (TournamentController)this.controllers.get(tournamentId);
        if (tournamentController != null) {
            tournamentController.quit(userId);
        } else {
            Logger.getLogger(TournamentManagerImpl.class).error((Object)("Tournament controller missing  tournamentid: " + tournamentId + " userId: " + userId));
        }
    }

    @Override
    public void timeout(UUID tournamentId, UUID userId) {
        ((TournamentController)this.controllers.get(tournamentId)).timeout(userId);
    }

    @Override
    public void submitDeck(UUID tournamentId, UUID playerId, Deck deck) {
        ((TournamentController)this.controllers.get(tournamentId)).submitDeck(playerId, deck);
    }

    @Override
    public void updateDeck(UUID tournamentId, UUID playerId, Deck deck, boolean ignoreMainBasicLands) {
        ((TournamentController)this.controllers.get(tournamentId)).updateDeck(playerId, deck, ignoreMainBasicLands);
    }

    @Override
    public TournamentView getTournamentView(UUID tournamentId) {
        TournamentController tournamentController = (TournamentController)this.controllers.get(tournamentId);
        if (tournamentController != null) {
            return tournamentController.getTournamentView();
        }
        return null;
    }

    @Override
    public Optional<UUID> getChatId(UUID tournamentId) {
        if (this.controllers.containsKey(tournamentId)) {
            return Optional.of(((TournamentController)this.controllers.get(tournamentId)).getChatId());
        }
        return Optional.empty();
    }

    @Override
    public void removeTournament(UUID tournamentId) {
        TournamentController tournamentController = (TournamentController)this.controllers.get(tournamentId);
        if (tournamentController != null) {
            this.controllers.remove(tournamentId);
            tournamentController.cleanUpOnRemoveTournament();
        }
    }
}

