/*
 * Decompiled with CFR 0.152.
 */
package mage.server.tournament;

import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import mage.cards.decks.Deck;
import mage.game.tournament.Tournament;
import mage.interfaces.callback.ClientCallback;
import mage.interfaces.callback.ClientCallbackMethod;
import mage.server.User;
import mage.server.managers.ManagerFactory;
import mage.view.TournamentView;
import org.apache.log4j.Logger;

public class TournamentSession {
    protected static final Logger logger = Logger.getLogger(TournamentSession.class);
    private final ManagerFactory managerFactory;
    protected final UUID userId;
    protected final UUID playerId;
    protected final UUID tableId;
    protected final Tournament tournament;
    protected boolean killed = false;
    private ScheduledFuture<?> futureTimeout;
    protected final ScheduledExecutorService timeoutExecutor;

    public TournamentSession(ManagerFactory managerFactory, Tournament tournament, UUID userId, UUID tableId, UUID playerId) {
        this.managerFactory = managerFactory;
        this.timeoutExecutor = managerFactory.threadExecutor().getTimeoutExecutor();
        this.userId = userId;
        this.tournament = tournament;
        this.playerId = playerId;
        this.tableId = tableId;
    }

    public boolean init() {
        Optional<User> user;
        if (!this.killed && (user = this.managerFactory.userManager().getUser(this.userId)).isPresent()) {
            user.get().fireCallback(new ClientCallback(ClientCallbackMethod.TOURNAMENT_INIT, this.tournament.getId(), (Object)this.getTournamentView()));
            return true;
        }
        return false;
    }

    public void update() {
        if (!this.killed) {
            this.managerFactory.userManager().getUser(this.userId).ifPresent(user -> user.fireCallback(new ClientCallback(ClientCallbackMethod.TOURNAMENT_UPDATE, this.tournament.getId(), (Object)this.getTournamentView())));
        }
    }

    public void gameOver(String message) {
        if (!this.killed) {
            this.managerFactory.userManager().getUser(this.userId).ifPresent(user -> user.fireCallback(new ClientCallback(ClientCallbackMethod.TOURNAMENT_OVER, this.tournament.getId(), (Object)message)));
        }
    }

    public void construct(int timeout) {
        if (!this.killed) {
            this.setupTimeout(timeout);
            this.managerFactory.userManager().getUser(this.userId).ifPresent(user -> {
                int remaining = (int)this.futureTimeout.getDelay(TimeUnit.SECONDS);
                Deck lastDeck = this.tournament.getPlayer(this.playerId).getDeck();
                if (!this.tournament.isDoneConstructing() && lastDeck != null) {
                    user.ccConstruct(lastDeck, this.tableId, null, remaining);
                } else {
                    logger.error((Object)("Found bad state on reconnection: player has tournament session, but don't have deck, deck " + lastDeck + ", user " + user.getName() + ", state " + this.tournament.getTournamentState() + ", t type " + this.tournament.getTournamentType() + ", t id " + this.tournament.getId()));
                }
            });
        }
    }

    public void submitDeck(Deck deck) {
        this.cancelTimeout();
        this.tournament.submitDeck(this.playerId, deck);
    }

    public void updateDeck(Deck deck, boolean ignoreMainBasicLands) {
        this.tournament.updateDeck(this.playerId, deck, ignoreMainBasicLands);
    }

    public void setKilled() {
        this.killed = true;
    }

    public boolean isKilled() {
        return this.killed;
    }

    private synchronized void setupTimeout(int seconds) {
        if (this.futureTimeout != null && !this.futureTimeout.isDone()) {
            return;
        }
        this.cancelTimeout();
        if (seconds > 0) {
            this.futureTimeout = this.timeoutExecutor.schedule(() -> {
                try {
                    this.managerFactory.tournamentManager().timeout(this.tournament.getId(), this.userId);
                }
                catch (Exception e) {
                    logger.fatal((Object)("TournamentSession error - userId " + this.userId + " tId " + this.tournament.getId()), (Throwable)e);
                }
            }, (long)seconds, TimeUnit.SECONDS);
        }
    }

    private synchronized void cancelTimeout() {
        if (this.futureTimeout != null) {
            this.futureTimeout.cancel(false);
            logger.debug((Object)("Timeout is Done: " + this.futureTimeout.isDone() + "  userId: " + this.userId));
        }
    }

    private TournamentView getTournamentView() {
        return new TournamentView(this.tournament);
    }

    public UUID getTournamentId() {
        return this.tournament.getId();
    }

    public void tournamentOver() {
        this.cleanUp();
        this.removeTournamentForUser();
    }

    public void quit() {
        this.cleanUp();
        this.removeTournamentForUser();
    }

    private void cleanUp() {
        if (this.futureTimeout != null && !this.futureTimeout.isDone()) {
            this.futureTimeout.cancel(true);
        }
    }

    private void removeTournamentForUser() {
        Optional<User> user = this.managerFactory.userManager().getUser(this.userId);
        if (user.isPresent()) {
            user.get().removeTable(this.playerId);
            user.get().removeTournament(this.playerId);
        }
    }
}

