/*
 * Decompiled with CFR 0.152.
 */
package mage.deck;

import java.util.HashMap;
import java.util.Map;
import mage.cards.decks.Deck;
import mage.cards.decks.DeckValidator;
import mage.cards.decks.DeckValidatorErrorType;

public class Limited
extends DeckValidator {
    public Limited() {
        super("Limited", null);
    }

    public int getDeckMinSize() {
        return 40;
    }

    public int getSideboardMinSize() {
        return 0;
    }

    public boolean validate(Deck deck) {
        boolean valid = true;
        this.errorsList.clear();
        if (deck.getMaindeckCards().size() < this.getDeckMinSize()) {
            this.addError(DeckValidatorErrorType.DECK_SIZE, "Deck", "Must contain at least " + this.getDeckMinSize() + " cards: has only " + deck.getMaindeckCards().size() + " cards");
            valid = false;
        }
        HashMap counts = new HashMap();
        this.countCards(counts, deck.getCards());
        for (Map.Entry entry : counts.entrySet()) {
            if ((Integer)entry.getValue() <= Limited.getMaxCopies((String)((String)entry.getKey()), (int)Integer.MAX_VALUE)) continue;
            this.addError(DeckValidatorErrorType.OTHER, (String)entry.getKey(), "Too many: " + entry.getValue(), true);
            valid = false;
        }
        return valid;
    }
}

