/*
 * Decompiled with CFR 0.152.
 */
package mage.cards;

import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.abilities.effects.common.DamageWithPowerFromOneToAnotherTargetEffect;
import mage.abilities.effects.common.DamageWithPowerFromSourceToAnotherTargetEffect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.abilities.effects.common.ExileUntilSourceLeavesEffect;
import mage.abilities.effects.common.FightTargetsEffect;
import mage.cards.Card;
import mage.cards.repository.CardScanner;
import mage.constants.ColoredManaSymbol;
import mage.constants.Outcome;
import mage.constants.Rarity;
import mage.constants.SubType;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.common.TargetPlayerOrPlaneswalker;
import mage.view.CardView;
import org.apache.log4j.Logger;

public final class RateCard {
    public static final boolean PRELOAD_CARD_RATINGS_ON_STARTUP = false;
    private static Map<String, Integer> baseRatings = new HashMap<String, Integer>();
    private static final Map<String, Integer> ratedCard = new HashMap<String, Integer>();
    private static final Map<String, Integer> ratedCardView = new HashMap<String, Integer>();
    private static boolean isLoaded = false;
    private static final int DEFAULT_BASIC_LAND_RATING = 1;
    private static final int DEFAULT_NOT_RATED_CARD_RATING = 40;
    private static final int DEFAULT_NOT_RATED_UNCOMMON_RATING = 60;
    private static final int DEFAULT_NOT_RATED_RARE_RATING = 75;
    private static final int DEFAULT_NOT_RATED_MYTHIC_RATING = 90;
    private static final int OFF_COLOR_PENALTY = -100;
    private static String RATINGS_DIR = "/ratings/";
    private static String RATINGS_SET_LIST = RATINGS_DIR + "setsWithRatings.csv";
    private static final Logger log = Logger.getLogger(RateCard.class);
    private static final int[] SINGLE_PENALTY = new int[]{0, 1, 1, 3, 6, 9};
    private static final int MULTICOLOR_BONUS = 15;

    private RateCard() {
    }

    public static void bootstrapCardsAndRatings() {
        log.info((Object)"Loading cards and rating...");
        List cards = CardScanner.getAllCards((boolean)false);
        for (Card card : cards) {
            RateCard.rateCard(card, null);
        }
    }

    public static int rateCard(Card card, List<ColoredManaSymbol> allowedColors) {
        return RateCard.rateCard(card, allowedColors, true);
    }

    public static int rateCard(CardView cardview, List<ColoredManaSymbol> allowedColors) {
        return RateCard.rateCard(cardview, allowedColors, true);
    }

    public static int rateCard(Card card, List<ColoredManaSymbol> allowedColors, boolean useCache) {
        if (card == null) {
            return 0;
        }
        String name = card.getName();
        if (useCache && allowedColors.isEmpty() && ratedCard.containsKey(name)) {
            return ratedCard.get(name);
        }
        int typeMultiplier = RateCard.typeMultiplier(card);
        int score = RateCard.getBaseCardScore(card) + 2 * typeMultiplier + RateCard.getManaCostScore(card, allowedColors) + 40 * RateCard.isRemoval(card);
        if (useCache && allowedColors.isEmpty()) {
            ratedCard.put(name, score);
        }
        return score;
    }

    public static int rateCard(CardView cardview, List<ColoredManaSymbol> allowedColors, boolean useCache) {
        if (cardview == null) {
            return 0;
        }
        String name = cardview.getName();
        if (useCache && allowedColors.isEmpty() && ratedCardView.containsKey(name)) {
            return ratedCardView.get(name);
        }
        int typeMultiplier = RateCard.typeMultiplier(cardview);
        int score = RateCard.getBaseCardScore(cardview) + 2 * typeMultiplier + RateCard.getManaCostScore(cardview, allowedColors);
        if (useCache && allowedColors.isEmpty()) {
            ratedCardView.put(name, score);
        }
        return score;
    }

    protected static int typeMultiplier(Card card) {
        return RateCard.typeMultiplier(card.isPlaneswalker(), card.isCreature(), card.getSubtype().contains((Object)SubType.EQUIPMENT), card.getSubtype().contains((Object)SubType.AURA), card.isInstant());
    }

    protected static int typeMultiplier(CardView cardview) {
        return RateCard.typeMultiplier(cardview.isPlaneswalker(), cardview.isCreature(), cardview.getSubTypes().contains((Object)SubType.EQUIPMENT), cardview.getSubTypes().contains((Object)SubType.AURA), cardview.isInstant());
    }

    protected static int typeMultiplier(boolean isPlaneswalker, boolean isCreature, boolean isEquipment, boolean isAura, boolean isInstant) {
        if (isPlaneswalker) {
            return 15;
        }
        if (isCreature) {
            return 10;
        }
        if (isEquipment) {
            return 8;
        }
        if (isAura) {
            return 5;
        }
        if (isInstant) {
            return 7;
        }
        return 6;
    }

    private static int isRemoval(Card card) {
        if (card.isEnchantment() || card.isInstantOrSorcery()) {
            for (Ability ability : card.getAbilities()) {
                for (Effect effect : ability.getEffects()) {
                    if (RateCard.isEffectRemoval(card, ability, effect) != 1) continue;
                    return 1;
                }
                for (Mode mode : ability.getModes().values()) {
                    for (Effect effect : mode.getEffects()) {
                        if (RateCard.isEffectRemoval(card, ability, effect) != 1) continue;
                        return 1;
                    }
                }
            }
        }
        return 0;
    }

    private static int isEffectRemoval(Card card, Ability ability, Effect effect) {
        if (effect.getOutcome() == Outcome.Removal) {
            return 1;
        }
        if (effect instanceof FightTargetsEffect || effect instanceof DamageWithPowerFromOneToAnotherTargetEffect || effect instanceof DamageWithPowerFromSourceToAnotherTargetEffect) {
            return 1;
        }
        if (effect.getOutcome() == Outcome.Damage || effect instanceof DamageTargetEffect) {
            for (Target target : ability.getTargets()) {
                if (target instanceof TargetPlayerOrPlaneswalker) continue;
                return 1;
            }
        }
        if (effect.getOutcome() == Outcome.DestroyPermanent || effect instanceof DestroyTargetEffect || effect instanceof ExileTargetEffect || effect instanceof ExileUntilSourceLeavesEffect) {
            for (Target target : ability.getTargets()) {
                if (!(target instanceof TargetPermanent)) continue;
                return 1;
            }
        }
        return 0;
    }

    public static int getBaseCardScore(Card card) {
        return RateCard.getBaseScore(card.getName(), card.getRarity());
    }

    public static int getBaseCardScore(CardView cardview) {
        return RateCard.getBaseScore(cardview.getName(), cardview.getRarity());
    }

    protected static int getBaseScore(String name, Rarity rarity) {
        int oldRating;
        int newRating;
        RateCard.prepareAndLoadRatings();
        if (rarity != null) {
            switch (rarity) {
                case COMMON: {
                    newRating = 40;
                    break;
                }
                case UNCOMMON: {
                    newRating = 60;
                    break;
                }
                case RARE: {
                    newRating = 75;
                    break;
                }
                case MYTHIC: {
                    newRating = 90;
                    break;
                }
                default: {
                    if (RateCard.isBasicLand(name)) {
                        newRating = 1;
                        break;
                    }
                    newRating = 40;
                    break;
                }
            }
        } else {
            newRating = 40;
        }
        if ((oldRating = baseRatings.getOrDefault(name, 0).intValue()) == 0 || oldRating != newRating) {
            // empty if block
        }
        if (oldRating != 0) {
            return oldRating;
        }
        baseRatings.put(name, newRating);
        return newRating;
    }

    public static synchronized void prepareAndLoadRatings() {
        if (isLoaded) {
            return;
        }
        LinkedList<String> setsToLoad = new LinkedList<String>();
        try {
            InputStream is = RateCard.class.getResourceAsStream(RATINGS_SET_LIST);
            Iterator<String> scanner = new Scanner(is);
            while (((Scanner)scanner).hasNextLine()) {
                String line = ((Scanner)scanner).nextLine();
                if (line.substring(0, 1).equals("#")) continue;
                setsToLoad.add(line);
            }
        }
        catch (Throwable e) {
            log.error((Object)("Failed to read ratings sets list file: " + RATINGS_SET_LIST), e);
        }
        String rateFile = "";
        try {
            for (String code : setsToLoad) {
                rateFile = RATINGS_DIR + code + ".csv";
                RateCard.readFromFile(rateFile);
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to read ratings set file: " + rateFile), (Throwable)e);
        }
        isLoaded = true;
    }

    private static synchronized void readFromFile(String path) {
        String name;
        Integer min = Integer.MAX_VALUE;
        Integer max = 0;
        HashMap<String, Integer> thisFileRatings = new HashMap<String, Integer>();
        InputStream is = RateCard.class.getResourceAsStream(path);
        Scanner scanner = new Scanner(is);
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            String[] s = line.split(":");
            if (s.length != 2) continue;
            Integer rating = Integer.parseInt(s[1].trim());
            name = s[0].trim();
            name = name.replace("\u2019", "'");
            if (rating > max) {
                max = rating;
            }
            if (rating < min) {
                min = rating;
            }
            thisFileRatings.put(name, rating);
        }
        for (Map.Entry ratingByName : thisFileRatings.entrySet()) {
            int oldRating;
            int r = (Integer)ratingByName.getValue();
            name = (String)ratingByName.getKey();
            int newRating = (int)(100.0f * (float)(r - min) / (float)(max - min));
            if (newRating <= (oldRating = baseRatings.getOrDefault(name, 0).intValue())) continue;
            baseRatings.put(name, newRating);
        }
    }

    private static int getManaCostScore(Card card, List<ColoredManaSymbol> allowedColors) {
        return RateCard.getManaCostScore(card.getName(), card.getManaValue(), card.getManaCostSymbols(), allowedColors);
    }

    private static int getManaCostScore(CardView cardview, List<ColoredManaSymbol> allowedColors) {
        return RateCard.getManaCostScore(cardview.getName(), cardview.getManaValue(), cardview.getManaCostSymbols(), allowedColors);
    }

    private static int getManaCostScore(String name, int manaValue, List<String> manaCostSymbols, List<ColoredManaSymbol> allowedColors) {
        if (allowedColors.isEmpty()) {
            int colorPenalty = 0;
            for (String symbol : manaCostSymbols) {
                if (!RateCard.isColoredMana(symbol)) continue;
                ++colorPenalty;
            }
            return 2 * (manaValue - colorPenalty + 1);
        }
        if (RateCard.isBasicLand(name)) {
            return -100;
        }
        HashMap<String, Integer> singleCount = new HashMap<String, Integer>();
        int maxSingleCount = 0;
        for (String symbol : manaCostSymbols) {
            int count = 0;
            if (!RateCard.isColoredMana(symbol = symbol.replace("{", "").replace("}", ""))) continue;
            for (ColoredManaSymbol allowed : allowedColors) {
                if (!allowed.toString().equals(symbol)) continue;
                ++count;
            }
            if (count == 0) {
                return -100;
            }
            Integer typeCount = (Integer)singleCount.get(symbol);
            if (typeCount == null) {
                typeCount = 0;
            }
            typeCount = typeCount + 1;
            singleCount.put(symbol, typeCount);
            maxSingleCount = Math.max(maxSingleCount, typeCount);
        }
        if (maxSingleCount > 5) {
            maxSingleCount = 5;
        }
        int rate = 2 * manaValue + 3 * (10 - SINGLE_PENALTY[maxSingleCount]);
        if (singleCount.size() > 1 && singleCount.size() < 5) {
            rate += 15;
        }
        return rate;
    }

    public static boolean isColoredMana(String symbol) {
        String s = symbol;
        if (s.length() > 1) {
            s = s.replace("{", "").replace("}", "");
        }
        if (s.length() > 1) {
            return false;
        }
        return s.equals("W") || s.equals("G") || s.equals("U") || s.equals("B") || s.equals("R");
    }

    public static int getColorManaCount(Card card) {
        int count = 0;
        for (String symbol : card.getManaCostSymbols()) {
            if (!RateCard.isColoredMana(symbol)) continue;
            ++count;
        }
        return count;
    }

    public static int getDifferentColorManaCount(Card card) {
        HashSet<String> symbols = new HashSet<String>();
        for (String symbol : card.getManaCostSymbols()) {
            if (!RateCard.isColoredMana(symbol)) continue;
            symbols.add(symbol);
        }
        return symbols.size();
    }

    public static boolean isBasicLand(String name) {
        return name.equals("Plains") || name.equals("Island") || name.equals("Swamp") || name.equals("Mountain") || name.equals("Forest");
    }
}

