/*
 * Decompiled with CFR 0.152.
 */
package mage.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import mage.components.ImagePanelStyle;

public class ImagePanel
extends JPanel {
    private BufferedImage image;
    private ImagePanelStyle style;
    private float alignmentX = 0.5f;
    private float alignmentY = 0.5f;

    public ImagePanel(BufferedImage image) {
        this(image, ImagePanelStyle.TILED);
    }

    public ImagePanel(BufferedImage image, ImagePanelStyle style) {
        this.image = image;
        this.style = style;
        this.setLayout(new BorderLayout());
        this.setOpaque(true);
    }

    public void setImageAlignmentX(float alignmentX) {
        this.alignmentX = alignmentX > 1.0f ? 1.0f : (alignmentX < 0.0f ? 0.0f : alignmentX);
    }

    public void setImageAlignmentY(float alignmentY) {
        this.alignmentY = alignmentY > 1.0f ? 1.0f : (alignmentY < 0.0f ? 0.0f : alignmentY);
    }

    public void add(JComponent component) {
        this.add(component, null);
    }

    public void add(JComponent component, Object constraints) {
        component.setOpaque(false);
        if (component instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)component;
            JViewport viewport = scrollPane.getViewport();
            viewport.setOpaque(false);
            Component c = viewport.getView();
            if (c instanceof JComponent) {
                ((JComponent)c).setOpaque(false);
            }
        }
        super.add((Component)component, constraints);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.image == null) {
            return;
        }
        switch (this.style) {
            case TILED: {
                this.drawTiled(g);
                break;
            }
            case SCALED: {
                Dimension d = this.getSize();
                g.drawImage(this.image, 0, 0, d.width, d.height, null);
                break;
            }
            case ACTUAL: {
                this.drawActual(g);
            }
        }
    }

    private void drawTiled(Graphics g) {
        Dimension d = this.getSize();
        int width = this.image.getWidth(null);
        int height = this.image.getHeight(null);
        for (int x = 0; x < d.width; x += width) {
            for (int y = 0; y < d.height; y += height) {
                g.drawImage(this.image, x, y, null, null);
            }
        }
    }

    private void drawActual(Graphics g) {
        Dimension d = this.getSize();
        float x = (float)(d.width - this.image.getWidth(null)) * this.alignmentX;
        float y = (float)(d.height - this.image.getHeight(null)) * this.alignmentY;
        g.drawImage(this.image, (int)x, (int)y, this);
    }
}

