/*
 * Decompiled with CFR 0.152.
 */
package mage.interfaces;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import mage.players.PlayerType;
import mage.utils.MageVersion;
import mage.view.GameTypeView;
import mage.view.TournamentTypeView;

public class ServerState
implements Serializable {
    private final List<GameTypeView> gameTypes;
    private final List<TournamentTypeView> tournamentTypes;
    private final PlayerType[] playerTypes;
    private final String[] deckTypes;
    private final String[] draftCubes;
    private final boolean testMode;
    private final MageVersion version;
    private final long cardsContentVersion;
    private final long expansionsContentVersion;

    public ServerState(List<GameTypeView> gameTypes, List<TournamentTypeView> tournamentTypes, PlayerType[] playerTypes, String[] deckTypes, String[] draftCubes, boolean testMode, MageVersion version, long cardsContentVersion, long expansionsContentVersion) {
        this.gameTypes = gameTypes;
        this.tournamentTypes = tournamentTypes;
        this.playerTypes = playerTypes;
        this.deckTypes = deckTypes;
        this.draftCubes = draftCubes;
        this.testMode = testMode;
        this.version = version;
        this.cardsContentVersion = cardsContentVersion;
        this.expansionsContentVersion = expansionsContentVersion;
    }

    public List<GameTypeView> getGameTypes() {
        return this.gameTypes;
    }

    public List<GameTypeView> getTournamentGameTypes() {
        return this.gameTypes.stream().filter(gameTypeView -> gameTypeView.getMinPlayers() == 2 && gameTypeView.getMaxPlayers() == 2).collect(Collectors.toList());
    }

    public List<TournamentTypeView> getTournamentTypes() {
        return this.tournamentTypes;
    }

    public PlayerType[] getPlayerTypes() {
        return this.playerTypes;
    }

    public String[] getDeckTypes() {
        return this.deckTypes;
    }

    public String[] getDraftCubes() {
        return this.draftCubes;
    }

    public boolean isTestMode() {
        return this.testMode;
    }

    public MageVersion getVersion() {
        return this.version;
    }

    public long getCardsContentVersion() {
        return this.cardsContentVersion;
    }

    public long getExpansionsContentVersion() {
        return this.expansionsContentVersion;
    }
}

