/*
 * Decompiled with CFR 0.152.
 */
package mage.remote;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import mage.players.net.UserData;

public class Connection {
    private String host;
    private int port;
    private String username;
    private String password;
    private String email;
    private String authToken;
    private String adminPassword;
    private ProxyType proxyType;
    private String proxyHost;
    private int proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private int clientCardDatabaseVersion;
    private String userIdStr;
    private int socketWriteTimeout;
    private UserData userData;
    private static final String serialization = "?serializationtype=java";
    private static final String transport = "bisocket";
    private static final String threadpool = "onewayThreadPool=mage.remote.CustomThreadPool";
    private final String parameter;

    public Connection() {
        this("");
    }

    public Connection(String parameter) {
        this.parameter = parameter;
        this.socketWriteTimeout = 10000;
    }

    public int hashCode() {
        return (transport + this.host + Integer.toString(this.port) + this.proxyType.toString()).hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Connection)) {
            return false;
        }
        Connection otherConnection = (Connection)object;
        return this.hashCode() == otherConnection.hashCode();
    }

    public String toString() {
        return this.host + ':' + Integer.toString(this.port) + '/' + serialization + this.parameter;
    }

    public String getURI() {
        if (this.host.equals("localhost")) {
            try {
                InetAddress inet = Connection.getLocalAddress();
                if (inet != null) {
                    return "bisocket://" + inet.getHostAddress() + ':' + this.port + '/' + serialization + "&" + threadpool + this.parameter;
                }
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
        return "bisocket://" + this.host + ':' + this.port + '/' + serialization + "&" + threadpool + this.parameter;
    }

    public ProxyType getProxyType() {
        return this.proxyType;
    }

    public void setProxyType(ProxyType proxyType) {
        this.proxyType = proxyType;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUserIdStr() {
        return this.userIdStr;
    }

    public void setUserIdStr(String userIdStr) {
        this.userIdStr = userIdStr;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public static InetAddress getLocalAddress() throws SocketException {
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface iface = interfaces.nextElement();
            if (iface.isLoopback()) continue;
            for (InterfaceAddress addr : iface.getInterfaceAddresses()) {
                InetAddress iaddr;
                if (addr == null || !((iaddr = addr.getAddress()) instanceof Inet4Address)) continue;
                return iaddr;
            }
        }
        return null;
    }

    public static String getMAC() throws SocketException {
        StringBuilder allMACs = new StringBuilder();
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface iface = interfaces.nextElement();
            byte[] mac = iface.getHardwareAddress();
            if (mac == null) continue;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < mac.length; ++i) {
                sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
            }
            sb.append(';');
            allMACs.append(sb.toString());
        }
        return allMACs.toString();
    }

    public void setUserData(UserData userData) {
        this.userData = userData;
    }

    public UserData getUserData() {
        return this.userData;
    }

    public int getSocketWriteTimeout() {
        return this.socketWriteTimeout;
    }

    public static enum ProxyType {
        SOCKS("Socks"),
        HTTP("HTTP"),
        NONE("None");

        private final String text;

        private ProxyType(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }

        public static ProxyType valueByText(String value) {
            for (ProxyType type : ProxyType.values()) {
                if (!type.text.equals(value)) continue;
                return type;
            }
            return NONE;
        }
    }
}

