/*
 * Decompiled with CFR 0.152.
 */
package mage.remote;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.Authenticator;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingWorker;
import mage.MageException;
import mage.cards.decks.DeckCardLists;
import mage.constants.ManaType;
import mage.constants.PlayerAction;
import mage.game.GameException;
import mage.game.match.MatchOptions;
import mage.game.tournament.TournamentOptions;
import mage.interfaces.MageClient;
import mage.interfaces.MageServer;
import mage.interfaces.ServerState;
import mage.interfaces.callback.ClientCallback;
import mage.players.PlayerType;
import mage.players.net.UserData;
import mage.remote.ActionData;
import mage.remote.Connection;
import mage.remote.MageAuthenticator;
import mage.remote.MageRemoteException;
import mage.remote.MageVersionException;
import mage.remote.Session;
import mage.util.ThreadUtils;
import mage.utils.CompressUtil;
import mage.view.DraftPickView;
import mage.view.GameTypeView;
import mage.view.MatchView;
import mage.view.RoomUsersView;
import mage.view.TableView;
import mage.view.TournamentTypeView;
import mage.view.TournamentView;
import mage.view.UserView;
import org.apache.log4j.Logger;
import org.jboss.remoting.CannotConnectException;
import org.jboss.remoting.Client;
import org.jboss.remoting.ConnectionListener;
import org.jboss.remoting.InvocationFailureException;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.callback.Callback;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.transporter.TransporterClient;

public class SessionImpl
implements Session {
    private static final Logger logger = Logger.getLogger(SessionImpl.class);
    private static final int SESSION_VALIDATOR_PING_PERIOD_SECS = 4;
    private static final int SESSION_VALIDATOR_PING_TIMEOUT_SECS = 3;
    private static final int CONNECT_WAIT_BEFORE_PROCESS_ANY_CALLBACKS_SECS = 3;
    public static final String ADMIN_NAME = "Admin";
    public static final String KEEP_MY_OLD_SESSION = "keep_my_old_session";
    private final MageClient client;
    private String sessionId = "";
    private String restoreSessionId = "";
    private MageServer server;
    private Client callbackClient;
    private CallbackHandler callbackHandler;
    private ServerState serverState;
    private SessionState sessionState = SessionState.DISCONNECTED;
    private Connection connection;
    private RemotingTask lastRemotingTask = null;
    private static final int PING_CYCLES = 10;
    private final LinkedList<Long> pingTime = new LinkedList();
    private String lastPingInfo = "";
    private boolean canceled = false;
    private boolean jsonLogActive = false;
    private String lastError = "";

    public SessionImpl(MageClient client) {
        this.client = client;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public void setRestoreSessionId(String restoreSessionId) {
        this.restoreSessionId = restoreSessionId;
    }

    private void showMessageToUser(String message) {
        if (message == null) {
            message = "Unknown error, look at logs for details";
        }
        if (message.contains("free port for use")) {
            message = message + " (try to close and restart a client app)";
        }
        this.client.showMessage("Remote task error: " + message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doRemoteWorkAndHandleErrors(boolean closeConnectionOnFinish, boolean mustWaitServerMessageOnFail, RemotingTask remoting) {
        this.lastRemotingTask = remoting;
        try {
            boolean res = remoting.doWork();
            if (!res && mustWaitServerMessageOnFail) {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    logger.fatal((Object)"Server not responding, can't get error message from it", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
            boolean e = res;
            return e;
        }
        catch (InterruptedException | CancellationException res) {
        }
        catch (MalformedURLException ex) {
            logger.fatal((Object)"Connect: wrong server address", (Throwable)ex);
            this.showMessageToUser(ex.getMessage());
        }
        catch (UndeclaredThrowableException ex) {
            String addMessage = "";
            Throwable cause = ex.getCause();
            if (cause instanceof InvocationFailureException) {
                InvocationFailureException exep = (InvocationFailureException)cause;
                if (exep.getCause() instanceof IOException) {
                    if (exep.getCause().getMessage() != null && (exep.getCause().getMessage().startsWith("Field hash null is not available on current") || exep.getCause().getMessage().endsWith("end of file"))) {
                        addMessage = "Probably the server version is not compatible with the client. ";
                    }
                } else {
                    logger.error((Object)"Connect: unknown server error", exep.getCause());
                }
            } else if (cause instanceof NoSuchMethodException) {
                addMessage = "The following method is not available in the server, probably the server version is not compatible with the client: " + cause.getMessage();
            }
            if (addMessage.isEmpty()) {
                logger.fatal((Object)"Connect: unknown error", (Throwable)ex);
            }
            this.showMessageToUser(addMessage + (ex.getMessage() != null ? ex.getMessage() : ""));
        }
        catch (IOException ex) {
            logger.fatal((Object)"Connect: unknown IO error", (Throwable)ex);
            String addMessage = "";
            if (ex.getMessage() != null && ex.getMessage().startsWith("Unable to perform invocation")) {
                addMessage = "Maybe the server version is not compatible. ";
            }
            this.showMessageToUser(addMessage + (ex.getMessage() != null ? ex.getMessage() : ""));
        }
        catch (MageVersionException ex) {
            logger.warn((Object)"Connect: wrong versions");
            this.connectStop(false, false);
            if (!this.canceled) {
                this.showMessageToUser(ex.toString());
            }
        }
        catch (CannotConnectException ex) {
            if (!this.canceled) {
                this.handleCannotConnectException(ex);
            }
        }
        catch (Throwable t) {
            Throwable ex = ThreadUtils.findRootException((Throwable)t);
            logger.fatal((Object)"Connect: FAIL", t);
            this.connectStop(false, false);
            if (!this.canceled) {
                this.showMessageToUser(ex.toString());
            }
        }
        finally {
            this.lastRemotingTask = null;
            if (closeConnectionOnFinish) {
                this.connectStop(false, false);
            }
        }
        return false;
    }

    @Override
    public synchronized boolean sendAuthRegister(final Connection connection) {
        return this.doRemoteConnection(connection) && this.doRemoteWorkAndHandleErrors(true, true, new RemotingTask(){

            @Override
            public boolean work() throws Throwable {
                logger.info((Object)("Registration: username " + SessionImpl.this.getUserName() + " for email " + SessionImpl.this.getEmail()));
                boolean result = SessionImpl.this.server.authRegister(SessionImpl.this.sessionId, connection.getUsername(), connection.getPassword(), connection.getEmail());
                logger.info((Object)("Registration: " + (result ? "DONE, check your email for new password" : "FAIL")));
                return result;
            }
        });
    }

    @Override
    public synchronized boolean sendAuthSendTokenToEmail(final Connection connection) {
        return this.doRemoteConnection(connection) && this.doRemoteWorkAndHandleErrors(true, true, new RemotingTask(){

            @Override
            public boolean work() throws Throwable {
                logger.info((Object)("Auth request: requesting auth token for username " + SessionImpl.this.getUserName() + " to email " + SessionImpl.this.getEmail()));
                boolean result = SessionImpl.this.server.authSendTokenToEmail(SessionImpl.this.sessionId, connection.getEmail());
                logger.info((Object)("Auth request: " + (result ? "DONE, check your email for auth token" : "FAIL")));
                return result;
            }
        });
    }

    @Override
    public synchronized boolean sendAuthResetPassword(final Connection connection) {
        return this.doRemoteConnection(connection) && this.doRemoteWorkAndHandleErrors(true, true, new RemotingTask(){

            @Override
            public boolean work() throws Throwable {
                logger.info((Object)("Password reset: reseting password for username " + SessionImpl.this.getUserName()));
                boolean result = SessionImpl.this.server.authResetPassword(SessionImpl.this.sessionId, connection.getEmail(), connection.getAuthToken(), connection.getPassword());
                logger.info((Object)("Password reset: " + (result ? "DONE, now you can login with new password" : "FAIL")));
                return result;
            }
        });
    }

    @Override
    public synchronized boolean connectStart(final Connection connection) {
        return this.doRemoteConnection(connection) && this.doRemoteWorkAndHandleErrors(false, true, new RemotingTask(){

            @Override
            public boolean work() throws Throwable {
                SessionImpl.this.setLastError("");
                logger.info((Object)("Logging: as username " + SessionImpl.this.getUserName() + " to server " + connection.getHost() + ':' + connection.getPort()));
                boolean result = connection.getAdminPassword() == null ? SessionImpl.this.server.connectUser(connection.getUsername(), connection.getPassword(), SessionImpl.this.sessionId, SessionImpl.this.restoreSessionId, SessionImpl.this.client.getVersion(), connection.getUserIdStr()) : SessionImpl.this.server.connectAdmin(connection.getAdminPassword(), SessionImpl.this.sessionId, SessionImpl.this.client.getVersion());
                if (result) {
                    SessionImpl.this.serverState = SessionImpl.this.server.getServerState();
                    if (SessionImpl.this.serverState == null) {
                        throw new MageVersionException(SessionImpl.this.client.getVersion(), null);
                    }
                    if (SessionImpl.this.client.getVersion().compareTo(SessionImpl.this.serverState.getVersion()) != 0) {
                        throw new MageVersionException(SessionImpl.this.client.getVersion(), SessionImpl.this.serverState.getVersion());
                    }
                    if (!connection.getUsername().equals(SessionImpl.ADMIN_NAME)) {
                        SessionImpl.this.server.connectSetUserData(connection.getUsername(), SessionImpl.this.sessionId, connection.getUserData(), SessionImpl.this.client.getVersion().toString(), connection.getUserIdStr());
                    }
                    logger.info((Object)"Logging: DONE");
                    SessionImpl.this.client.connected(SessionImpl.this.getUserName() + '@' + connection.getHost() + ':' + connection.getPort() + ' ');
                    return true;
                }
                logger.info((Object)"Logging: FAIL");
                return false;
            }
        });
    }

    @Override
    public String getServerHost() {
        return this.isConnected() ? this.connection.getHost() : "";
    }

    @Override
    public boolean connectAbort() {
        this.canceled = true;
        if (this.lastRemotingTask != null) {
            this.lastRemotingTask.cancel();
        }
        return true;
    }

    private boolean doRemoteConnection(final Connection connection) {
        boolean result;
        if (this.isConnected()) {
            this.connectStop(true, false);
        }
        this.connection = connection;
        this.canceled = false;
        this.sessionState = SessionState.CONNECTING;
        this.lastRemotingTask = new RemotingTask(){

            @Override
            public boolean work() throws Throwable {
                logger.info((Object)("Connect: connecting to server " + connection.getHost() + ':' + connection.getPort()));
                System.setProperty("http.nonProxyHosts", "code.google.com");
                System.setProperty("socksNonProxyHosts", "code.google.com");
                System.clearProperty("socksProxyHost");
                System.clearProperty("socksProxyPort");
                System.clearProperty("http.proxyHost");
                System.clearProperty("http.proxyPort");
                if (connection.getProxyType() != Connection.ProxyType.NONE) {
                    logger.info((Object)("Connect: using proxy " + connection.getProxyHost() + ":" + connection.getProxyPort()));
                }
                switch (connection.getProxyType()) {
                    case SOCKS: {
                        System.setProperty("socksProxyHost", connection.getProxyHost());
                        System.setProperty("socksProxyPort", Integer.toString(connection.getProxyPort()));
                        break;
                    }
                    case HTTP: {
                        System.setProperty("http.proxyHost", connection.getProxyHost());
                        System.setProperty("http.proxyPort", Integer.toString(connection.getProxyPort()));
                        Authenticator.setDefault(new MageAuthenticator(connection.getProxyUsername(), connection.getProxyPassword()));
                    }
                }
                InvokerLocator clientLocator = new InvokerLocator(connection.getURI());
                HashMap<String, String> metadata = new HashMap<String, String>();
                metadata.put("writeTimeout", String.valueOf(connection.getSocketWriteTimeout()));
                metadata.put("generalizeSocketException", "true");
                SessionImpl.this.server = (MageServer)TransporterClient.createTransporterClient((String)clientLocator.getLocatorURI(), MageServer.class, metadata);
                HashMap<String, String> clientMetadata = new HashMap<String, String>();
                clientMetadata.put("writeTimeout", String.valueOf(connection.getSocketWriteTimeout()));
                clientMetadata.put("generalizeSocketException", "true");
                clientMetadata.put("enableLease", "true");
                clientMetadata.put("numberOfCallRetries", "1");
                clientMetadata.put("maxNumThreadsOneway", "10");
                clientMetadata.put("useClientConnectionIdentity", "true");
                SessionImpl.this.callbackClient = new Client(clientLocator, "callback", clientMetadata);
                HashMap<String, String> listenerMetadata = new HashMap<String, String>();
                listenerMetadata.put("validatorPingPeriod", String.valueOf(4000));
                listenerMetadata.put("validatorPingTimeout", String.valueOf(3000));
                SessionImpl.this.callbackClient.connect((ConnectionListener)new MageClientConnectionListener(), listenerMetadata);
                HashMap<String, String> callbackMetadata = new HashMap<String, String>();
                callbackMetadata.put("isCallbackServer", "true");
                if (SessionImpl.this.callbackHandler == null) {
                    SessionImpl.this.callbackHandler = new CallbackHandler();
                }
                SessionImpl.this.callbackClient.addListener((InvokerCallbackHandler)SessionImpl.this.callbackHandler, callbackMetadata);
                Set callbackConnectors = SessionImpl.this.callbackClient.getCallbackConnectors((InvokerCallbackHandler)SessionImpl.this.callbackHandler);
                if (callbackConnectors.size() != 1) {
                    logger.warn((Object)("There should be one callback Connector (number existing = " + callbackConnectors.size() + ')'));
                }
                SessionImpl.this.callbackClient.invoke(null);
                SessionImpl.this.sessionId = SessionImpl.this.callbackClient.getSessionId();
                SessionImpl.this.sessionState = SessionState.CONNECTED;
                SessionImpl.this.client.onNewConnection();
                logger.info((Object)"Connect: DONE");
                return true;
            }
        };
        try {
            result = this.doRemoteWorkAndHandleErrors(false, false, this.lastRemotingTask);
        }
        finally {
            this.lastRemotingTask = null;
        }
        if (result) {
            return true;
        }
        this.connectStop(false, false);
        return false;
    }

    private void handleCannotConnectException(CannotConnectException ex) {
        Throwable t;
        logger.warn((Object)"Cannot connect", (Throwable)ex);
        String message = "";
        for (t = ex.getCause(); t != null; t = t.getCause()) {
            if (t instanceof ConnectException) {
                message = "Server is likely offline." + message;
                break;
            }
            if (t instanceof SocketException) {
                message = "Check your internet connection." + message;
                break;
            }
            if (t instanceof SocketTimeoutException) {
                message = "Server is not responding." + message;
                break;
            }
            if (t.toString().contains("to make private")) {
                message = "Wrong java version - check your client running scripts and params." + message;
                break;
            }
            if (t.getCause() != null && logger.isDebugEnabled()) {
                message = '\n' + t.getCause().getMessage() + message;
                logger.debug((Object)t.getCause().getMessage());
            }
            if (t.getCause() != null || !Arrays.stream(t.getStackTrace()).anyMatch(stack -> Objects.equals("ObjectInputStream.java", stack.getFileName()))) continue;
            message = "Wrong client-server protocol - report to server's admin about compatibility problems. " + message;
            break;
        }
        this.client.showMessage("Unable connect to server. " + message);
        this.setLastError(message);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"StackTrace", t);
        }
    }

    @Override
    public synchronized void connectStop(boolean askForReconnect, boolean keepMySessionActive) {
        if (this.isConnected()) {
            logger.info((Object)"Disconnecting...");
            this.sessionState = SessionState.DISCONNECTING;
        }
        if (this.connection == null || this.sessionState == SessionState.DISCONNECTED) {
            return;
        }
        try {
            if (this.callbackClient != null && this.callbackClient.isConnected()) {
                if (keepMySessionActive) {
                    this.callbackClient.setSessionId(KEEP_MY_OLD_SESSION);
                }
                this.callbackClient.removeListener((InvokerCallbackHandler)this.callbackHandler);
                this.callbackClient.disconnect();
            }
        }
        catch (Throwable ex) {
            logger.fatal((Object)"Disconnecting FAIL", ex);
        }
        if (this.sessionState == SessionState.DISCONNECTING || this.sessionState == SessionState.CONNECTING) {
            this.sessionState = SessionState.DISCONNECTED;
            this.serverState = null;
            logger.info((Object)"Disconnecting DONE");
            if (askForReconnect) {
                this.client.showError("Network error. Can't connect to  " + this.connection.getHost());
            }
            this.client.disconnected(askForReconnect, keepMySessionActive);
            this.pingTime.clear();
        }
        if (this.server != null) {
            TransporterClient.destroyTransporterClient((Object)this.server);
            this.server = null;
        }
        this.callbackClient = null;
        this.callbackHandler = null;
        this.serverState = null;
    }

    @Override
    public synchronized void connectReconnect(Throwable throwable) {
        this.client.disconnected(true, true);
    }

    @Override
    public synchronized boolean sendFeedback(String title, String type, String message, String email) {
        try {
            if (this.isConnected()) {
                this.server.serverAddFeedbackMessage(this.sessionId, this.connection.getUsername(), title, type, message, email);
                return true;
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        return false;
    }

    @Override
    public boolean isConnected() {
        if (this.callbackClient == null) {
            return false;
        }
        return this.callbackClient.isConnected();
    }

    @Override
    public Boolean isServerReady() {
        return this.isConnected() && this.serverState != null && this.serverState.getGameTypes().size() > 0;
    }

    @Override
    public PlayerType[] getPlayerTypes() {
        return this.serverState.getPlayerTypes();
    }

    @Override
    public List<GameTypeView> getGameTypes() {
        return this.serverState.getGameTypes();
    }

    @Override
    public List<GameTypeView> getTournamentGameTypes() {
        return this.serverState.getTournamentGameTypes();
    }

    @Override
    public String[] getDeckTypes() {
        return this.serverState.getDeckTypes();
    }

    @Override
    public String[] getDraftCubes() {
        return this.serverState.getDraftCubes();
    }

    @Override
    public List<TournamentTypeView> getTournamentTypes() {
        return this.serverState.getTournamentTypes();
    }

    @Override
    public boolean isTestMode() {
        if (this.serverState != null) {
            return this.serverState.isTestMode();
        }
        return false;
    }

    @Override
    public UUID getMainRoomId() {
        try {
            if (this.isConnected()) {
                return this.server.serverGetMainRoomId();
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        return null;
    }

    @Override
    public Optional<UUID> getRoomChatId(UUID roomId) {
        try {
            if (this.isConnected()) {
                return Optional.ofNullable(this.server.chatFindByRoom(roomId));
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        return Optional.empty();
    }

    @Override
    public Optional<UUID> getTableChatId(UUID tableId) {
        try {
            if (this.isConnected()) {
                return Optional.ofNullable(this.server.chatFindByTable(tableId));
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        return Optional.empty();
    }

    @Override
    public Optional<UUID> getGameChatId(UUID gameId) {
        try {
            if (this.isConnected()) {
                return Optional.ofNullable(this.server.chatFindByGame(gameId));
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return Optional.empty();
    }

    @Override
    public Optional<TableView> getTable(UUID roomId, UUID tableId) {
        try {
            if (this.isConnected()) {
                return Optional.ofNullable(this.server.roomGetTableById(roomId, tableId));
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        return Optional.empty();
    }

    @Override
    public boolean watchTable(UUID roomId, UUID tableId) {
        try {
            if (this.isConnected()) {
                this.server.roomWatchTable(this.sessionId, roomId, tableId);
                return true;
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return false;
    }

    @Override
    public boolean watchTournamentTable(UUID tableId) {
        try {
            if (this.isConnected()) {
                this.server.roomWatchTournament(this.sessionId, tableId);
                return true;
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return false;
    }

    @Override
    public boolean joinTable(UUID roomId, UUID tableId, String playerName, PlayerType playerType, int skill, DeckCardLists deckList, String password) {
        try {
            if (this.isConnected()) {
                if (deckList != null) {
                    deckList.setCardLayout(null);
                    deckList.setSideboardLayout(null);
                }
                return this.server.roomJoinTable(this.sessionId, roomId, tableId, playerName, playerType, skill, deckList, password);
            }
        }
        catch (GameException ex) {
            this.handleGameException(ex);
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return false;
    }

    @Override
    public boolean joinTournamentTable(UUID roomId, UUID tableId, String playerName, PlayerType playerType, int skill, DeckCardLists deckList, String password) {
        try {
            if (this.isConnected()) {
                if (deckList != null) {
                    deckList.setCardLayout(null);
                    deckList.setSideboardLayout(null);
                }
                return this.server.roomJoinTournament(this.sessionId, roomId, tableId, playerName, playerType, skill, deckList, password);
            }
        }
        catch (GameException ex) {
            this.handleGameException(ex);
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return false;
    }

    @Override
    public Collection<TableView> getTables(UUID roomId) throws MageRemoteException {
        try {
            if (this.isConnected()) {
                return this.server.roomGetAllTables(roomId);
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
            throw new MageRemoteException();
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return new ArrayList<TableView>();
    }

    @Override
    public Collection<MatchView> getFinishedMatches(UUID roomId) throws MageRemoteException {
        try {
            if (this.isConnected()) {
                return this.server.roomGetFinishedMatches(roomId);
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
            throw new MageRemoteException();
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return new ArrayList<MatchView>();
    }

    @Override
    public Collection<RoomUsersView> getRoomUsers(UUID roomId) throws MageRemoteException {
        try {
            if (this.isConnected()) {
                return this.server.roomGetUsers(roomId);
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
            throw new MageRemoteException();
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return new ArrayList<RoomUsersView>();
    }

    @Override
    public TournamentView getTournament(UUID tournamentId) throws MageRemoteException {
        try {
            if (this.isConnected()) {
                return this.server.tournamentFindById(tournamentId);
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
            throw new MageRemoteException();
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return null;
    }

    @Override
    public Optional<UUID> getTournamentChatId(UUID tournamentId) {
        try {
            if (this.isConnected()) {
                return Optional.ofNullable(this.server.chatFindByTournament(tournamentId));
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return Optional.empty();
    }

    @Override
    public boolean sendPlayerUUID(UUID gameId, UUID data) {
        try {
            if (this.isConnected()) {
                ActionData actionData = new ActionData("SEND_PLAYER_UUID", gameId, this.getSessionId());
                actionData.value = data;
                this.appendJsonLog(actionData);
                this.server.sendPlayerUUID(gameId, this.sessionId, data);
                return true;
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return false;
    }

    @Override
    public boolean sendPlayerBoolean(UUID gameId, boolean data) {
        try {
            if (this.isConnected()) {
                ActionData actionData = new ActionData("SEND_PLAYER_BOOLEAN", gameId, this.getSessionId());
                actionData.value = data;
                this.appendJsonLog(actionData);
                this.server.sendPlayerBoolean(gameId, this.sessionId, data);
                return true;
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return false;
    }

    @Override
    public boolean sendPlayerInteger(UUID gameId, int data) {
        try {
            if (this.isConnected()) {
                ActionData actionData = new ActionData("SEND_PLAYER_INTEGER", gameId, this.getSessionId());
                actionData.value = data;
                this.appendJsonLog(actionData);
                this.server.sendPlayerInteger(gameId, this.sessionId, data);
                return true;
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return false;
    }

    @Override
    public boolean sendPlayerString(UUID gameId, String data) {
        try {
            if (this.isConnected()) {
                ActionData actionData = new ActionData("SEND_PLAYER_STRING", gameId, this.getSessionId());
                actionData.value = data;
                this.appendJsonLog(actionData);
                this.server.sendPlayerString(gameId, this.sessionId, data);
                return true;
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return false;
    }

    @Override
    public boolean sendPlayerManaType(UUID gameId, UUID playerId, ManaType data) {
        try {
            if (this.isConnected()) {
                ActionData actionData = new ActionData("SEND_PLAYER_MANA_TYPE", gameId, this.getSessionId());
                actionData.value = data;
                this.appendJsonLog(actionData);
                this.server.sendPlayerManaType(gameId, playerId, this.sessionId, data);
                return true;
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return false;
    }

    @Override
    public void appendJsonLog(ActionData actionData) {
        if (this.isJsonLogActive()) {
            String dir = "gamelogsJson";
            File saveDir = new File(dir);
            if (!saveDir.exists()) {
                saveDir.mkdirs();
            }
            actionData.sessionId = this.getSessionId();
            String logFileName = dir + File.separator + "game-" + actionData.gameId + ".json";
            try (PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(logFileName, true)));){
                out.println(actionData.toJson());
            }
            catch (IOException e) {
                logger.error((Object)("Cant write JSON game log file - " + logFileName), (Throwable)e);
            }
        }
    }

    @Override
    public DraftPickView sendCardPick(UUID draftId, UUID cardId, Set<UUID> hiddenCards) {
        try {
            if (this.isConnected()) {
                return this.server.sendDraftCardPick(draftId, this.sessionId, cardId, hiddenCards);
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return null;
    }

    @Override
    public DraftPickView sendCardMark(UUID draftId, UUID cardId) {
        try {
            if (this.isConnected()) {
                this.server.sendDraftCardMark(draftId, this.sessionId, cardId);
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return null;
    }

    @Override
    public boolean setBoosterLoaded(UUID draftId) {
        try {
            if (this.isConnected()) {
                this.server.draftSetBoosterLoaded(draftId, this.sessionId);
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return false;
    }

    @Override
    public boolean joinChat(UUID chatId) {
        try {
            if (this.isConnected()) {
                this.server.chatJoin(chatId, this.sessionId, this.connection.getUsername());
                return true;
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return false;
    }

    @Override
    public boolean leaveChat(UUID chatId) {
        try {
            if (this.isConnected() && chatId != null) {
                this.server.chatLeave(chatId, this.sessionId);
            }
            return true;
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return false;
    }

    @Override
    public boolean sendChatMessage(UUID chatId, String message) {
        try {
            if (this.isConnected()) {
                this.server.chatSendMessage(chatId, this.connection.getUsername(), message);
                return true;
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return false;
    }

    @Override
    public boolean sendBroadcastMessage(String message) {
        try {
            if (this.isConnected()) {
                this.server.adminSendBroadcastMessage(this.sessionId, message);
                return true;
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return false;
    }

    @Override
    public boolean joinGame(UUID gameId) {
        try {
            if (this.isConnected()) {
                this.server.gameJoin(gameId, this.sessionId);
                return true;
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return false;
    }

    @Override
    public boolean joinDraft(UUID draftId) {
        try {
            if (this.isConnected()) {
                this.server.draftJoin(draftId, this.sessionId);
                return true;
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return false;
    }

    @Override
    public boolean joinTournament(UUID tournamentId) {
        try {
            if (this.isConnected()) {
                this.server.tournamentJoin(tournamentId, this.sessionId);
                return true;
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return false;
    }

    @Override
    public boolean watchGame(UUID gameId) {
        try {
            if (this.isConnected()) {
                return this.server.gameWatchStart(gameId, this.sessionId);
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return false;
    }

    @Override
    public boolean replayGame(UUID gameId) {
        try {
            if (this.isConnected()) {
                this.server.replayInit(gameId, this.sessionId);
                return true;
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return false;
    }

    @Override
    public TableView createTable(UUID roomId, MatchOptions matchOptions) {
        try {
            if (this.isConnected()) {
                return this.server.roomCreateTable(this.sessionId, roomId, matchOptions);
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return null;
    }

    @Override
    public TableView createTournamentTable(UUID roomId, TournamentOptions tournamentOptions) {
        try {
            if (this.isConnected()) {
                return this.server.roomCreateTournament(this.sessionId, roomId, tournamentOptions);
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return null;
    }

    @Override
    public boolean isTableOwner(UUID roomId, UUID tableId) {
        try {
            if (this.isConnected()) {
                return this.server.tableIsOwner(this.sessionId, roomId, tableId);
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return false;
    }

    @Override
    public boolean removeTable(UUID roomId, UUID tableId) {
        try {
            if (this.isConnected()) {
                this.server.tableRemove(this.sessionId, roomId, tableId);
                return true;
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return false;
    }

    @Override
    public boolean removeTable(UUID tableId) {
        try {
            if (this.isConnected()) {
                this.server.adminTableRemove(this.sessionId, tableId);
                return true;
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return false;
    }

    @Override
    public boolean swapSeats(UUID roomId, UUID tableId, int seatNum1, int seatNum2) {
        try {
            if (this.isConnected()) {
                this.server.tableSwapSeats(this.sessionId, roomId, tableId, seatNum1, seatNum2);
                return true;
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return false;
    }

    @Override
    public boolean leaveTable(UUID roomId, UUID tableId) {
        try {
            if (this.isConnected() && this.server.roomLeaveTableOrTournament(this.sessionId, roomId, tableId)) {
                return true;
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return false;
    }

    @Override
    public boolean startMatch(UUID roomId, UUID tableId) {
        try {
            if (this.isConnected()) {
                return this.server.matchStart(this.sessionId, roomId, tableId);
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        return false;
    }

    @Override
    public boolean startTournament(UUID roomId, UUID tableId) {
        try {
            if (this.isConnected() && this.server.tournamentStart(this.sessionId, roomId, tableId)) {
                return true;
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return false;
    }

    @Override
    public boolean submitDeck(UUID tableId, DeckCardLists deck) {
        try {
            if (this.isConnected()) {
                if (deck != null) {
                    deck.setCardLayout(null);
                    deck.setSideboardLayout(null);
                }
                return this.server.deckSubmit(this.sessionId, tableId, deck);
            }
        }
        catch (GameException ex) {
            this.handleGameException(ex);
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return false;
    }

    @Override
    public boolean updateDeck(UUID tableId, DeckCardLists deck) {
        try {
            if (this.isConnected()) {
                if (deck != null) {
                    deck.setCardLayout(null);
                    deck.setSideboardLayout(null);
                }
                this.server.deckSave(this.sessionId, tableId, deck);
                return true;
            }
        }
        catch (GameException ex) {
            this.handleGameException(ex);
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return false;
    }

    @Override
    public boolean quitMatch(UUID gameId) {
        try {
            if (this.isConnected()) {
                this.server.matchQuit(gameId, this.sessionId);
                return true;
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return false;
    }

    @Override
    public boolean quitTournament(UUID tournamentId) {
        try {
            if (this.isConnected()) {
                this.server.tournamentQuit(tournamentId, this.sessionId);
                return true;
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return false;
    }

    @Override
    public boolean quitDraft(UUID draftId) {
        try {
            if (this.isConnected()) {
                this.server.draftQuit(draftId, this.sessionId);
                return true;
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        return false;
    }

    @Override
    public boolean sendPlayerAction(PlayerAction passPriorityAction, UUID gameId, Object data) {
        try {
            if (this.isConnected()) {
                ActionData actionData = new ActionData("SEND_PLAYER_ACTION", gameId, this.getSessionId());
                actionData.value = passPriorityAction + (data != null ? " " + data.toString() : "");
                this.appendJsonLog(actionData);
                this.server.sendPlayerAction(passPriorityAction, gameId, this.sessionId, data);
                return true;
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return false;
    }

    @Override
    public boolean stopWatching(UUID gameId) {
        try {
            if (this.isConnected()) {
                this.server.gameWatchStop(gameId, this.sessionId);
                return true;
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return false;
    }

    @Override
    public boolean startReplay(UUID gameId) {
        try {
            if (this.isConnected()) {
                this.server.replayStart(gameId, this.sessionId);
                return true;
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return false;
    }

    @Override
    public boolean stopReplay(UUID gameId) {
        try {
            if (this.isConnected()) {
                this.server.replayStop(gameId, this.sessionId);
                return true;
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return false;
    }

    @Override
    public boolean nextPlay(UUID gameId) {
        try {
            if (this.isConnected()) {
                this.server.replayNext(gameId, this.sessionId);
                return true;
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return false;
    }

    @Override
    public boolean previousPlay(UUID gameId) {
        try {
            if (this.isConnected()) {
                this.server.replayPrevious(gameId, this.sessionId);
                return true;
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return false;
    }

    @Override
    public boolean skipForward(UUID gameId, int moves) {
        try {
            if (this.isConnected()) {
                this.server.replaySkipForward(gameId, this.sessionId, moves);
                return true;
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return false;
    }

    @Override
    public boolean cheatShow(UUID gameId, UUID playerId) {
        try {
            if (this.isConnected()) {
                this.server.cheatShow(gameId, this.sessionId, playerId);
                return true;
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return false;
    }

    @Override
    public List<UserView> getUsers() {
        try {
            if (this.isConnected()) {
                return this.server.adminGetUsers(this.sessionId);
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return null;
    }

    @Override
    public List<String> getServerMessages() {
        try {
            if (this.isConnected()) {
                return (List)CompressUtil.decompress(this.server.serverGetPromotionMessages(this.sessionId));
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return new ArrayList<String>();
    }

    @Override
    public boolean sendAdminDisconnectUser(String userSessionId) {
        try {
            if (this.isConnected()) {
                this.server.adminDisconnectUser(this.sessionId, userSessionId);
                return true;
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return false;
    }

    @Override
    public boolean sendAdminEndUserSession(String userSessionId) {
        try {
            if (this.isConnected()) {
                this.server.adminEndUserSession(this.sessionId, userSessionId);
                return true;
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return false;
    }

    @Override
    public boolean sendAdminMuteUserChat(String userName, long durationMinutes) {
        try {
            if (this.isConnected()) {
                this.server.adminMuteUser(this.sessionId, userName, durationMinutes);
                return true;
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return false;
    }

    @Override
    public boolean sendAdminActivateUser(String userName, boolean active) {
        try {
            if (this.isConnected()) {
                this.server.adminActivateUser(this.sessionId, userName, active);
                return true;
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return false;
    }

    @Override
    public boolean sendAdminToggleActivateUser(String userName) {
        try {
            if (this.isConnected()) {
                this.server.adminToggleActivateUser(this.sessionId, userName);
                return true;
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return false;
    }

    @Override
    public boolean sendAdminLockUser(String userName, long durationMinute) {
        try {
            if (this.isConnected()) {
                this.server.adminLockUser(this.sessionId, userName, durationMinute);
                return true;
            }
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return false;
    }

    private void handleThrowable(Throwable t) {
        if (t instanceof InterruptedException) {
            Thread.currentThread().interrupt();
            return;
        }
        if (t instanceof RuntimeException) {
            RuntimeException re = (RuntimeException)t;
            if (t.getCause() instanceof InterruptedException) {
                Thread.currentThread().interrupt();
                return;
            }
        }
        logger.fatal((Object)"Connection error: other", t);
    }

    private void handleMageException(MageException ex) {
        logger.fatal((Object)"Server error", (Throwable)ex);
        this.client.showError("Server error: " + ex.getMessage());
    }

    private void handleGameException(GameException ex) {
        logger.warn((Object)ex.getMessage());
        this.client.showError("Game error: " + ex.getMessage());
    }

    @Override
    public String getUserName() {
        String username = this.connection.getUsername();
        return username == null ? "" : username;
    }

    private String getEmail() {
        String email = this.connection.getEmail();
        return email == null ? "" : email;
    }

    private String getAuthToken() {
        String authToken = this.connection.getAuthToken();
        return authToken == null ? "" : authToken;
    }

    @Override
    public boolean updatePreferencesForServer(UserData userData) {
        try {
            if (this.isConnected()) {
                this.server.connectSetUserData(this.connection.getUsername(), this.sessionId, userData, null, null);
            }
            return true;
        }
        catch (MageException ex) {
            this.handleMageException(ex);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return false;
    }

    @Override
    public void ping() {
        try {
            String lastPing;
            if (!this.isConnected() || this.sessionId == null || this.serverState == null) {
                return;
            }
            long startTime = System.nanoTime();
            if (!this.server.ping(this.sessionId, this.lastPingInfo)) {
                logger.error((Object)("Ping failed: " + this.getUserName() + " Session: " + this.sessionId + " to MAGE server at " + this.connection.getHost() + ':' + this.connection.getPort()));
                throw new MageException("Ping failed");
            }
            this.pingTime.add(System.nanoTime() - startTime);
            long milliSeconds = TimeUnit.MILLISECONDS.convert(this.pingTime.getLast(), TimeUnit.NANOSECONDS);
            String string = lastPing = milliSeconds > 0L ? milliSeconds + "ms" : "<1ms";
            if (this.pingTime.size() > 10) {
                this.pingTime.poll();
            }
            long sum = 0L;
            for (Long time : this.pingTime) {
                sum += time.longValue();
            }
            milliSeconds = TimeUnit.MILLISECONDS.convert(sum / (long)this.pingTime.size(), TimeUnit.NANOSECONDS);
            this.lastPingInfo = lastPing + " (avg: " + (milliSeconds > 0L ? milliSeconds + "ms" : "<1ms") + ')';
        }
        catch (MageException ex) {
            this.handleMageException(ex);
            this.connectStop(true, true);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
            this.connectStop(true, true);
        }
    }

    @Override
    public String getVersionInfo() {
        if (this.serverState != null) {
            return this.serverState.getVersion().toString();
        }
        return "<no server state>";
    }

    @Override
    public boolean isJsonLogActive() {
        return this.jsonLogActive;
    }

    @Override
    public void setJsonLogActive(boolean jsonLogActive) {
        this.jsonLogActive = jsonLogActive;
    }

    private void setLastError(String error) {
        this.lastError = error;
    }

    @Override
    public String getLastError() {
        return this.lastError;
    }

    class MageClientConnectionListener
    implements ConnectionListener {
        MageClientConnectionListener() {
        }

        public void handleConnectionException(Throwable throwable, Client client) {
            logger.info((Object)"Connect: lost connection to server.", throwable);
            SessionImpl.this.connectReconnect(throwable);
        }
    }

    class CallbackHandler
    implements InvokerCallbackHandler {
        final CopyOnWriteArrayList<ClientCallback> waitingCallbacks = new CopyOnWriteArrayList();

        CallbackHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleCallback(Callback callback) {
            ArrayList<ClientCallback> executingCallbacks;
            ClientCallback clientCallback = (ClientCallback)callback.getCallbackObject();
            this.waitingCallbacks.add(clientCallback);
            if (SessionImpl.this.serverState == null) {
                ThreadUtils.sleep((int)3000);
                if (SessionImpl.this.serverState == null) {
                    logger.error((Object)("Can't receive server state before other data (possible reason: unstable network): " + clientCallback.getInfo()));
                }
            }
            CopyOnWriteArrayList<ClientCallback> copyOnWriteArrayList = this.waitingCallbacks;
            synchronized (copyOnWriteArrayList) {
                executingCallbacks = new ArrayList<ClientCallback>(this.waitingCallbacks);
                executingCallbacks.sort(Comparator.comparingInt(ClientCallback::getMessageId));
                this.waitingCallbacks.clear();
            }
            try {
                executingCallbacks.forEach(SessionImpl.this.client::onCallback);
            }
            catch (Exception ex) {
                logger.error((Object)"handleCallback error", (Throwable)ex);
            }
        }
    }

    public abstract class RemotingTask {
        SwingWorker<Boolean, Object> worker = null;
        Throwable lastError = null;

        public abstract boolean work() throws Throwable;

        boolean doWork() throws Throwable {
            this.worker = new SwingWorker<Boolean, Object>(){

                @Override
                protected Boolean doInBackground() {
                    try {
                        return RemotingTask.this.work();
                    }
                    catch (Throwable t) {
                        RemotingTask.this.lastError = t;
                        return false;
                    }
                }
            };
            this.worker.execute();
            boolean res = this.worker.get();
            if (this.lastError != null) {
                throw this.lastError;
            }
            return res;
        }

        public void cancel() {
            if (this.worker != null) {
                this.worker.cancel(true);
            }
        }
    }

    private static enum SessionState {
        DISCONNECTED,
        CONNECTED,
        CONNECTING,
        DISCONNECTING,
        SERVER_STARTING;

    }
}

