/*
 * Decompiled with CFR 0.152.
 */
package mage.utils;

import java.io.Serializable;
import mage.util.JarVersion;

public class MageVersion
implements Serializable,
Comparable<MageVersion> {
    public static final int MAGE_VERSION_MAJOR = 1;
    public static final int MAGE_VERSION_MINOR = 4;
    public static final int MAGE_VERSION_RELEASE = 58;
    public static final String MAGE_VERSION_RELEASE_INFO = "V1";
    private static final boolean MAGE_VERSION_RELEASE_INFO_MUST_BE_SAME = true;
    public static final boolean MAGE_VERSION_SHOW_BUILD_TIME = true;
    private final int major;
    private final int minor;
    private final int release;
    private final String releaseInfo;
    private final String buildTime;

    public MageVersion(Class sourceClass) {
        this(1, 4, 58, MAGE_VERSION_RELEASE_INFO, sourceClass);
    }

    public MageVersion(int major, int minor, int release, String releaseInfo, Class sourceClass) {
        this.major = major;
        this.minor = minor;
        this.release = release;
        this.releaseInfo = releaseInfo;
        if (!releaseInfo.startsWith("V")) {
            throw new IllegalArgumentException("ERROR, release info must be started from V.");
        }
        this.buildTime = JarVersion.getBuildTime((Class)sourceClass);
    }

    public String toString(boolean showBuildTime) {
        String res = this.major + "." + this.minor + '.' + this.release + "-" + this.releaseInfo;
        if (showBuildTime && !this.buildTime.isEmpty()) {
            res = res + " (build: " + this.buildTime + ")";
        }
        return res;
    }

    public String toString() {
        return this.toString(true);
    }

    @Override
    public int compareTo(MageVersion o) {
        if (this.major != o.major) {
            return this.major - o.major;
        }
        if (this.minor != o.minor) {
            return this.minor - o.minor;
        }
        if (this.release != o.release) {
            return this.release - o.release;
        }
        if (!this.releaseInfo.equals(o.releaseInfo)) {
            return this.releaseInfo.compareTo(o.releaseInfo);
        }
        return 0;
    }

    public boolean isDeveloperBuild() {
        return this.buildTime.contains("runtime");
    }

    public String getBuildTime() {
        return this.buildTime;
    }
}

