/*
 * Decompiled with CFR 0.152.
 */
package mage.utils.testers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mage.abilities.Ability;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.Targets;
import mage.util.DebugUtil;
import mage.utils.testers.BaseTestableDialog;
import mage.utils.testers.TargetTestableResult;
import mage.utils.testers.TestableDialogsRunner;

class ChooseTargetTestableDialog
extends BaseTestableDialog {
    Target target;
    boolean isPlayerChoice;
    boolean isTargetChoice;
    boolean isYou;

    public ChooseTargetTestableDialog(boolean isPlayerChoice, boolean isTargetChoice, boolean notTarget, boolean isYou, String name, Target target) {
        super(String.format("%s%s(%s, %s)", isPlayerChoice ? "player.choose" : "target.choose", isTargetChoice ? "Target" : "", isYou ? "you" : "AI", notTarget ? "not target" : "target"), name, target.toString(), new TargetTestableResult());
        this.isPlayerChoice = isPlayerChoice;
        this.isTargetChoice = isTargetChoice;
        this.target = target.withNotTarget(notTarget);
        this.isYou = isYou;
    }

    @Override
    public void showDialog(Player player, Ability source, Game game, Player opponent) {
        boolean chooseRes;
        String chooseDebugSource;
        Player choosingPlayer;
        Target choosingTarget = this.target.copy();
        Player player2 = choosingPlayer = this.isYou ? player : opponent;
        if (this.isPlayerChoice) {
            if (this.isTargetChoice) {
                chooseDebugSource = DebugUtil.getMethodNameWithSource((int)0, (String)"class");
                chooseRes = choosingPlayer.chooseTarget(Outcome.Benefit, choosingTarget, source, game);
            } else {
                chooseDebugSource = DebugUtil.getMethodNameWithSource((int)0, (String)"class");
                chooseRes = choosingPlayer.choose(Outcome.Benefit, choosingTarget, source, game);
            }
        } else if (this.isTargetChoice) {
            chooseDebugSource = DebugUtil.getMethodNameWithSource((int)0, (String)"class");
            chooseRes = choosingTarget.chooseTarget(Outcome.Benefit, choosingPlayer.getId(), source, game);
        } else {
            chooseDebugSource = DebugUtil.getMethodNameWithSource((int)0, (String)"class");
            chooseRes = choosingTarget.choose(Outcome.Benefit, choosingPlayer.getId(), source, game);
        }
        ArrayList<String> res = new ArrayList<String>();
        if (chooseRes) {
            Targets.printDebugTargets((String)(this.getGroup() + " - " + this.getName() + " - TRUE"), (Targets)new Targets(new Target[]{choosingTarget}), (Ability)source, (Game)game, res);
        } else {
            Targets.printDebugTargets((String)(this.getGroup() + " - " + this.getName() + " - FALSE"), (Targets)new Targets(new Target[]{choosingTarget}), (Ability)source, (Game)game, res);
        }
        ((TargetTestableResult)this.getResult()).onFinish(chooseDebugSource, chooseRes, res, choosingTarget);
    }

    private ChooseTargetTestableDialog aiMustChoose(boolean resStatus, int targetsCount) {
        TargetTestableResult res = (TargetTestableResult)this.getResult();
        res.aiAssertEnabled = true;
        res.aiAssertResStatus = resStatus;
        res.aiAssertTargetsCount = targetsCount;
        return this;
    }

    public static void register(TestableDialogsRunner runner) {
        List<Boolean> notTargets = Arrays.asList(false, true);
        List<Boolean> isYous = Arrays.asList(false, true);
        List<Boolean> isPlayerChoices = Arrays.asList(false, true);
        List<Boolean> isTargetChoices = Arrays.asList(false, true);
        for (boolean notTarget : notTargets) {
            for (boolean isYou : isYous) {
                for (boolean isTargetChoice : isTargetChoices) {
                    for (boolean isPlayerChoice : isPlayerChoices) {
                        runner.registerDialog(new ChooseTargetTestableDialog(isPlayerChoice, isTargetChoice, notTarget, isYou, "any 0 e.g. X=0", ChooseTargetTestableDialog.createAnyTarget(0, 0)).aiMustChoose(false, 0));
                        runner.registerDialog(new ChooseTargetTestableDialog(isPlayerChoice, isTargetChoice, notTarget, isYou, "any 1", ChooseTargetTestableDialog.createAnyTarget(1, 1)).aiMustChoose(true, 1));
                        runner.registerDialog(new ChooseTargetTestableDialog(isPlayerChoice, isTargetChoice, notTarget, isYou, "any 3", ChooseTargetTestableDialog.createAnyTarget(3, 3)).aiMustChoose(true, 3));
                        runner.registerDialog(new ChooseTargetTestableDialog(isPlayerChoice, isTargetChoice, notTarget, isYou, "any 5", ChooseTargetTestableDialog.createAnyTarget(5, 5)).aiMustChoose(true, 5));
                        runner.registerDialog(new ChooseTargetTestableDialog(isPlayerChoice, isTargetChoice, notTarget, isYou, "any max", ChooseTargetTestableDialog.createAnyTarget(0, Integer.MAX_VALUE)).aiMustChoose(true, 7));
                        runner.registerDialog(new ChooseTargetTestableDialog(isPlayerChoice, isTargetChoice, notTarget, isYou, "any 0-1", ChooseTargetTestableDialog.createAnyTarget(0, 1)).aiMustChoose(true, 1));
                        runner.registerDialog(new ChooseTargetTestableDialog(isPlayerChoice, isTargetChoice, notTarget, isYou, "any 0-3", ChooseTargetTestableDialog.createAnyTarget(0, 3)).aiMustChoose(true, 3));
                        runner.registerDialog(new ChooseTargetTestableDialog(isPlayerChoice, isTargetChoice, notTarget, isYou, "any 0-5", ChooseTargetTestableDialog.createAnyTarget(0, 5)).aiMustChoose(true, 5));
                        runner.registerDialog(new ChooseTargetTestableDialog(isPlayerChoice, isTargetChoice, notTarget, isYou, "any 1-3", ChooseTargetTestableDialog.createAnyTarget(1, 3)).aiMustChoose(true, 3));
                        runner.registerDialog(new ChooseTargetTestableDialog(isPlayerChoice, isTargetChoice, notTarget, isYou, "any 2-3", ChooseTargetTestableDialog.createAnyTarget(2, 3)).aiMustChoose(true, 3));
                        runner.registerDialog(new ChooseTargetTestableDialog(isPlayerChoice, isTargetChoice, notTarget, isYou, "any 1-5", ChooseTargetTestableDialog.createAnyTarget(1, 5)).aiMustChoose(true, 5));
                        runner.registerDialog(new ChooseTargetTestableDialog(isPlayerChoice, isTargetChoice, notTarget, isYou, "any 2-5", ChooseTargetTestableDialog.createAnyTarget(2, 5)).aiMustChoose(true, 5));
                        runner.registerDialog(new ChooseTargetTestableDialog(isPlayerChoice, isTargetChoice, notTarget, isYou, "any 3-5", ChooseTargetTestableDialog.createAnyTarget(3, 5)).aiMustChoose(true, 5));
                        runner.registerDialog(new ChooseTargetTestableDialog(isPlayerChoice, isTargetChoice, notTarget, isYou, "any 4-5", ChooseTargetTestableDialog.createAnyTarget(4, 5)).aiMustChoose(true, 5));
                        runner.registerDialog(new ChooseTargetTestableDialog(isPlayerChoice, isTargetChoice, notTarget, isYou, "impossible 0, e.g. X=0", ChooseTargetTestableDialog.createImpossibleTarget(0, 0)).aiMustChoose(false, 0));
                        runner.registerDialog(new ChooseTargetTestableDialog(isPlayerChoice, isTargetChoice, notTarget, isYou, "impossible 1", ChooseTargetTestableDialog.createImpossibleTarget(1, 1)).aiMustChoose(false, 0));
                        runner.registerDialog(new ChooseTargetTestableDialog(isPlayerChoice, isTargetChoice, notTarget, isYou, "impossible 3", ChooseTargetTestableDialog.createImpossibleTarget(3, 3)).aiMustChoose(false, 0));
                        runner.registerDialog(new ChooseTargetTestableDialog(isPlayerChoice, isTargetChoice, notTarget, isYou, "impossible 0-1", ChooseTargetTestableDialog.createImpossibleTarget(0, 1)).aiMustChoose(false, 0));
                        runner.registerDialog(new ChooseTargetTestableDialog(isPlayerChoice, isTargetChoice, notTarget, isYou, "impossible 0-3", ChooseTargetTestableDialog.createImpossibleTarget(0, 3)).aiMustChoose(false, 0));
                        runner.registerDialog(new ChooseTargetTestableDialog(isPlayerChoice, isTargetChoice, notTarget, isYou, "impossible 1-3", ChooseTargetTestableDialog.createImpossibleTarget(1, 3)).aiMustChoose(false, 0));
                        runner.registerDialog(new ChooseTargetTestableDialog(isPlayerChoice, isTargetChoice, notTarget, isYou, "impossible 2-3", ChooseTargetTestableDialog.createImpossibleTarget(2, 3)).aiMustChoose(false, 0));
                        runner.registerDialog(new ChooseTargetTestableDialog(isPlayerChoice, isTargetChoice, notTarget, isYou, "impossible max", ChooseTargetTestableDialog.createImpossibleTarget(0, Integer.MAX_VALUE)).aiMustChoose(false, 0));
                        runner.registerDialog(new ChooseTargetTestableDialog(isPlayerChoice, isTargetChoice, notTarget, isYou, "player 0", ChooseTargetTestableDialog.createPlayerTarget(0, 0, notTarget)).aiMustChoose(false, 0));
                        runner.registerDialog(new ChooseTargetTestableDialog(isPlayerChoice, isTargetChoice, notTarget, isYou, "player 0-1", ChooseTargetTestableDialog.createPlayerTarget(0, 1, notTarget)).aiMustChoose(true, 1));
                        runner.registerDialog(new ChooseTargetTestableDialog(isPlayerChoice, isTargetChoice, notTarget, isYou, "player 0-2", ChooseTargetTestableDialog.createPlayerTarget(0, 2, notTarget)).aiMustChoose(true, 1));
                        runner.registerDialog(new ChooseTargetTestableDialog(isPlayerChoice, isTargetChoice, notTarget, isYou, "player 0-5", ChooseTargetTestableDialog.createPlayerTarget(0, 5, notTarget)).aiMustChoose(true, 1));
                        runner.registerDialog(new ChooseTargetTestableDialog(isPlayerChoice, isTargetChoice, notTarget, isYou, "player 1", ChooseTargetTestableDialog.createPlayerTarget(1, 1, notTarget)).aiMustChoose(true, 1));
                        runner.registerDialog(new ChooseTargetTestableDialog(isPlayerChoice, isTargetChoice, notTarget, isYou, "player 1-2", ChooseTargetTestableDialog.createPlayerTarget(1, 2, notTarget)).aiMustChoose(true, 1));
                        runner.registerDialog(new ChooseTargetTestableDialog(isPlayerChoice, isTargetChoice, notTarget, isYou, "player 1-5", ChooseTargetTestableDialog.createPlayerTarget(1, 5, notTarget)).aiMustChoose(true, 1));
                        runner.registerDialog(new ChooseTargetTestableDialog(isPlayerChoice, isTargetChoice, notTarget, isYou, "player 2", ChooseTargetTestableDialog.createPlayerTarget(2, 2, notTarget)).aiMustChoose(true, 2));
                        runner.registerDialog(new ChooseTargetTestableDialog(isPlayerChoice, isTargetChoice, notTarget, isYou, "player 2-5", ChooseTargetTestableDialog.createPlayerTarget(2, 5, notTarget)).aiMustChoose(true, 2));
                        runner.registerDialog(new ChooseTargetTestableDialog(isPlayerChoice, isTargetChoice, notTarget, isYou, "player 3", ChooseTargetTestableDialog.createPlayerTarget(3, 3, notTarget)).aiMustChoose(false, 0));
                        runner.registerDialog(new ChooseTargetTestableDialog(isPlayerChoice, isTargetChoice, notTarget, isYou, "player 3-5", ChooseTargetTestableDialog.createPlayerTarget(3, 5, notTarget)).aiMustChoose(false, 0));
                    }
                }
            }
        }
    }
}

