/*
 * Decompiled with CFR 0.152.
 */
package mage.view;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.view.GameView;

public class AbilityPickerView
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<UUID, String> choices = new LinkedHashMap<UUID, String>();
    private String message;
    private GameView gameView;

    public AbilityPickerView(GameView gameView, String objectName, List<? extends Ability> abilities, String message) {
        this.gameView = gameView;
        this.message = message;
        int num = 0;
        for (Ability ability : abilities) {
            String rule;
            ++num;
            if (objectName == null) {
                rule = ability.getRule(true);
            } else if (ability instanceof SpellAbility) {
                SpellAbility spell = (SpellAbility)ability;
                rule = this.getAbilityRules((Ability)spell, spell.getCardName());
                if (!rule.startsWith("Cast ")) {
                    rule = spell.toString() + ": " + rule;
                }
            } else {
                rule = this.getAbilityRules(ability, objectName);
            }
            this.choices.put(ability.getId(), num + ". " + rule);
        }
    }

    public AbilityPickerView(GameView gameView, Map<UUID, String> modes, String message) {
        this.gameView = gameView;
        this.choices = modes;
        this.message = message;
    }

    private String getAbilityRules(Ability ability, String objectName) {
        String rule = ability.getRule(objectName);
        if (rule.isEmpty()) {
            rule = ability.toString();
        }
        if (!rule.isEmpty()) {
            rule = Character.toUpperCase(rule.charAt(0)) + rule.substring(1);
        }
        return rule;
    }

    public Map<UUID, String> getChoices() {
        return this.choices;
    }

    public String getMessage() {
        return this.message;
    }

    public GameView getGameView() {
        return this.gameView;
    }
}

