/*
 * Decompiled with CFR 0.152.
 */
package mage.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.cards.Card;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.command.Dungeon;
import mage.game.command.Emblem;
import mage.game.command.Plane;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentToken;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;
import mage.util.GameLog;
import mage.view.AbilityView;
import mage.view.CardView;
import mage.view.DungeonView;
import mage.view.EmblemView;
import mage.view.PlaneView;
import org.apache.log4j.Logger;

public class CardsView
extends LinkedHashMap<UUID, CardView> {
    private static final Logger LOGGER = Logger.getLogger(CardsView.class);

    public CardsView() {
    }

    public CardsView(List<CardView> cardViews) {
        for (CardView view : cardViews) {
            this.put(view.getId(), view);
        }
    }

    public CardsView(Collection<? extends Card> cards) {
        for (Card card : cards) {
            this.put(card.getId(), new CardView(card));
        }
    }

    public CardsView(Game game, Collection<? extends Card> cards, UUID createdForPlayerId) {
        for (Card card : cards) {
            this.put(card.getId(), new CardView(card, game, CardUtil.canShowAsControlled((Card)card, (UUID)createdForPlayerId)));
        }
    }

    public CardsView(Game game, Collection<? extends Card> cards, UUID createdForPlayerId, boolean storeZone) {
        for (Card card : cards) {
            this.put(card.getId(), new CardView(card, game, CardUtil.canShowAsControlled((Card)card, (UUID)createdForPlayerId), storeZone));
        }
    }

    public CardsView(Collection<? extends Ability> abilities, Game game) {
        for (Ability ability : abilities) {
            Card sourceObject = null;
            CardView abilityView = null;
            boolean isCard = false;
            boolean isPermanent = false;
            switch (ability.getZone()) {
                case ALL: 
                case EXILED: 
                case GRAVEYARD: {
                    sourceObject = game.getCard(ability.getSourceId());
                    if (sourceObject == null) {
                        sourceObject = game.getPermanent(ability.getSourceId());
                    }
                    if (sourceObject == null) {
                        sourceObject = game.getObject(ability.getSourceId());
                        if (!(sourceObject instanceof PermanentToken)) break;
                        isPermanent = true;
                        break;
                    }
                    isCard = true;
                    break;
                }
                case BATTLEFIELD: {
                    sourceObject = game.getPermanent(ability.getSourceId());
                    if (sourceObject == null) {
                        sourceObject = game.getLastKnownInformation(ability.getSourceId(), Zone.BATTLEFIELD);
                    }
                    isPermanent = true;
                    break;
                }
                case STACK: 
                case HAND: 
                case LIBRARY: {
                    sourceObject = game.getObject(ability.getSourceId());
                    if (!(sourceObject instanceof Card)) break;
                    isCard = true;
                    break;
                }
                case OUTSIDE: {
                    sourceObject = game.getObject(ability.getSourceId());
                    if (sourceObject instanceof Card) {
                        isCard = true;
                    }
                    if (!(sourceObject instanceof Emblem)) break;
                    abilityView = new AbilityView(ability, sourceObject.getName(), new CardView(new EmblemView((Emblem)sourceObject, game)));
                    ((AbilityView)abilityView).setName(sourceObject.getName());
                    break;
                }
                case COMMAND: {
                    sourceObject = game.getObject(ability.getSourceId());
                    if (sourceObject instanceof Emblem) {
                        abilityView = new AbilityView(ability, sourceObject.getName(), new CardView(new EmblemView((Emblem)sourceObject, game)));
                        ((AbilityView)abilityView).setName(sourceObject.getName());
                        break;
                    }
                    if (sourceObject instanceof Dungeon) {
                        abilityView = new AbilityView(ability, sourceObject.getName(), new CardView(new DungeonView((Dungeon)sourceObject)));
                        ((AbilityView)abilityView).setName(sourceObject.getName());
                        break;
                    }
                    if (!(sourceObject instanceof Plane)) break;
                    abilityView = new AbilityView(ability, sourceObject.getName(), new CardView(new PlaneView((Plane)sourceObject, game)));
                    ((AbilityView)abilityView).setName(sourceObject.getName());
                }
            }
            if (sourceObject == null) continue;
            if (abilityView == null) {
                CardView sourceCardView = isPermanent ? new CardView((Card)((Permanent)sourceObject), game) : (isCard ? new CardView(sourceObject, game) : new CardView((MageObject)sourceObject, game));
                abilityView = new AbilityView(ability, sourceObject.getName(), sourceCardView);
            }
            if (!ability.getTargets().isEmpty()) {
                abilityView.addTargets(ability.getTargets(), ability.getEffects(), ability, game);
            } else {
                ArrayList<UUID> abilityTargets = new ArrayList<UUID>();
                for (Effect effect : ability.getEffects()) {
                    TargetPointer targetPointer = effect.getTargetPointer();
                    if (targetPointer == null) continue;
                    List targetList = targetPointer.getTargets(game, ability);
                    abilityTargets.addAll(targetList);
                }
                if (!abilityTargets.isEmpty()) {
                    abilityView.overrideTargets(abilityTargets);
                    ArrayList<String> names = new ArrayList<String>();
                    for (UUID uuid : abilityTargets) {
                        String newName;
                        MageObject mageObject = game.getObject(uuid);
                        if (mageObject == null || mageObject instanceof Card && ((Card)mageObject).isFaceDown(game) || names.contains(newName = GameLog.getColoredObjectIdNameForTooltip((MageObject)mageObject))) continue;
                        names.add(newName);
                    }
                    if (!names.isEmpty()) {
                        abilityView.getRules().add("<i>Related objects: " + ((Object)names).toString() + "</i>");
                    }
                }
            }
            this.put(ability.getId(), abilityView);
        }
        if (this.size() != abilities.size()) {
            LOGGER.error((Object)("Can't translate abilities list to cards view (need " + abilities.size() + ", but get " + this.size() + "). Abilities:\n" + abilities.stream().map(a -> a.getClass().getSimpleName() + " - " + a.getRule()).collect(Collectors.joining("\n"))));
        }
    }
}

