/*
 * Decompiled with CFR 0.152.
 */
package mage.view;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import mage.game.Game;
import mage.game.GameState;
import mage.game.Table;
import mage.game.match.Match;
import mage.game.match.MatchPlayer;
import mage.players.Player;
import mage.view.MatchView;
import mage.view.PlayerView;

public class GameEndView
implements Serializable {
    private PlayerView clientPlayer = null;
    private final List<PlayerView> players = new ArrayList<PlayerView>();
    private final Date startTime;
    private final Date endTime;
    private String gameInfo;
    private final String matchInfo;
    private final String additionalInfo;
    private boolean won;
    private final MatchView matchView;
    private int wins;
    private int loses;
    private final int winsNeeded;

    public GameEndView(GameState state, Game game, UUID playerId, Table table) {
        this.startTime = game.getStartTime();
        this.endTime = game.getEndTime();
        int winner = 0;
        Player you = null;
        for (Player player : state.getPlayers().values()) {
            PlayerView playerView = new PlayerView(player, state, game, playerId, null);
            if (playerView.getPlayerId().equals(playerId)) {
                this.clientPlayer = playerView;
                you = player;
                this.won = you.hasWon();
            }
            this.players.add(playerView);
            if (!player.hasWon()) continue;
            ++winner;
        }
        if (you != null) {
            this.gameInfo = you.hasWon() ? "You won the game on turn " + game.getTurnNum() + "." : (winner > 0 ? "You lost the game on turn " + game.getTurnNum() + "." : "Game is a draw on Turn " + game.getTurnNum() + ".");
        }
        this.matchView = new MatchView(table);
        Match match = table.getMatch();
        MatchPlayer matchWinner = null;
        this.winsNeeded = match.getOptions().getWinsNeeded();
        StringBuilder additonalText = new StringBuilder();
        for (MatchPlayer matchPlayer : match.getPlayers()) {
            if (matchPlayer.getPlayer().equals(you)) {
                this.wins = matchPlayer.getWins();
            }
            if (matchPlayer.isMatchWinner()) {
                matchWinner = matchPlayer;
            }
            if (matchPlayer.getPlayer().hasTimerTimeout()) {
                if (matchPlayer.getPlayer().equals(you)) {
                    additonalText.append("You run out of time. ");
                    continue;
                }
                additonalText.append(matchPlayer.getName()).append(" runs out of time. ");
                continue;
            }
            if (matchPlayer.getPlayer().hasIdleTimeout()) {
                if (matchPlayer.getPlayer().equals(you)) {
                    additonalText.append("You lost the match for being idle. ");
                    continue;
                }
                additonalText.append(matchPlayer.getName()).append(" lost for being idle. ");
                continue;
            }
            if (!matchPlayer.hasQuit()) continue;
            if (matchPlayer.getPlayer().equals(you)) {
                additonalText.append("You have quit the match. ");
                continue;
            }
            additonalText.append(matchPlayer.getName()).append(" has quit the match. ");
        }
        this.matchInfo = matchWinner != null ? (matchWinner.getPlayer().equals(you) ? "You won the match!" : matchWinner.getName() + " won the match!") : "You need " + (this.winsNeeded - this.wins == 1 ? "one more win " : this.winsNeeded - this.wins + " more wins ") + "to win the match.";
        this.additionalInfo = additonalText.toString();
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public List<PlayerView> getPlayers() {
        return this.players;
    }

    public String getGameInfo() {
        return this.gameInfo;
    }

    public String getMatchInfo() {
        return this.matchInfo;
    }

    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    public boolean hasWon() {
        return this.won;
    }

    public MatchView getMatchView() {
        return this.matchView;
    }

    public int getWins() {
        return this.wins;
    }

    public int getLoses() {
        return this.loses;
    }

    public int getWinsNeeded() {
        return this.winsNeeded;
    }

    public PlayerView getClientPlayer() {
        return this.clientPlayer;
    }
}

