/*
 * Decompiled with CFR 0.152.
 */
package mage.view;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mage.cards.Card;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentToken;
import mage.players.Player;
import mage.util.CardUtil;
import mage.view.CardView;

public class PermanentView
extends CardView {
    private static final long serialVersionUID = 1L;
    private boolean tapped;
    private final boolean flipped;
    private final boolean phasedIn;
    private final boolean summoningSickness;
    private final int damage;
    private List<UUID> attachments;
    private final CardView original;
    private final boolean copy;
    private final String nameOwner;
    private final String nameController;
    private final boolean controlled;
    private final UUID attachedTo;
    private final boolean morphed;
    private final boolean disguised;
    private final boolean manifested;
    private final boolean cloaked;
    private final boolean attachedToPermanent;
    private final boolean attachedControllerDiffers;

    public PermanentView(Permanent permanent, Card card, UUID createdForPlayerId, Game game) {
        super((Card)permanent, game, CardUtil.canShowAsControlled((Card)permanent, (UUID)createdForPlayerId));
        Permanent attachment;
        Player controller;
        Player owner;
        this.controlled = permanent.getControllerId() != null && permanent.getControllerId().equals(createdForPlayerId);
        this.tapped = permanent.isTapped();
        this.flipped = permanent.isFlipped();
        this.phasedIn = permanent.isPhasedIn();
        this.summoningSickness = permanent.hasSummoningSickness();
        this.morphed = permanent.isMorphed();
        this.disguised = permanent.isDisguised();
        this.manifested = permanent.isManifested();
        this.cloaked = permanent.isCloaked();
        this.damage = permanent.getDamage();
        this.attachments = new ArrayList<UUID>(permanent.getAttachments());
        this.attachedTo = permanent.getAttachedTo();
        if (this.isToken()) {
            this.original = new CardView(((PermanentToken)permanent).getToken().copy(), (Game)null);
            this.original.expansionSetCode = permanent.getExpansionSetCode();
            this.expansionSetCode = permanent.getExpansionSetCode();
        } else {
            boolean showFaceDownInfo = this.controlled || game != null && game.hasEnded();
            this.original = card != null && showFaceDownInfo ? new CardView(card.copy(), (Game)null) : null;
        }
        this.copy = permanent.isCopy();
        if (this.original != null && !this.original.getName().equals(this.getName())) {
            this.alternateName = permanent.isCopy() && permanent.isFlipCard() ? permanent.getFlipCardName() : this.original.getName();
        }
        this.nameOwner = permanent.getOwnerId() != null && !permanent.getOwnerId().equals(permanent.getControllerId()) ? ((owner = game.getPlayer(permanent.getOwnerId())) != null ? owner.getName() : "") : "";
        String nameController = "";
        if (game != null && (controller = game.getPlayer(permanent.getControllerId())) != null) {
            nameController = controller.getName();
        }
        this.nameController = nameController;
        boolean attachedToPermanent = false;
        boolean attachedControllerDiffers = false;
        if (game != null && (attachment = game.getPermanent(permanent.getAttachedTo())) != null) {
            attachedToPermanent = true;
            attachedControllerDiffers = !attachment.getControllerId().equals(permanent.getControllerId());
        }
        this.attachedToPermanent = attachedToPermanent;
        this.attachedControllerDiffers = attachedControllerDiffers;
    }

    public PermanentView(PermanentView permanentView, Card card, UUID createdForPlayerId, Game game) {
        super(permanentView);
        boolean showFaceDownInfo;
        this.controlled = permanentView.controlled;
        this.tapped = permanentView.isTapped();
        this.flipped = permanentView.isFlipped();
        this.phasedIn = permanentView.isPhasedIn();
        this.summoningSickness = permanentView.summoningSickness;
        this.damage = permanentView.damage;
        this.attachments = new ArrayList<UUID>(permanentView.attachments);
        boolean bl = showFaceDownInfo = this.controlled || game != null && game.hasEnded();
        if (this.isToken()) {
            this.original = new CardView(permanentView.original);
            this.original.expansionSetCode = permanentView.original.getExpansionSetCode();
            this.expansionSetCode = permanentView.original.getExpansionSetCode();
        } else {
            this.original = card != null && showFaceDownInfo ? new CardView(card.copy(), (Game)null) : null;
        }
        this.copy = permanentView.copy;
        this.nameOwner = permanentView.nameOwner;
        this.nameController = permanentView.nameController;
        this.attachedTo = permanentView.attachedTo;
        this.morphed = permanentView.morphed;
        this.disguised = permanentView.disguised;
        this.manifested = permanentView.manifested;
        this.cloaked = permanentView.cloaked;
        this.attachedToPermanent = permanentView.attachedToPermanent;
        this.attachedControllerDiffers = permanentView.attachedControllerDiffers;
    }

    public boolean isTapped() {
        return this.tapped;
    }

    public int getDamage() {
        return this.damage;
    }

    public boolean isFlipped() {
        return this.flipped;
    }

    public boolean isCopy() {
        return this.copy;
    }

    public boolean isPhasedIn() {
        return this.phasedIn;
    }

    public boolean hasSummoningSickness() {
        return this.summoningSickness;
    }

    public List<UUID> getAttachments() {
        return this.attachments;
    }

    public CardView getOriginal() {
        return this.original;
    }

    public void overrideTapped(boolean tapped) {
        this.tapped = tapped;
    }

    public String getNameOwner() {
        return this.nameOwner;
    }

    public String getNameController() {
        return this.nameController;
    }

    public boolean isControlled() {
        return this.controlled;
    }

    public UUID getAttachedTo() {
        return this.attachedTo;
    }

    public boolean isAttachedTo() {
        return this.attachedTo != null;
    }

    public boolean isAttachedToPermanent() {
        return this.attachedToPermanent;
    }

    public boolean isAttachedToDifferentlyControlledPermanent() {
        return this.attachedControllerDiffers;
    }

    public boolean isMorphed() {
        return this.morphed;
    }

    public boolean isDisguised() {
        return this.disguised;
    }

    public boolean isManifested() {
        return this.manifested;
    }

    public boolean isCloaked() {
        return this.cloaked;
    }
}

