/*
 * Decompiled with CFR 0.152.
 */
package mage.view;

import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import mage.MageObject;
import mage.game.Game;
import mage.game.command.Plane;
import mage.players.PlayableObjectStats;
import mage.view.CommandObjectView;

public class PlaneView
implements CommandObjectView,
Serializable {
    protected UUID id;
    protected String name;
    protected String imageFileName = "";
    protected int imageNumber = 0;
    protected String expansionSetCode = "";
    protected List<String> rules;
    protected PlayableObjectStats playableStats = new PlayableObjectStats();

    public PlaneView(Plane plane, Game game) {
        this.id = plane.getId();
        this.name = plane.getName();
        this.imageFileName = plane.getImageFileName();
        this.imageNumber = plane.getImageNumber();
        this.expansionSetCode = plane.getExpansionSetCode();
        this.rules = plane.getAbilities().getRules(game, (MageObject)plane);
    }

    @Override
    public String getExpansionSetCode() {
        return this.expansionSetCode;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public String getImageFileName() {
        return this.imageFileName;
    }

    @Override
    public int getImageNumber() {
        return this.imageNumber;
    }

    @Override
    public List<String> getRules() {
        return this.rules;
    }

    @Override
    public boolean isPlayable() {
        return this.playableStats.getPlayableAmount() > 0;
    }

    @Override
    public void setPlayableStats(PlayableObjectStats playableStats) {
        this.playableStats = playableStats;
    }

    @Override
    public PlayableObjectStats getPlayableStats() {
        return this.playableStats;
    }

    @Override
    public boolean isChoosable() {
        return false;
    }

    @Override
    public void setChoosable(boolean isChoosable) {
    }

    @Override
    public boolean isSelected() {
        return false;
    }

    @Override
    public void setSelected(boolean isSelected) {
    }
}

