/*
 * Decompiled with CFR 0.152.
 */
package mage.player.human;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import mage.MageIdentifier;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.ActivatedAbility;
import mage.abilities.Mode;
import mage.abilities.Modes;
import mage.abilities.PlayLandAbility;
import mage.abilities.SpecialAction;
import mage.abilities.SpellAbility;
import mage.abilities.TriggeredAbility;
import mage.abilities.costs.common.SacrificeSourceCost;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.Effects;
import mage.abilities.effects.RequirementEffect;
import mage.abilities.hint.HintUtils;
import mage.abilities.mana.ManaAbility;
import mage.cards.Card;
import mage.cards.CardImpl;
import mage.cards.CardWithSpellOption;
import mage.cards.Cards;
import mage.cards.ModalDoubleFacedCard;
import mage.cards.ModalDoubleFacedCardHalf;
import mage.cards.SplitCard;
import mage.cards.decks.Deck;
import mage.choices.Choice;
import mage.choices.ChoiceHintType;
import mage.choices.ChoiceImpl;
import mage.constants.AbilityType;
import mage.constants.ManaType;
import mage.constants.MultiAmountType;
import mage.constants.Outcome;
import mage.constants.PhaseStep;
import mage.constants.PlayerAction;
import mage.constants.RangeOfInfluence;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterAttackingCreature;
import mage.filter.common.FilterBlockingCreature;
import mage.filter.common.FilterCreatureForCombat;
import mage.filter.common.FilterCreatureForCombatBlock;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.GameImpl;
import mage.game.combat.CombatGroup;
import mage.game.draft.Draft;
import mage.game.events.DeclareAttackerEvent;
import mage.game.events.GameEvent;
import mage.game.match.Match;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.game.tournament.Tournament;
import mage.player.human.PlayerResponse;
import mage.players.Player;
import mage.players.PlayerImpl;
import mage.players.PlayerList;
import mage.players.net.UserData;
import mage.target.Target;
import mage.target.TargetAmount;
import mage.target.TargetCard;
import mage.target.common.TargetAttackingCreature;
import mage.target.common.TargetDefender;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;
import mage.util.DebugUtil;
import mage.util.GameLog;
import mage.util.ManaUtil;
import mage.util.MessageToClient;
import mage.util.MultiAmountMessage;
import mage.util.ThreadUtils;
import mage.utils.SystemUtil;
import org.apache.log4j.Logger;

public class HumanPlayer
extends PlayerImpl {
    private static final boolean ALLOW_USERS_TO_PUT_NON_PLAYABLE_SPELLS_ON_STACK_WORKAROUND = false;
    private transient Boolean responseOpenedForAnswer = false;
    private transient long responseLastWaitingThreadId = 0L;
    private final transient PlayerResponse response;
    private final int RESPONSE_WAITING_TIME_SECS = 30;
    private final int RESPONSE_WAITING_CHECK_MS = 100;
    protected static FilterCreatureForCombatBlock filterCreatureForCombatBlock = new FilterCreatureForCombatBlock();
    protected static FilterCreatureForCombat filterCreatureForCombat = new FilterCreatureForCombat();
    protected static FilterAttackingCreature filterAttack = new FilterAttackingCreature();
    protected static FilterBlockingCreature filterBlock = new FilterBlockingCreature();
    protected Choice replacementEffectChoice = null;
    private static final Logger logger = Logger.getLogger(HumanPlayer.class);
    protected HashSet<String> autoSelectReplacementEffects = new LinkedHashSet<String>();
    protected ManaCost currentlyUnpaidMana;
    protected Set<UUID> triggerAutoOrderAbilityFirst = new HashSet<UUID>();
    protected Set<UUID> triggerAutoOrderAbilityLast = new HashSet<UUID>();
    protected Set<String> triggerAutoOrderNameFirst = new HashSet<String>();
    protected Set<String> triggerAutoOrderNameLast = new HashSet<String>();
    protected Map<String, Boolean> requestAutoAnswerId = new HashMap<String, Boolean>();
    protected Map<String, Boolean> requestAutoAnswerText = new HashMap<String, Boolean>();
    protected boolean holdingPriority;
    protected ConcurrentLinkedQueue<PlayerResponse> actionQueue = new ConcurrentLinkedQueue();
    protected ConcurrentLinkedQueue<PlayerResponse> actionQueueSaved = new ConcurrentLinkedQueue();
    protected int actionIterations = 0;
    protected boolean recordingMacro = false;
    protected boolean macroTriggeredSelectionFlag;
    protected boolean activatingMacro = false;

    public HumanPlayer(String name, RangeOfInfluence range, int skill) {
        super(name, range);
        this.human = true;
        this.response = new PlayerResponse();
        this.initReplacementDialog();
    }

    private void initReplacementDialog() {
        this.replacementEffectChoice = new ChoiceImpl(true);
        this.replacementEffectChoice.setMessage("Choose replacement effect to resolve first");
        this.replacementEffectChoice.setSpecial(true, false, "Remember answer", "Choose same answer next time (you can reset saved answers by battlefield popup menu)");
    }

    public HumanPlayer(PlayerImpl sourcePlayer, PlayerResponse sourceResponse) {
        super(sourcePlayer);
        this.human = true;
        this.response = sourceResponse;
        this.initReplacementDialog();
    }

    public HumanPlayer(HumanPlayer player) {
        super((PlayerImpl)player);
        this.response = player.response;
        this.replacementEffectChoice = player.replacementEffectChoice;
        this.autoSelectReplacementEffects.addAll(player.autoSelectReplacementEffects);
        this.currentlyUnpaidMana = player.currentlyUnpaidMana;
        this.triggerAutoOrderAbilityFirst.addAll(player.triggerAutoOrderAbilityFirst);
        this.triggerAutoOrderAbilityLast.addAll(player.triggerAutoOrderAbilityLast);
        this.triggerAutoOrderNameFirst.addAll(player.triggerAutoOrderNameFirst);
        this.triggerAutoOrderNameLast.addAll(player.triggerAutoOrderNameLast);
        this.requestAutoAnswerId.putAll(player.requestAutoAnswerId);
        this.requestAutoAnswerText.putAll(player.requestAutoAnswerText);
        this.holdingPriority = player.holdingPriority;
        this.actionQueue.addAll(player.actionQueue);
        this.actionQueueSaved.addAll(player.actionQueueSaved);
        this.actionIterations = player.actionIterations;
        this.recordingMacro = player.recordingMacro;
        this.macroTriggeredSelectionFlag = player.macroTriggeredSelectionFlag;
        this.activatingMacro = player.activatingMacro;
    }

    protected boolean isExecutingMacro() {
        return !this.recordingMacro && (!this.actionQueue.isEmpty() || this.actionIterations > 0 && !this.actionQueueSaved.isEmpty());
    }

    protected boolean waitResponseOpen() {
        long currentThreadId;
        int currentTimesWaiting = 0;
        int maxTimesWaiting = 300;
        this.responseLastWaitingThreadId = currentThreadId = Thread.currentThread().getId();
        while (!this.responseOpenedForAnswer.booleanValue() && this.canRespond()) {
            if (this.responseLastWaitingThreadId != currentThreadId) {
                return false;
            }
            if (++currentTimesWaiting > maxTimesWaiting) {
                String possibleReason = this.response.getActiveAction() == null ? "maybe connection problem with another player/watcher" : "something wrong with your priority on " + this.response.getActiveAction();
                logger.warn((Object)String.format("Game frozen in waitResponseOpen for %d secs. User: %s; reason: %s; game: %s", 100 * currentTimesWaiting / 1000, this.getName(), possibleReason, this.response.getActiveGameInfo()));
                return false;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean pullResponseFromQueue(Game game) {
        PlayerResponse action;
        if (this.actionQueue.isEmpty() && this.actionIterations > 0 && !this.actionQueueSaved.isEmpty()) {
            this.actionQueue = new ConcurrentLinkedQueue<PlayerResponse>(this.actionQueueSaved);
            --this.actionIterations;
        }
        if ((action = this.actionQueue.poll()) != null) {
            if (action.getString() != null && action.getString().equals("resolveStack")) {
                action = this.actionQueue.poll();
                if (action == null) {
                    return false;
                }
                this.sendPlayerAction(PlayerAction.PASS_PRIORITY_UNTIL_STACK_RESOLVED, game, null);
            }
            PlayerResponse playerResponse = this.response;
            synchronized (playerResponse) {
                this.response.copyFrom(action);
                this.response.notifyAll();
                this.macroTriggeredSelectionFlag = false;
                return true;
            }
        }
        return false;
    }

    protected void prepareForResponse(Game game) {
        ThreadUtils.ensureRunInGameThread();
        if (game.getState().getPriorityPlayerId() != null) {
            if (this.getId() == null) {
                logger.fatal((Object)("Player with no ID: " + this.name));
                this.quit(game);
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Setting game priority for " + this.getId() + " [" + DebugUtil.getMethodNameWithSource((int)1, (String)"method") + ']'));
            }
            game.getState().setPriorityPlayerId(this.getId());
        }
        this.responseOpenedForAnswer = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForResponse(Game game) {
        ThreadUtils.ensureRunInGameThread();
        if (this.isExecutingMacro()) {
            this.pullResponseFromQueue(game);
            return;
        }
        boolean loop = true;
        while (loop) {
            this.response.clear();
            this.response.setActiveAction(game, DebugUtil.getMethodNameWithSource((int)1, (String)"method"));
            game.resumeTimer(this.getTurnControlledBy());
            this.responseOpenedForAnswer = true;
            loop = false;
            PlayerResponse playerResponse = this.response;
            synchronized (playerResponse) {
                try {
                    this.response.wait();
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.responseOpenedForAnswer = false;
                    game.pauseTimer(this.getTurnControlledBy());
                }
            }
            if (this.response.getAsyncWantConcede().booleanValue()) {
                ((GameImpl)game).checkConcede();
                if (game.hasEnded()) {
                    return;
                }
                if (this.canRespond()) {
                    loop = true;
                }
            }
            if (!this.response.getAsyncWantCheat().booleanValue()) continue;
            SystemUtil.executeCheatCommands((Game)game, null, (Player)this);
            game.fireUpdatePlayersEvent();
            if (this.isGameUnderControl() != game.getPlayer(this.getId()).isGameUnderControl()) {
                return;
            }
            if (!this.canRespond()) continue;
            loop = true;
        }
        if (this.recordingMacro && !this.macroTriggeredSelectionFlag) {
            this.actionQueueSaved.add(new PlayerResponse(this.response));
        }
    }

    private boolean canCallFeedback(Game game) {
        return !this.gameInCheckPlayableState(game) && !game.isSimulation();
    }

    public boolean chooseMulligan(Game game) {
        if (!this.canCallFeedback(game)) {
            return false;
        }
        while (this.canRespond()) {
            int nextHandSize = game.mulliganDownTo(this.playerId);
            String cardsCountInfo = nextHandSize + (nextHandSize == 1 ? " card" : " cards");
            String message = this.getHand().size() > nextHandSize ? "Mulligan " + HintUtils.prepareText((String)("down to " + cardsCountInfo), (Color)Color.YELLOW) + "?" : "Mulligan " + HintUtils.prepareText((String)"for free", (Color)Color.GREEN) + ", draw another " + cardsCountInfo + "?";
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("UI.left.btn.text", "Mulligan");
            options.put("UI.right.btn.text", "Keep");
            this.prepareForResponse(game);
            if (!this.isExecutingMacro()) {
                game.fireAskPlayerEvent(this.playerId, new MessageToClient(message), null, options);
            }
            this.waitForResponse(game);
            if (this.response.getBoolean() == null) continue;
            return this.response.getBoolean();
        }
        return false;
    }

    public boolean chooseUse(Outcome outcome, String message, Ability source, Game game) {
        return this.chooseUse(outcome, message, null, "Yes", "No", source, game);
    }

    public boolean chooseUse(Outcome outcome, String message, String secondMessage, String trueText, String falseText, Ability source, Game game) {
        String sourceName;
        if (!this.canCallFeedback(game)) {
            return false;
        }
        if (message == null) {
            throw new IllegalArgumentException("Wrong code usage: main message is null");
        }
        MessageToClient messageToClient = new MessageToClient(message, secondMessage);
        HashMap<String, String> options = new HashMap<String, String>(2);
        String autoAnswerMessage = message;
        if (trueText != null) {
            options.put("UI.left.btn.text", trueText);
        }
        if (falseText != null) {
            options.put("UI.right.btn.text", falseText);
        }
        if (source != null && (sourceName = this.getRelatedObjectName(source, game)) != null) {
            autoAnswerMessage = autoAnswerMessage.replace(sourceName, "{this}");
        }
        options.put("autoAnswerMessage", autoAnswerMessage);
        Boolean answer = null;
        if (source != null) {
            answer = this.requestAutoAnswerId.get(source.getOriginalId() + "#" + autoAnswerMessage);
        }
        if (answer == null) {
            answer = this.requestAutoAnswerText.get(autoAnswerMessage);
        }
        if (answer != null) {
            return answer;
        }
        while (this.canRespond()) {
            if (messageToClient.getSecondMessage() == null) {
                messageToClient.setSecondMessage(this.getRelatedObjectName(source, game));
            }
            this.prepareForResponse(game);
            if (!this.isExecutingMacro()) {
                game.fireAskPlayerEvent(this.playerId, messageToClient, source, options);
            }
            this.waitForResponse(game);
            if (this.response.getBoolean() == null) continue;
            return this.response.getBoolean();
        }
        return false;
    }

    private String getRelatedObjectName(Ability source, Game game) {
        if (source != null) {
            return this.getRelatedObjectName(source.getSourceId(), game);
        }
        return null;
    }

    private String getRelatedObjectName(UUID sourceId, Game game) {
        MageObject mageObject = game.getObject(sourceId);
        if (mageObject != null) {
            return mageObject.getLogName();
        }
        return null;
    }

    private String addSecondLineWithObjectName(String message, UUID sourceId, Game game) {
        if (sourceId != null) {
            Permanent mageObject = game.getPermanent(sourceId);
            if (mageObject == null) {
                mageObject = game.getCard(sourceId);
            }
            if (mageObject != null) {
                message = message + "<div style='font-size:11pt'>" + mageObject.getLogName() + "</div>";
            }
        }
        return message;
    }

    public int chooseReplacementEffect(Map<String, String> effectsMap, Map<String, MageObject> objectsMap, Game game) {
        if (this.gameInCheckPlayableState(game, true) || game.isSimulation()) {
            return 0;
        }
        if (effectsMap.size() <= 1) {
            return 0;
        }
        boolean useSameSettings = this.getControllingPlayersUserData(game).isUseSameSettingsForReplacementEffects();
        if (!this.autoSelectReplacementEffects.isEmpty()) {
            for (String autoText : this.autoSelectReplacementEffects) {
                int count = 0;
                for (String effectKey : effectsMap.keySet()) {
                    String currentText = this.prepareReplacementText(effectsMap.get(effectKey), useSameSettings);
                    if (currentText.equals(autoText)) {
                        return count;
                    }
                    ++count;
                }
            }
        }
        this.replacementEffectChoice.clearChoice();
        this.replacementEffectChoice.getChoices().clear();
        this.replacementEffectChoice.getKeyChoices().clear();
        effectsMap.forEach((key, value) -> {
            MageObject object = objectsMap.getOrDefault(key, null);
            this.replacementEffectChoice.withItem(key, value, null, (ChoiceHintType)(object != null ? ChoiceHintType.GAME_OBJECT : null), object != null ? object.getId().toString() : null);
        });
        int differentChoices = 0;
        String lastChoice = "";
        for (String value2 : this.replacementEffectChoice.getKeyChoices().values()) {
            if (lastChoice.equalsIgnoreCase(value2)) continue;
            lastChoice = value2;
            ++differentChoices;
        }
        if (differentChoices <= 1) {
            return 0;
        }
        while (this.canRespond()) {
            this.prepareForResponse(game);
            if (!this.isExecutingMacro()) {
                this.replacementEffectChoice.onChooseStart(game, this.playerId);
                game.fireChooseChoiceEvent(this.playerId, this.replacementEffectChoice);
            }
            this.waitForResponse(game);
            logger.debug((Object)("Choose effect: " + this.response.getString()));
            if (this.response.getString() == null) continue;
            if (this.response.getString().startsWith("#")) {
                this.replacementEffectChoice.setChoiceByKey(this.response.getString().substring(1), true);
                if (this.replacementEffectChoice.isChosen()) {
                    useSameSettings = this.getControllingPlayersUserData(game).isUseSameSettingsForReplacementEffects();
                    String effectText = this.prepareReplacementText(this.replacementEffectChoice.getChoiceValue(), useSameSettings);
                    this.autoSelectReplacementEffects.remove(effectText);
                    this.autoSelectReplacementEffects.add(effectText);
                }
            } else {
                this.replacementEffectChoice.setChoiceByKey(this.response.getString(), false);
            }
            if (this.replacementEffectChoice.getChoiceKey() == null) continue;
            int index = 0;
            for (String key2 : effectsMap.keySet()) {
                if (this.replacementEffectChoice.getChoiceKey().equals(key2)) {
                    this.replacementEffectChoice.onChooseEnd(game, this.playerId, this.replacementEffectChoice.getChoiceKey());
                    return index;
                }
                ++index;
            }
        }
        return 0;
    }

    private String prepareReplacementText(String fullText, boolean useSameSettingsForDifferentObjects) {
        if (useSameSettingsForDifferentObjects) {
            fullText = fullText.replaceAll("\\[\\w+\\]", "");
        }
        return fullText;
    }

    public boolean choose(Outcome outcome, Choice choice, Game game) {
        if (!this.canCallFeedback(game)) {
            return false;
        }
        if (choice.isKeyChoice() && choice.getKeyChoices().isEmpty()) {
            throw new IllegalArgumentException("Wrong code usage. Key choices must contains some values");
        }
        if (!choice.isKeyChoice() && choice.getChoices().isEmpty()) {
            throw new IllegalArgumentException("Wrong code usage. Choices must contains some values");
        }
        if (Outcome.PutManaInPool == outcome && choice.isManaColorChoice() && this.currentlyUnpaidMana != null) {
            Spell spellBeingCast;
            boolean caresAboutManaColor = false;
            if (game.getStack().getFirstOrNull() instanceof Spell && !(spellBeingCast = (Spell)game.getStack().getFirstOrNull()).isResolving() && spellBeingCast.getControllerId().equals(this.getId())) {
                CardImpl card = (CardImpl)game.getCard(spellBeingCast.getSourceId());
                caresAboutManaColor = card.caresAboutManaColor(game);
            }
            if (!caresAboutManaColor && ManaUtil.tryToAutoSelectAManaColor((Choice)choice, (ManaCost)this.currentlyUnpaidMana)) {
                return true;
            }
        }
        while (this.canRespond()) {
            this.prepareForResponse(game);
            if (!this.isExecutingMacro()) {
                choice.onChooseStart(game, this.playerId);
                game.fireChooseChoiceEvent(this.playerId, choice);
            }
            this.waitForResponse(game);
            String val = this.response.getString();
            if (val != null && !val.isEmpty()) {
                if (choice.isKeyChoice()) {
                    choice.setChoiceByKey(val);
                } else {
                    choice.setChoice(val);
                }
                choice.onChooseEnd(game, this.playerId, val);
                return true;
            }
            if (choice.isRequired()) continue;
            choice.onChooseEnd(game, this.playerId, null);
            return false;
        }
        return false;
    }

    public boolean choose(Outcome outcome, Target target, Ability source, Game game) {
        return this.choose(outcome, target, source, game, null);
    }

    public boolean choose(Outcome outcome, Target target, Ability source, Game game, Map<String, Serializable> options) {
        if (!this.canCallFeedback(game)) {
            return false;
        }
        UUID abilityControllerId = target.getAffectedAbilityControllerId(this.getId());
        if (options == null) {
            options = new HashMap<String, Serializable>();
        }
        if (target.isChoiceCompleted(abilityControllerId, source, game, null)) {
            return false;
        }
        while (this.canRespond()) {
            boolean required = target.isRequired(source != null ? source.getSourceId() : null, game);
            if (target.getTargets().size() >= target.getMinNumberOfTargets()) {
                required = false;
            }
            if (required && !target.canChoose(abilityControllerId, source, game)) break;
            Set possibleTargets = target.possibleTargets(abilityControllerId, source, game);
            if (required && possibleTargets.isEmpty()) break;
            UUID autoChosenId = target.tryToAutoChoose(abilityControllerId, source, game);
            if (autoChosenId != null && !target.contains(autoChosenId)) {
                target.add(autoChosenId, game);
                continue;
            }
            options.put("chosenTargets", new HashSet(target.getTargets()));
            this.prepareForResponse(game);
            if (!this.isExecutingMacro()) {
                game.fireSelectTargetEvent(this.getId(), new MessageToClient(target.getMessage(game), this.getRelatedObjectName(source, game)), possibleTargets, required, this.getOptions(target, options));
            }
            this.waitForResponse(game);
            UUID responseId = this.getFixedResponseUUID(game);
            if (responseId != null) {
                if (target.contains(responseId)) {
                    target.remove(responseId);
                    continue;
                }
                if (!possibleTargets.contains(responseId)) continue;
                target.add(responseId, game);
                if (!target.isChoiceCompleted(abilityControllerId, source, game, null)) continue;
                break;
            }
            if (!target.isChosen(game) && required) continue;
            break;
        }
        return target.isChosen(game) && target.getTargets().size() > 0;
    }

    public boolean chooseTarget(Outcome outcome, Target target, Ability source, Game game) {
        if (!this.canCallFeedback(game)) {
            return false;
        }
        UUID abilityControllerId = target.getAffectedAbilityControllerId(this.getId());
        HashMap<String, Serializable> options = new HashMap<String, Serializable>();
        while (this.canRespond()) {
            UUID responseId;
            Set possibleTargets = target.possibleTargets(abilityControllerId, source, game);
            boolean required = target.isRequired(source != null ? source.getSourceId() : null, game);
            if (possibleTargets.isEmpty() || target.getTargets().size() >= target.getMinNumberOfTargets()) {
                required = false;
            }
            if ((responseId = target.tryToAutoChoose(abilityControllerId, source, game)) == null) {
                options.put("chosenTargets", new HashSet(target.getTargets()));
                this.prepareForResponse(game);
                if (!this.isExecutingMacro()) {
                    game.fireSelectTargetEvent(this.getId(), new MessageToClient(target.getMessage(game), this.getRelatedObjectName(source, game)), possibleTargets, required, this.getOptions(target, options));
                }
                this.waitForResponse(game);
                responseId = this.getFixedResponseUUID(game);
            }
            if (responseId != null) {
                if (target.contains(responseId)) {
                    target.remove(responseId);
                    continue;
                }
                if (!possibleTargets.contains(responseId)) continue;
                target.addTarget(responseId, source, game);
                if (!target.isChoiceCompleted(abilityControllerId, source, game, null)) continue;
                return true;
            }
            if (target.isChosen(game)) {
                return false;
            }
            if (required) continue;
            return false;
        }
        return target.isChosen(game) && target.getTargets().size() > 0;
    }

    private Map<String, Serializable> getOptions(Target target, Map<String, Serializable> options) {
        if (options == null) {
            options = new HashMap<String, Serializable>();
        }
        if (target.getTargets().size() >= target.getMinNumberOfTargets() && !options.containsKey("UI.right.btn.text")) {
            options.put("UI.right.btn.text", (Serializable)((Object)"Done"));
        }
        options.put("targetZone", (Serializable)target.getZone());
        return options;
    }

    public boolean choose(Outcome outcome, Cards cards, TargetCard target, Ability source, Game game) {
        if (!this.canCallFeedback(game)) {
            return false;
        }
        if (cards == null || cards.isEmpty()) {
            return false;
        }
        UUID abilityControllerId = target.getAffectedAbilityControllerId(this.getId());
        while (this.canRespond()) {
            UUID autoChosenId;
            Set possibleTargets = target.possibleTargets(abilityControllerId, source, game, (Set)cards);
            boolean required = target.isRequired(source != null ? source.getSourceId() : null, game);
            int count = cards.count(target.getFilter(), abilityControllerId, source, game);
            if (count == 0 || target.getTargets().size() >= target.getMinNumberOfTargets()) {
                required = false;
            }
            if (required && possibleTargets.isEmpty()) {
                required = false;
            }
            if ((autoChosenId = target.tryToAutoChoose(abilityControllerId, source, game, (Collection)possibleTargets)) != null && !target.contains(autoChosenId)) {
                target.add(autoChosenId, game);
                continue;
            }
            Map<String, Serializable> options = this.getOptions((Target)target, null);
            options.put("chosenTargets", new HashSet(target.getTargets()));
            if (!possibleTargets.isEmpty()) {
                options.put("possibleTargets", (Serializable)((Object)possibleTargets));
            }
            this.prepareForResponse(game);
            if (!this.isExecutingMacro()) {
                game.fireSelectTargetEvent(this.playerId, new MessageToClient(target.getMessage(game)), cards, required, options);
            }
            this.waitForResponse(game);
            UUID responseId = this.getFixedResponseUUID(game);
            if (responseId != null) {
                if (target.contains(responseId)) {
                    target.remove(responseId);
                    continue;
                }
                if (!possibleTargets.contains(responseId)) continue;
                target.add(responseId, game);
                if (!target.isChoiceCompleted(abilityControllerId, source, game, cards)) continue;
                return true;
            }
            if (target.isChosen(game)) {
                return false;
            }
            if (required) continue;
            return false;
        }
        return false;
    }

    public boolean chooseTarget(Outcome outcome, Cards cards, TargetCard target, Ability source, Game game) {
        if (!this.canCallFeedback(game)) {
            return false;
        }
        if (cards == null || cards.isEmpty()) {
            return false;
        }
        UUID abilityControllerId = target.getAffectedAbilityControllerId(this.getId());
        while (this.canRespond()) {
            UUID responseId;
            Set possibleTargets;
            boolean required = target.isRequiredExplicitlySet() ? target.isRequired() : target.isRequired(source);
            int count = cards.count(target.getFilter(), abilityControllerId, source, game);
            if (count == 0 || target.getTargets().size() >= target.getMinNumberOfTargets()) {
                required = false;
            }
            if ((possibleTargets = target.possibleTargets(abilityControllerId, source, game, (Set)cards)).isEmpty()) {
                required = false;
            }
            if ((responseId = target.tryToAutoChoose(abilityControllerId, source, game, (Collection)possibleTargets)) == null) {
                Map<String, Serializable> options = this.getOptions((Target)target, null);
                options.put("chosenTargets", new HashSet(target.getTargets()));
                if (!possibleTargets.isEmpty()) {
                    options.put("possibleTargets", (Serializable)((Object)possibleTargets));
                }
                this.prepareForResponse(game);
                if (!this.isExecutingMacro()) {
                    game.fireSelectTargetEvent(this.playerId, new MessageToClient(target.getMessage(game), this.getRelatedObjectName(source, game)), cards, required, options);
                }
                this.waitForResponse(game);
                responseId = this.getFixedResponseUUID(game);
            }
            if (responseId != null) {
                if (target.contains(responseId)) {
                    target.remove(responseId);
                    continue;
                }
                if (!possibleTargets.contains(responseId)) continue;
                target.addTarget(responseId, source, game);
                if (!target.isChoiceCompleted(abilityControllerId, source, game, cards)) continue;
                return true;
            }
            if (target.getTargets().size() >= target.getMinNumberOfTargets()) {
                return true;
            }
            if (required) continue;
            return false;
        }
        return false;
    }

    public boolean chooseTargetAmount(Outcome outcome, TargetAmount target, Ability source, Game game) {
        List targets;
        MultiAmountType multiAmountType;
        if (!this.canCallFeedback(game)) {
            return false;
        }
        target.prepareAmount(source, game);
        if (target.getAmountRemaining() <= 0) {
            return false;
        }
        if (target.getMaxNumberOfTargets() == 0 && target.getMinNumberOfTargets() == 0) {
            return false;
        }
        if (source == null) {
            return false;
        }
        UUID abilityControllerId = target.getAffectedAbilityControllerId(this.getId());
        int amountTotal = target.getAmountTotal(game, source);
        if (amountTotal == 0) {
            return false;
        }
        MultiAmountType multiAmountType2 = multiAmountType = source.getRule().contains("damage") ? MultiAmountType.DAMAGE : MultiAmountType.P1P1;
        while (this.canRespond()) {
            UUID responseId;
            Set possibleTargets = target.possibleTargets(abilityControllerId, source, game);
            boolean required = target.isRequired(source.getSourceId(), game);
            if (possibleTargets.isEmpty() || target.getSize() >= target.getMinNumberOfTargets()) {
                required = false;
            }
            if ((responseId = target.tryToAutoChoose(abilityControllerId, source, game)) == null) {
                if (required && possibleTargets.isEmpty()) {
                    required = false;
                }
                Map<String, Serializable> options = this.getOptions((Target)target, null);
                options.put("chosenTargets", new HashSet(target.getTargets()));
                if (!possibleTargets.isEmpty()) {
                    options.put("possibleTargets", (Serializable)((Object)possibleTargets));
                }
                this.prepareForResponse(game);
                if (!this.isExecutingMacro()) {
                    String multiType = multiAmountType == MultiAmountType.DAMAGE ? " to divide %d damage" : " to distribute %d counters";
                    String message = target.getMessage(game) + String.format(multiType, amountTotal);
                    game.fireSelectTargetEvent(this.playerId, new MessageToClient(message, this.getRelatedObjectName(source, game)), possibleTargets, required, options);
                }
                this.waitForResponse(game);
                responseId = this.getFixedResponseUUID(game);
            }
            if (responseId != null) {
                if (target.contains(responseId)) {
                    target.remove(responseId);
                    continue;
                }
                if (!possibleTargets.contains(responseId) || target.getSize() >= amountTotal) continue;
                target.addTarget(responseId, source, game);
                continue;
            }
            if (required) continue;
            break;
        }
        if ((targets = target.getTargets()).isEmpty()) {
            return false;
        }
        if (targets.size() == 1) {
            target.setTargetAmount((UUID)targets.get(0), amountTotal, source, game);
            return true;
        }
        if (targets.size() == amountTotal) {
            for (Object targetId : targets) {
                target.setTargetAmount((UUID)targetId, 1, source, game);
            }
            return true;
        }
        if (targets.size() > amountTotal) {
            target.clearChosen();
            return false;
        }
        ArrayList<String> targetNames = new ArrayList<String>();
        for (UUID targetId : targets) {
            MageObject targetObject = game.getObject(targetId);
            if (targetObject != null) {
                targetNames.add(String.format("%s, P/T: %d/%d", targetObject.getLogName(), targetObject.getPower().getValue(), targetObject.getToughness().getValue()));
                continue;
            }
            Player player = game.getPlayer(targetId);
            if (player != null) {
                targetNames.add(String.format("%s, life: %d", player.getName(), player.getLife()));
                continue;
            }
            targetNames.add("ERROR, unknown target " + targetId.toString());
        }
        List targetValues = this.getMultiAmount(outcome, targetNames, 1, amountTotal, amountTotal, multiAmountType, game);
        for (int i = 0; i < targetValues.size(); ++i) {
            int newAmount = (Integer)targetValues.get(i);
            UUID targetId = (UUID)targets.get(i);
            if (newAmount <= 0) {
                target.remove(targetId);
                continue;
            }
            target.setTargetAmount(targetId, newAmount, source, game);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean priority(Game game) {
        this.passed = false;
        UserData controllingUserData = this.getControllingPlayersUserData(game);
        if (this.canRespond()) {
            if (this.getJustActivatedType() != null && !this.holdingPriority) {
                if (controllingUserData.isPassPriorityCast() && this.getJustActivatedType() == AbilityType.SPELL) {
                    this.setJustActivatedType(null);
                    this.pass(game);
                    return false;
                }
                if (controllingUserData.isPassPriorityActivation() && this.getJustActivatedType().isNonManaActivatedAbility()) {
                    this.setJustActivatedType(null);
                    this.pass(game);
                    return false;
                }
            }
            boolean quickStop = false;
            if (this.isGameUnderControl() && game.getTurnStepType() == PhaseStep.DECLARE_ATTACKERS && game.getCombat().getPlayerDefenders(game).contains(this.playerId)) {
                FilterCreatureForCombatBlock filter = filterCreatureForCombatBlock.copy();
                filter.add((Predicate)new ControllerIdPredicate(this.playerId));
                int possibleBlockersCount = game.getBattlefield().count((FilterPermanent)filter, this.playerId, null, game);
                boolean canStopOnAny = possibleBlockersCount != 0 && this.getControllingPlayersUserData(game).getUserSkipPrioritySteps().isStopOnDeclareBlockersWithAnyPermanents();
                boolean canStopOnZero = possibleBlockersCount == 0 && this.getControllingPlayersUserData(game).getUserSkipPrioritySteps().isStopOnDeclareBlockersWithZeroPermanents();
                boolean bl = quickStop = canStopOnAny || canStopOnZero;
            }
            if (!quickStop && this.isGameUnderControl()) {
                if ((this.passedAllTurns || this.passedTurnSkipStack) && this.passWithManaPoolCheck(game)) {
                    return false;
                }
                if (this.passedUntilEndStepBeforeMyTurn) {
                    if (game.getTurnStepType() != PhaseStep.END_TURN) {
                        if (this.passWithManaPoolCheck(game)) {
                            return false;
                        }
                    } else {
                        PlayerList playerList = game.getState().getPlayerList(this.playerId);
                        if (!((UUID)playerList.getPrevious()).equals(game.getActivePlayerId())) {
                            if (this.passWithManaPoolCheck(game)) {
                                return false;
                            }
                        } else {
                            this.passedUntilEndStepBeforeMyTurn = false;
                        }
                    }
                }
                if (game.getStack().isEmpty()) {
                    boolean dontCheckPassStep = false;
                    if (this.passedUntilStackResolved) {
                        this.passedUntilStackResolved = false;
                        dontCheckPassStep = true;
                    }
                    if ((this.passedTurn || this.passedTurnSkipStack) && this.passWithManaPoolCheck(game)) {
                        return false;
                    }
                    if (this.passedUntilNextMain) {
                        if (game.getTurnStepType() == PhaseStep.POSTCOMBAT_MAIN || game.getTurnStepType() == PhaseStep.PRECOMBAT_MAIN) {
                            if (!this.skippedAtLeastOnce || !this.playerId.equals(game.getActivePlayerId()) && !controllingUserData.getUserSkipPrioritySteps().isStopOnAllMainPhases()) {
                                this.skippedAtLeastOnce = true;
                                if (this.passWithManaPoolCheck(game)) {
                                    return false;
                                }
                            } else {
                                dontCheckPassStep = true;
                                this.passedUntilNextMain = false;
                            }
                        } else {
                            this.skippedAtLeastOnce = true;
                            if (this.passWithManaPoolCheck(game)) {
                                return false;
                            }
                        }
                    }
                    if (this.passedUntilEndOfTurn) {
                        if (game.getTurnStepType() == PhaseStep.END_TURN) {
                            if (!this.skippedAtLeastOnce || this.playerId.equals(game.getActivePlayerId()) && !controllingUserData.getUserSkipPrioritySteps().isStopOnAllEndPhases()) {
                                this.skippedAtLeastOnce = true;
                                if (this.passWithManaPoolCheck(game)) {
                                    return false;
                                }
                            } else {
                                dontCheckPassStep = true;
                                this.passedUntilEndOfTurn = false;
                            }
                        } else {
                            this.skippedAtLeastOnce = true;
                            if (this.passWithManaPoolCheck(game)) {
                                return false;
                            }
                        }
                    }
                    if (!dontCheckPassStep && this.checkPassStep(game, controllingUserData) && this.passWithManaPoolCheck(game)) {
                        return false;
                    }
                } else {
                    boolean haveNewObjectsOnStack = !Objects.equals(this.dateLastAddedToStack, game.getStack().getDateLastAdded());
                    this.dateLastAddedToStack = game.getStack().getDateLastAdded();
                    if (this.passedUntilStackResolved && haveNewObjectsOnStack && this.playerId.equals(game.getActivePlayerId()) && controllingUserData.getUserSkipPrioritySteps().isStopOnStackNewObjects()) {
                        this.passedUntilStackResolved = false;
                    }
                    if (this.passedUntilStackResolved && this.passWithManaPoolCheck(game)) {
                        return false;
                    }
                }
            }
            while (this.canRespond()) {
                this.holdingPriority = false;
                this.prepareForResponse(game);
                if (!this.isExecutingMacro()) {
                    game.firePriorityEvent(this.playerId);
                }
                this.waitForResponse(game);
                if (game.executingRollback()) {
                    return true;
                }
                if (this.response.getBoolean() == null && this.response.getInteger() == null) break;
                if (!this.activatingMacro && this.passWithManaPoolCheck(game)) {
                    return false;
                }
                if (!this.activatingMacro) continue;
                ConcurrentLinkedQueue<PlayerResponse> haveNewObjectsOnStack = this.actionQueue;
                synchronized (haveNewObjectsOnStack) {
                    this.actionQueue.notifyAll();
                }
            }
            UUID responseId = this.getFixedResponseUUID(game);
            if (this.response.getString() == null || !this.response.getString().equals("special")) {
                if (responseId != null) {
                    Zone zone;
                    boolean result = false;
                    MageObject object = game.getObject(responseId);
                    if (object != null && (zone = game.getState().getZone(object.getId())) != null) {
                        Map useableAbilities = new LinkedHashMap();
                        HumanPlayer actingPlayer = null;
                        if (this.playerId.equals(game.getPriorityPlayerId())) {
                            actingPlayer = this;
                        } else if (this.getPlayersUnderYourControl().contains(game.getPriorityPlayerId())) {
                            actingPlayer = game.getPlayer(game.getPriorityPlayerId());
                        }
                        if (actingPlayer != null) {
                            useableAbilities = actingPlayer.getPlayableActivatedAbilities(object, zone, game);
                        }
                        if (object instanceof Card && ((Card)object).isFaceDown(game) && this.lookAtFaceDownCard((Card)object, game, useableAbilities.size())) {
                            result = true;
                        } else if (!useableAbilities.isEmpty()) {
                            this.activateAbility(useableAbilities, object, game);
                            result = true;
                        }
                    }
                    return result;
                }
                return this.response.getManaType() == null;
            }
            this.activateSpecialAction(game, null);
            return true;
        }
        return false;
    }

    private UUID getFixedResponseUUID(Game game) {
        MageObject object = game.getObject(this.response.getUUID());
        if (object instanceof ModalDoubleFacedCardHalf && !Zone.BATTLEFIELD.equals((Object)game.getState().getZone(object.getId())) && !Zone.STACK.equals((Object)game.getState().getZone(object.getId()))) {
            return ((ModalDoubleFacedCardHalf)object).getMainCard().getId();
        }
        return this.response.getUUID();
    }

    private boolean checkPassStep(Game game, UserData controllingUserData) {
        try {
            if (this.playerId.equals(game.getActivePlayerId())) {
                return !controllingUserData.getUserSkipPrioritySteps().getYourTurn().isPhaseStepSet(game.getTurnStepType());
            }
            return !controllingUserData.getUserSkipPrioritySteps().getOpponentTurn().isPhaseStepSet(game.getTurnStepType());
        }
        catch (NullPointerException ex) {
            if (controllingUserData != null) {
                if (controllingUserData.getUserSkipPrioritySteps() != null) {
                    if (game.getStep() != null) {
                        if (game.getTurnStepType() == null) {
                            logger.error((Object)"game.getTurnStepType() == null");
                        }
                    } else {
                        logger.error((Object)"game.getStep() == null");
                    }
                } else {
                    logger.error((Object)"UserData.getUserSkipPrioritySteps == null");
                }
            } else {
                logger.error((Object)"UserData == null");
            }
            return false;
        }
    }

    public TriggeredAbility chooseTriggeredAbility(List<TriggeredAbility> abilities, Game game) {
        if (!this.canCallFeedback(game)) {
            return abilities.isEmpty() ? null : abilities.get(0);
        }
        String autoOrderRuleText = null;
        TriggeredAbility autoOrderAbility = null;
        boolean autoOrderUse = this.getControllingPlayersUserData(game).isAutoOrderTrigger();
        while (this.canRespond()) {
            ArrayList<TriggeredAbility> abilitiesWithNoOrderSet = new ArrayList<TriggeredAbility>();
            ArrayList<TriggeredAbility> abilitiesOrderLast = new ArrayList<TriggeredAbility>();
            for (TriggeredAbility ability : abilities) {
                if (this.triggerAutoOrderAbilityFirst.contains(ability.getOriginalId())) {
                    return ability;
                }
                MageObject object = game.getObject(ability.getSourceId());
                String rule = ability.getRule(object != null ? object.getName() : null);
                if (this.triggerAutoOrderNameFirst.contains(rule)) {
                    return ability;
                }
                if (this.triggerAutoOrderAbilityLast.contains(ability.getOriginalId())) {
                    abilitiesOrderLast.add(ability);
                    continue;
                }
                if (this.triggerAutoOrderNameLast.contains(rule)) {
                    abilitiesOrderLast.add(ability);
                    continue;
                }
                if (autoOrderUse) {
                    if (autoOrderRuleText == null) {
                        autoOrderRuleText = rule;
                        autoOrderAbility = ability;
                    } else if (!rule.equals(autoOrderRuleText)) {
                        autoOrderUse = false;
                    } else {
                        Effects effects1 = autoOrderAbility.getEffects();
                        Effects effects2 = ability.getEffects();
                        if (effects1.size() != effects2.size()) {
                            autoOrderUse = false;
                        } else {
                            for (int i = 0; i < effects1.size(); ++i) {
                                List targets2;
                                TargetPointer targetPointer1 = ((Effect)effects1.get(i)).getTargetPointer();
                                TargetPointer targetPointer2 = ((Effect)effects2.get(i)).getTargetPointer();
                                List targets1 = targetPointer1 == null ? new ArrayList() : targetPointer1.getTargets(game, (Ability)autoOrderAbility);
                                List list = targets2 = targetPointer2 == null ? new ArrayList() : targetPointer2.getTargets(game, (Ability)ability);
                                if (targets1.equals(targets2)) continue;
                                autoOrderUse = false;
                                break;
                            }
                        }
                    }
                }
                abilitiesWithNoOrderSet.add(ability);
            }
            if (abilitiesWithNoOrderSet.isEmpty()) {
                return abilitiesOrderLast.stream().findFirst().orElse(null);
            }
            if (abilitiesWithNoOrderSet.size() == 1 || autoOrderUse) {
                return (TriggeredAbility)abilitiesWithNoOrderSet.iterator().next();
            }
            ArrayList<TriggeredAbility> processingAbilities = new ArrayList<TriggeredAbility>(abilitiesWithNoOrderSet);
            processingAbilities.addAll(abilitiesOrderLast);
            if (abilities.size() != processingAbilities.size()) {
                throw new IllegalStateException(String.format("Choose dialog lost some of the triggered abilities:\nMust %d:\n%s\nHas %d:\n%s", abilities.size(), abilities.stream().map(Ability::getRule).collect(Collectors.joining("\n")), processingAbilities.size(), processingAbilities.stream().map(Ability::getRule).collect(Collectors.joining("\n"))));
            }
            this.macroTriggeredSelectionFlag = true;
            this.prepareForResponse(game);
            if (!this.isExecutingMacro()) {
                game.fireSelectTargetTriggeredAbilityEvent(this.playerId, "Pick triggered ability (goes to the stack first)", abilitiesWithNoOrderSet);
            }
            this.waitForResponse(game);
            UUID responseId = this.getFixedResponseUUID(game);
            if (responseId == null) continue;
            for (TriggeredAbility ability : abilitiesWithNoOrderSet) {
                if (!ability.getId().equals(responseId) && (this.macroTriggeredSelectionFlag || !ability.getSourceId().equals(responseId))) continue;
                if (this.recordingMacro) {
                    PlayerResponse tResponse = new PlayerResponse();
                    tResponse.setUUID(ability.getSourceId());
                    this.actionQueueSaved.add(tResponse);
                    logger.debug((Object)("Adding Triggered Ability Source: " + tResponse));
                }
                this.macroTriggeredSelectionFlag = false;
                return ability;
            }
        }
        this.macroTriggeredSelectionFlag = false;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean playMana(Ability abilityToCast, ManaCost unpaid, String promptText, Game game) {
        this.payManaMode = true;
        try {
            boolean bl = this.playManaHandling(abilityToCast, unpaid, promptText, game);
            return bl;
        }
        finally {
            this.payManaMode = false;
        }
    }

    protected boolean playManaHandling(Ability abilityToCast, ManaCost unpaid, String promptText, Game game) {
        if (!this.canCallFeedback(game)) {
            return false;
        }
        if (this.canRespond()) {
            HashMap options = new HashMap();
            this.prepareForResponse(game);
            if (!this.isExecutingMacro()) {
                game.firePlayManaEvent(this.playerId, "Pay " + promptText, options);
            }
            this.waitForResponse(game);
            UUID responseId = this.getFixedResponseUUID(game);
            if (this.response.getBoolean() != null) {
                return false;
            }
            if (responseId != null) {
                this.playManaAbilities(responseId, abilityToCast, unpaid, game);
            } else if (this.response.getString() != null && this.response.getString().equals("special")) {
                if (unpaid instanceof ManaCostsImpl) {
                    this.activateSpecialAction(game, unpaid);
                }
            } else if (this.response.getManaType() != null && this.response.getManaPlayerId().equals(this.getId())) {
                this.getManaPool().unlockManaType(this.response.getManaType());
            }
            return true;
        }
        return false;
    }

    public int announceRepetitions(Game game) {
        if (!this.canCallFeedback(game)) {
            return 0;
        }
        int xValue = 0;
        while (this.canRespond()) {
            this.prepareForResponse(game);
            game.fireGetAmountEvent(this.playerId, "How many times do you want to repeat your shortcut?", 0, 999);
            this.waitForResponse(game);
            if (this.response.getInteger() == null) continue;
        }
        if (this.response.getInteger() != null) {
            xValue = this.response.getInteger();
        }
        return xValue;
    }

    public int announceX(int min, int max, String message, Game game, Ability source, boolean isManaPay) {
        if (!this.canCallFeedback(game)) {
            return min;
        }
        if (min >= max) {
            return min;
        }
        int xValue = min;
        while (this.canRespond()) {
            this.prepareForResponse(game);
            if (!this.isExecutingMacro()) {
                game.fireGetAmountEvent(this.playerId, message + CardUtil.getSourceLogName((Game)game, (Ability)source), min, max);
            }
            this.waitForResponse(game);
            if (this.response.getInteger() == null || (xValue = this.response.getInteger().intValue()) < min || xValue > max) continue;
        }
        return xValue;
    }

    protected void playManaAbilities(UUID objectId, Ability abilityToCast, ManaCost unpaid, Game game) {
        Map useableAbilities;
        Zone zone;
        MageObject object = game.getObject(objectId);
        if (object == null) {
            return;
        }
        if (abilityToCast.getAbilityType() == AbilityType.SPELL) {
            Spell spell = game.getStack().getSpell(abilityToCast.getSourceId());
            boolean haveManaAbilities = object.getAbilities().stream().anyMatch(ManaAbility.class::isInstance);
            if (spell != null && !spell.isResolving() && haveManaAbilities) {
                switch (spell.getCurrentActivatingManaAbilitiesStep()) {
                    case BEFORE: 
                    case NORMAL: {
                        break;
                    }
                    case AFTER: {
                        game.informPlayer((Player)this, "You can no longer use activated mana abilities to pay for the current spell (special mana pay already used). Cancel and recast the spell to activate mana abilities first.");
                        return;
                    }
                }
            }
        }
        if ((zone = game.getState().getZone(object.getId())) != null && !(useableAbilities = this.getUseableManaAbilities(object, zone, game)).isEmpty()) {
            boolean caresAboutManaColor = false;
            if (abilityToCast.getAbilityType() == AbilityType.SPELL) {
                CardImpl card = (CardImpl)game.getCard(abilityToCast.getSourceId());
                caresAboutManaColor = card.caresAboutManaColor(game);
            }
            if (!caresAboutManaColor) {
                useableAbilities = ManaUtil.tryToAutoPay((ManaCost)unpaid, (Map)useableAbilities);
            }
            this.currentlyUnpaidMana = unpaid;
            this.activateAbility(useableAbilities, object, game);
            this.currentlyUnpaidMana = null;
        }
    }

    public void selectAttackers(Game game, UUID attackingPlayerId) {
        if (!this.canCallFeedback(game)) {
            return;
        }
        FilterCreatureForCombat filter = filterCreatureForCombat.copy();
        filter.add((Predicate)new ControllerIdPredicate(attackingPlayerId));
        while (this.canRespond()) {
            Permanent attacker;
            ArrayList<UUID> possibleAttackers = new ArrayList<UUID>();
            for (Permanent possibleAttacker : game.getBattlefield().getActivePermanents((FilterPermanent)filter, attackingPlayerId, game)) {
                if (!possibleAttacker.canAttack(null, game)) continue;
                possibleAttackers.add(possibleAttacker.getId());
            }
            if ((this.passedAllTurns || this.passedUntilEndStepBeforeMyTurn || !this.getControllingPlayersUserData(game).getUserSkipPrioritySteps().isStopOnDeclareAttackers() && (this.passedTurn || this.passedTurnSkipStack || this.passedUntilEndOfTurn || this.passedUntilNextMain)) && this.checkIfAttackersValid(game)) {
                return;
            }
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put("possibleAttackers", possibleAttackers);
            if (!possibleAttackers.isEmpty()) {
                options.put("specialButton", "All attack");
            }
            this.prepareForResponse(game);
            if (!this.isExecutingMacro()) {
                game.fireSelectEvent(this.playerId, "Select attackers", options);
            }
            this.waitForResponse(game);
            UUID responseId = this.getFixedResponseUUID(game);
            if (this.response.getString() != null && this.response.getString().equals("special")) {
                this.setStoredBookmark(game.bookmarkState());
                UUID attackedDefender = null;
                if (game.getCombat().getDefenders().size() > 1) {
                    attackedDefender = this.selectDefenderForAllAttack(game.getCombat().getDefenders(), game);
                } else if (game.getCombat().getDefenders().size() == 1) {
                    attackedDefender = (UUID)game.getCombat().getDefenders().iterator().next();
                }
                for (Permanent attacker2 : game.getBattlefield().getAllActivePermanents((FilterPermanent)filterCreatureForCombat, this.getId(), game)) {
                    Set possibleDefenders;
                    if (game.getContinuousEffects().checkIfThereArePayCostToAttackBlockEffects((GameEvent)new DeclareAttackerEvent(attackedDefender, attacker2.getId(), attacker2.getControllerId()), game)) continue;
                    if (game.getCombat().getCreaturesForcedToAttack().containsKey(attacker2.getId()) && !(possibleDefenders = (Set)game.getCombat().getCreaturesForcedToAttack().get(attacker2.getId())).isEmpty() && !possibleDefenders.contains(attackedDefender)) {
                        this.declareAttacker(attacker2.getId(), (UUID)possibleDefenders.iterator().next(), game, false);
                        continue;
                    }
                    this.declareAttacker(attacker2.getId(), attackedDefender, game, false);
                }
                continue;
            }
            if (this.response.getInteger() != null) {
                if (!this.checkIfAttackersValid(game)) continue;
                return;
            }
            if (this.response.getBoolean() != null) {
                if (!this.checkIfAttackersValid(game)) continue;
                return;
            }
            if (responseId == null || (attacker = game.getPermanent(responseId)) == null) continue;
            if (filterCreatureForCombat.match(attacker, this.playerId, null, game)) {
                this.selectDefender(game.getCombat().getDefenders(), attacker.getId(), game);
                continue;
            }
            if (!filterAttack.match(attacker, this.playerId, null, game) || !game.getStack().isEmpty()) continue;
            this.removeAttackerIfPossible(game, attacker);
        }
    }

    private boolean checkIfAttackersValid(Game game) {
        if (!game.getCombat().getCreaturesForcedToAttack().isEmpty() && !game.getCombat().getAttackers().containsAll(game.getCombat().getCreaturesForcedToAttack().keySet())) {
            int forcedAttackers = 0;
            StringBuilder sb = new StringBuilder();
            for (UUID uUID : game.getCombat().getCreaturesForcedToAttack().keySet()) {
                Set possibleDefender;
                boolean validForcedAttacker = false;
                if (game.getCombat().getAttackers().contains(uUID) && ((possibleDefender = (Set)game.getCombat().getCreaturesForcedToAttack().get(uUID)).isEmpty() || possibleDefender.contains(game.getCombat().getDefenderId(uUID)))) {
                    validForcedAttacker = true;
                }
                if (validForcedAttacker) {
                    ++forcedAttackers;
                    continue;
                }
                Permanent creature = game.getPermanent(uUID);
                if (creature == null) continue;
                sb.append(creature.getIdName()).append(' ');
            }
            if (game.getCombat().getMaxAttackers() > forcedAttackers) {
                int requireToAttack = Math.min(game.getCombat().getMaxAttackers() - forcedAttackers, game.getCombat().getCreaturesForcedToAttack().size() - forcedAttackers);
                String string = (requireToAttack == 1 ? " more attacker that is " : " more attackers that are ") + "forced to attack.\nCreature" + (requireToAttack == 1 ? "" : "s") + " forced to attack: ";
                game.informPlayer((Player)this, sb.insert(0, string).insert(0, requireToAttack).insert(0, "You have to attack with ").toString());
                return false;
            }
        }
        HashSet<UUID> playersToAttackIfAble = new HashSet<UUID>();
        boolean mustAttack = false;
        for (Map.Entry entry : game.getContinuousEffects().getApplicableRequirementEffects(null, true, game).entrySet()) {
            RequirementEffect effect = (RequirementEffect)entry.getKey();
            for (Ability ability : (Set)entry.getValue()) {
                UUID playerToAttack = effect.playerMustBeAttackedIfAble(ability, game);
                if (playerToAttack != null) {
                    playersToAttackIfAble.add(playerToAttack);
                }
                if (!effect.mustAttack(game)) continue;
                mustAttack = true;
            }
        }
        if (!playersToAttackIfAble.isEmpty()) {
            HashSet checkPlayersToAttackIfAble = new HashSet(playersToAttackIfAble);
            for (CombatGroup combatGroup : game.getCombat().getGroups()) {
                checkPlayersToAttackIfAble.remove(combatGroup.getDefendingPlayerId());
            }
            for (UUID forcedToAttackId : checkPlayersToAttackIfAble) {
                Player forcedToAttack = game.getPlayer(forcedToAttackId);
                for (Permanent attacker : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, this.getId(), game)) {
                    UUID defendingPlayerId;
                    Set possibleDefenders;
                    if (game.getContinuousEffects().checkIfThereArePayCostToAttackBlockEffects((GameEvent)new DeclareAttackerEvent(forcedToAttackId, attacker.getId(), attacker.getControllerId()), game) || game.getCombat().getCreaturesForcedToAttack().containsKey(attacker.getId()) && !(possibleDefenders = (Set)game.getCombat().getCreaturesForcedToAttack().get(attacker.getId())).isEmpty() && !possibleDefenders.contains(forcedToAttackId) || playersToAttackIfAble.contains(defendingPlayerId = game.getCombat().getDefendingPlayerId(attacker.getId(), game)) || defendingPlayerId == null && !attacker.canAttackInPrinciple(forcedToAttackId, game)) continue;
                    game.informPlayer((Player)this, "You are forced to attack " + forcedToAttack.getName() + " or a controlled planeswalker e.g. with " + attacker.getIdName() + ".");
                    return false;
                }
            }
        }
        if (mustAttack && game.getCombat().getAttackers().isEmpty()) {
            for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, this.getId(), game)) {
                if (!permanent.canAttackInPrinciple(null, game)) continue;
                game.informPlayer((Player)this, "You are forced to attack with at least one creature, e.g. " + permanent.getIdName() + ".");
                return false;
            }
        }
        return true;
    }

    private void removeAttackerIfPossible(Game game, Permanent attacker) {
        for (Map.Entry entry : game.getContinuousEffects().getApplicableRequirementEffects(attacker, false, game).entrySet()) {
            RequirementEffect effect = (RequirementEffect)entry.getKey();
            if (!effect.mustAttack(game) || game.getCombat().getMaxAttackers() < game.getCombat().getCreaturesForcedToAttack().size() || game.getCombat().getDefenders().size() != 1) continue;
            return;
        }
        game.getCombat().removeAttacker(attacker.getId(), game);
    }

    protected boolean selectDefender(Set<UUID> defenders, UUID attackerId, Game game) {
        boolean forcedToAttack = false;
        Set<UUID> possibleDefender = (Set<UUID>)game.getCombat().getCreaturesForcedToAttack().get(attackerId);
        if (possibleDefender != null) {
            forcedToAttack = true;
        }
        if (possibleDefender == null || possibleDefender.isEmpty()) {
            possibleDefender = defenders;
        }
        if (possibleDefender.size() == 1) {
            this.declareAttacker(attackerId, possibleDefender.iterator().next(), game, true);
            return true;
        }
        TargetDefender target = new TargetDefender(possibleDefender);
        if (forcedToAttack) {
            StringBuilder sb = new StringBuilder(target.getTargetName());
            Permanent attacker = game.getPermanent(attackerId);
            if (attacker != null) {
                sb.append(" (").append(attacker.getName()).append(')');
                target.withTargetName(sb.toString());
            }
        }
        if (this.chooseTarget(Outcome.Damage, (Target)target, null, game)) {
            UUID defenderId = this.getFixedResponseUUID(game);
            this.declareAttacker(attackerId, defenderId, game, true);
            return true;
        }
        return false;
    }

    protected UUID selectDefenderForAllAttack(Set<UUID> defenders, Game game) {
        TargetDefender target = new TargetDefender(defenders);
        if (this.chooseTarget(Outcome.Damage, (Target)target, null, game)) {
            return this.getFixedResponseUUID(game);
        }
        return null;
    }

    public void selectBlockers(Ability source, Game game, UUID defendingPlayerId) {
        boolean skipButtonActivated;
        if (!this.canCallFeedback(game)) {
            return;
        }
        FilterCreatureForCombatBlock filter = filterCreatureForCombatBlock.copy();
        filter.add((Predicate)new ControllerIdPredicate(defendingPlayerId));
        int possibleBlockersCount = game.getBattlefield().count((FilterPermanent)filter, this.playerId, source, game);
        boolean canStopOnAny = possibleBlockersCount != 0 && this.getControllingPlayersUserData(game).getUserSkipPrioritySteps().isStopOnDeclareBlockersWithAnyPermanents();
        boolean bl = skipButtonActivated = this.passedAllTurns || this.passedUntilEndStepBeforeMyTurn || this.passedTurn || this.passedUntilEndOfTurn || this.passedUntilNextMain;
        if (skipButtonActivated && !canStopOnAny) {
            return;
        }
        if (possibleBlockersCount == 0) {
            return;
        }
        while (this.canRespond()) {
            Permanent blocker;
            this.prepareForResponse(game);
            if (!this.isExecutingMacro()) {
                HashMap<String, Serializable> options = new HashMap<String, Serializable>();
                List possibleBlockers = game.getBattlefield().getActivePermanents((FilterPermanent)filter, this.playerId, game).stream().map(p -> p.getId()).collect(Collectors.toList());
                options.put("possibleBlockers", (Serializable)((Object)possibleBlockers));
                game.fireSelectEvent(this.playerId, "Select blockers", options);
            }
            this.waitForResponse(game);
            UUID responseId = this.getFixedResponseUUID(game);
            if (this.response.getBoolean() != null) {
                return;
            }
            if (this.response.getInteger() != null) {
                return;
            }
            if (responseId == null || (blocker = game.getPermanent(responseId)) == null) continue;
            boolean removeBlocker = false;
            if (filter.match(blocker, this.playerId, source, game)) {
                this.selectCombatGroup(defendingPlayerId, blocker.getId(), game);
            } else if (filterBlock.match(blocker, this.playerId, source, game) && game.getStack().isEmpty()) {
                removeBlocker = true;
            }
            if (!removeBlocker) continue;
            game.getCombat().removeBlocker(blocker.getId(), game);
        }
    }

    protected void selectCombatGroup(UUID defenderId, UUID blockerId, Game game) {
        CombatGroup group;
        if (!this.canCallFeedback(game)) {
            return;
        }
        if (!this.canRespond()) {
            return;
        }
        UUID responseId = null;
        if (!this.isExecutingMacro()) {
            TargetAttackingCreature target = new TargetAttackingCreature();
            Permanent blocker = game.getPermanent(blockerId);
            Set allAttackers = target.possibleTargets(this.playerId, null, game);
            HashSet<UUID> possibleAttackersToBlock = new HashSet<UUID>();
            for (UUID attackerId : allAttackers) {
                CombatGroup group2 = game.getCombat().findGroup(attackerId);
                if (group2 == null || blocker == null || !group2.canBlock(blocker, game)) continue;
                possibleAttackersToBlock.add(attackerId);
            }
            if (possibleAttackersToBlock.size() == 1) {
                responseId = (UUID)possibleAttackersToBlock.stream().iterator().next();
            } else {
                this.prepareForResponse(game);
                game.fireSelectTargetEvent(this.playerId, new MessageToClient("Select attacker to block", this.getRelatedObjectName(blockerId, game)), possibleAttackersToBlock, false, this.getOptions((Target)target, null));
                this.waitForResponse(game);
            }
        }
        if (responseId == null) {
            responseId = this.getFixedResponseUUID(game);
        }
        if (this.response.getBoolean() == null && responseId != null && (group = game.getCombat().findGroup(responseId)) != null) {
            if (!group.getBlockers().contains(blockerId)) {
                this.declareBlocker(defenderId, blockerId, responseId, game);
            } else {
                game.getCombat().removeBlockerGromGroup(blockerId, group, game);
            }
        }
    }

    public int getAmount(int min, int max, String message, Ability source, Game game) {
        if (!this.canCallFeedback(game)) {
            return min;
        }
        if (min >= max) {
            return min;
        }
        int xValue = min;
        while (this.canRespond()) {
            this.prepareForResponse(game);
            if (!this.isExecutingMacro()) {
                game.fireGetAmountEvent(this.playerId, message + CardUtil.getSourceLogName((Game)game, (Ability)source), min, max);
            }
            this.waitForResponse(game);
            if (this.response.getInteger() == null || (xValue = this.response.getInteger().intValue()) < min || xValue > max) continue;
        }
        return xValue;
    }

    public List<Integer> getMultiAmountWithIndividualConstraints(Outcome outcome, List<MultiAmountMessage> messages, int totalMin, int totalMax, MultiAmountType type, Game game) {
        int needCount = messages.size();
        List defaultList = MultiAmountType.prepareDefaultValues(messages, (int)totalMin, (int)totalMax);
        if (needCount == 0 || needCount == 1 && totalMin == totalMax || messages.stream().map(m -> m.min == m.max).reduce(true, Boolean::logicalAnd).booleanValue()) {
            return defaultList;
        }
        if (!this.canCallFeedback(game)) {
            return defaultList;
        }
        List answer = null;
        while (this.canRespond()) {
            this.prepareForResponse(game);
            if (!this.isExecutingMacro()) {
                HashMap<String, Object> options = new HashMap<String, Object>(2);
                options.put("title", type.getTitle());
                options.put("header", type.getHeader());
                if (type.isCanCancel()) {
                    options.put("canCancel", true);
                }
                game.fireGetMultiAmountEvent(this.playerId, messages, totalMin, totalMax, options);
            }
            this.waitForResponse(game);
            if (this.response.getString() != null) {
                answer = MultiAmountType.parseAnswer((String)this.response.getString(), messages, (int)totalMin, (int)totalMax, (boolean)false);
                if (MultiAmountType.isGoodValues((List)answer, messages, (int)totalMin, (int)totalMax)) break;
                answer = null;
                logger.error((Object)String.format("GUI return wrong MultiAmountType values: %d %d %d - %s", needCount, totalMin, totalMax, this.response.getString()));
                game.informPlayer((Player)this, "Error, you must enter correct values.");
                continue;
            }
            if (!type.isCanCancel() || this.response.getBoolean() == null) continue;
            answer = null;
            break;
        }
        if (answer != null) {
            return answer;
        }
        if (type.isCanCancel()) {
            return null;
        }
        return defaultList;
    }

    public void sideboard(Match match, Deck deck) {
        match.fireSideboardEvent(this.playerId, deck);
    }

    public void construct(Tournament tournament, Deck deck) {
        tournament.fireConstructEvent(this.playerId);
    }

    public void pickCard(List<Card> cards, Deck deck, Draft draft) {
        draft.firePickCardEvent(this.playerId);
    }

    protected void activateSpecialAction(Game game, ManaCost unpaidForManaAction) {
        if (!this.canCallFeedback(game)) {
            return;
        }
        if (!this.canRespond()) {
            return;
        }
        Map specialActions = game.getState().getSpecialActions().getControlledBy(this.playerId, unpaidForManaAction != null);
        if (!specialActions.isEmpty()) {
            this.prepareForResponse(game);
            if (!this.isExecutingMacro()) {
                game.fireGetChoiceEvent(this.playerId, this.name, null, new ArrayList(specialActions.values()));
            }
            this.waitForResponse(game);
            UUID responseId = this.getFixedResponseUUID(game);
            SpecialAction specialAction = specialActions.getOrDefault(responseId, null);
            if (specialAction != null) {
                this.activateAbility((ActivatedAbility)specialAction, game);
            }
        }
    }

    public boolean activateAbility(ActivatedAbility ability, Game game) {
        this.getManaPool().setStock();
        return super.activateAbility(ability, game);
    }

    protected void activateAbility(Map<UUID, ? extends ActivatedAbility> abilities, MageObject object, Game game) {
        ActivatedAbility ability;
        if (!this.canCallFeedback(game)) {
            return;
        }
        if (!this.canRespond()) {
            return;
        }
        if (!(abilities.size() != 1 || !this.suppressAbilityPicker(abilities.values().iterator().next(), game) || (ability = abilities.values().iterator().next()).getTargets().isEmpty() && ability.getCosts().size() == 1 && ability.getCosts().get(0) instanceof SacrificeSourceCost && ability.getCosts().size() == 2 && ability.getCosts().get(0) instanceof TapSourceCost && ability.getCosts().get(0) instanceof SacrificeSourceCost)) {
            this.activateAbility(ability, game);
            return;
        }
        if (this.userData.isUseFirstManaAbility() && object instanceof Permanent && object.isLand(game) && (ability = abilities.values().iterator().next()).isActivatedAbility() && ability.isManaAbility()) {
            this.activateAbility(ability, game);
            return;
        }
        String message = "Choose spell or ability to play";
        if (object != null) {
            message = message + "<br>" + object.getLogName();
        }
        this.prepareForResponse(game);
        if (!this.isExecutingMacro()) {
            game.fireGetChoiceEvent(this.playerId, message, object, new ArrayList<ActivatedAbility>(abilities.values()));
        }
        this.waitForResponse(game);
        UUID responseId = this.getFixedResponseUUID(game);
        if (responseId != null && abilities.containsKey(responseId)) {
            this.activateAbility(abilities.get(responseId), game);
        }
    }

    private boolean suppressAbilityPicker(ActivatedAbility ability, Game game) {
        Card mainCard = game.getCard(CardUtil.getMainCardId((Game)game, (UUID)ability.getSourceId()));
        if (mainCard != null && !Zone.BATTLEFIELD.equals((Object)game.getState().getZone(mainCard.getId())) && (mainCard instanceof SplitCard || mainCard instanceof CardWithSpellOption || mainCard instanceof ModalDoubleFacedCard)) {
            return false;
        }
        if (ability instanceof PlayLandAbility) {
            return true;
        }
        if (!this.getCastSourceIdWithAlternateMana().getOrDefault(ability.getSourceId(), Collections.emptySet()).contains(MageIdentifier.Default) && ability.getManaCostsToPay().manaValue() > 0) {
            return true;
        }
        return ability.isManaActivatedAbility();
    }

    public SpellAbility chooseAbilityForCast(Card card, Game game, boolean noMana) {
        if (!this.canCallFeedback(game)) {
            return null;
        }
        if (!this.canRespond()) {
            return null;
        }
        MageObject object = game.getObject(card.getId());
        if (object != null) {
            String message = "Choose ability to cast" + (noMana ? " for FREE" : "") + "<br>" + object.getLogName();
            Map useableAbilities = PlayerImpl.getCastableSpellAbilities((Game)game, (UUID)this.playerId, (MageObject)object, (Zone)game.getState().getZone(object.getId()), (boolean)noMana);
            if (useableAbilities != null && useableAbilities.size() == 1) {
                return (SpellAbility)useableAbilities.values().iterator().next();
            }
            if (useableAbilities != null && !useableAbilities.isEmpty()) {
                this.prepareForResponse(game);
                if (!this.isExecutingMacro()) {
                    game.fireGetChoiceEvent(this.playerId, message, object, new ArrayList(useableAbilities.values()));
                }
                this.waitForResponse(game);
                UUID responseId = this.getFixedResponseUUID(game);
                if (responseId != null && useableAbilities.containsKey(responseId)) {
                    return (SpellAbility)useableAbilities.get(responseId);
                }
            }
        }
        return card.getSpellAbility();
    }

    public ActivatedAbility chooseLandOrSpellAbility(Card card, Game game, boolean noMana) {
        if (!this.canCallFeedback(game)) {
            return null;
        }
        if (!this.canRespond()) {
            return null;
        }
        MageObject object = game.getObject(card.getId());
        if (object != null) {
            LinkedHashMap<UUID, PlayLandAbility> useableAbilities = new LinkedHashMap<UUID, PlayLandAbility>(PlayerImpl.getCastableSpellAbilities((Game)game, (UUID)this.playerId, (MageObject)object, (Zone)game.getState().getZone(object.getId()), (boolean)noMana));
            if (this.canPlayLand() && this.isActivePlayer(game)) {
                for (Ability ability : card.getAbilities(game)) {
                    if (!(ability instanceof PlayLandAbility)) continue;
                    useableAbilities.put(ability.getId(), (PlayLandAbility)ability);
                }
            }
            switch (useableAbilities.size()) {
                case 0: {
                    return card.getSpellAbility();
                }
                case 1: {
                    return (ActivatedAbility)useableAbilities.values().iterator().next();
                }
            }
            this.prepareForResponse(game);
            if (!this.isExecutingMacro()) {
                String message = "Choose spell or ability to play" + (noMana ? " for FREE" : "") + "<br>" + object.getLogName();
                game.fireGetChoiceEvent(this.playerId, message, object, new ArrayList(useableAbilities.values()));
            }
            this.waitForResponse(game);
            ActivatedAbility response = (ActivatedAbility)useableAbilities.get(this.getFixedResponseUUID(game));
            if (response != null) {
                return response;
            }
        }
        return card.getSpellAbility();
    }

    public Mode chooseMode(Modes modes, Ability source, Game game) {
        if (!this.canCallFeedback(game)) {
            return null;
        }
        if (modes.size() == 0) {
            return null;
        }
        if (modes.size() == 1) {
            return modes.getMode();
        }
        boolean done = false;
        while (!done && this.canRespond()) {
            boolean canEndChoice;
            MageObject obj = game.getObject(source);
            LinkedHashMap<UUID, String> modeMap = new LinkedHashMap<UUID, String>();
            int modeIndex = 0;
            block1: for (Mode mode : modes.getAvailableModes(source, game)) {
                ++modeIndex;
                int timesSelected = modes.getSelectedStats(mode.getId());
                for (UUID selectedModeId : modes.getSelectedModes()) {
                    Mode selectedMode = modes.get((Object)selectedModeId);
                    if (mode.getId().equals(selectedMode.getId()) && !modes.isMayChooseSameModeMoreThanOnce()) continue block1;
                }
                if (!mode.getTargets().canChoose(source.getControllerId(), source, game)) continue;
                String modeText = mode.getEffects().getText(mode);
                if (obj != null) {
                    modeText = modeText.replace("{this}", obj.getName());
                }
                if (modes.isMayChooseSameModeMoreThanOnce() && timesSelected > 0) {
                    modeText = "(selected " + timesSelected + "x) " + modeText;
                }
                if (!modeText.isEmpty()) {
                    modeText = Character.toUpperCase(modeText.charAt(0)) + modeText.substring(1);
                }
                StringBuilder sb = new StringBuilder();
                if (mode.getPawPrintValue() > 0) {
                    for (int i = 0; i < mode.getPawPrintValue(); ++i) {
                        sb.append("{P}");
                    }
                    sb.append(": ");
                } else {
                    sb.append(modeIndex).append(". ");
                }
                modeMap.put(mode.getId(), sb.append(modeText).toString());
            }
            boolean bl = canEndChoice = modes.getSelectedModes().size() >= modes.getMinModes() && modes.getMaxPawPrints() == 0 || modes.getSelectedPawPrints() >= modes.getMaxPawPrints() && modes.getMaxPawPrints() > 0 || modes.isMayChooseNone();
            if (canEndChoice) {
                modeMap.put(Modes.CHOOSE_OPTION_DONE_ID, "Done");
            }
            modeMap.put(Modes.CHOOSE_OPTION_CANCEL_ID, "Cancel");
            String message = modes.getMaxPawPrints() == 0 ? "Choose mode (selected " + modes.getSelectedModes().size() + " of " + modes.getMaxModes(game, source) + ", min " + modes.getMinModes() + ")" : "Choose mode (selected " + modes.getSelectedPawPrints() + " of " + modes.getMaxPawPrints() + " {P})";
            if (obj != null) {
                message = message + "<br>" + obj.getLogName();
            }
            this.prepareForResponse(game);
            if (!this.isExecutingMacro()) {
                game.fireGetModeEvent(this.playerId, message, modeMap);
            }
            this.waitForResponse(game);
            UUID responseId = this.getFixedResponseUUID(game);
            if (responseId != null) {
                for (Mode mode : modes.getAvailableModes(source, game)) {
                    if (!mode.getId().equals(responseId)) continue;
                    return mode;
                }
                if (canEndChoice && Modes.CHOOSE_OPTION_DONE_ID.equals(responseId)) {
                    done = true;
                }
                if (Modes.CHOOSE_OPTION_CANCEL_ID.equals(responseId)) {
                    modes.clearSelectedModes();
                }
            } else if (canEndChoice) {
                // empty if block
            }
            if (source.isTriggeredAbility()) continue;
            done = true;
        }
        return null;
    }

    public boolean choosePile(Outcome outcome, String message, List<? extends Card> pile1, List<? extends Card> pile2, Game game) {
        if (!this.canCallFeedback(game)) {
            return false;
        }
        while (this.canRespond()) {
            this.prepareForResponse(game);
            if (!this.isExecutingMacro()) {
                game.fireChoosePileEvent(this.playerId, message, pile1, pile2);
            }
            this.waitForResponse(game);
            if (this.response.getBoolean() == null) continue;
        }
        if (this.response.getBoolean() != null) {
            return this.response.getBoolean();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResponseString(String responseString) {
        if (!this.waitResponseOpen()) {
            return;
        }
        PlayerResponse playerResponse = this.response;
        synchronized (playerResponse) {
            this.response.setString(responseString);
            this.response.notifyAll();
            logger.debug((Object)("Got response string from player: " + this.getId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResponseManaType(UUID manaTypePlayerId, ManaType manaType) {
        if (!this.waitResponseOpen()) {
            return;
        }
        PlayerResponse playerResponse = this.response;
        synchronized (playerResponse) {
            this.response.setManaType(manaType);
            this.response.setResponseManaPlayerId(manaTypePlayerId);
            this.response.notifyAll();
            logger.debug((Object)("Got response mana type from player: " + this.getId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResponseUUID(UUID responseUUID) {
        if (!this.waitResponseOpen()) {
            return;
        }
        PlayerResponse playerResponse = this.response;
        synchronized (playerResponse) {
            this.response.setUUID(responseUUID);
            this.response.notifyAll();
            logger.debug((Object)("Got response UUID from player: " + this.getId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResponseBoolean(Boolean responseBoolean) {
        if (!this.waitResponseOpen()) {
            return;
        }
        PlayerResponse playerResponse = this.response;
        synchronized (playerResponse) {
            this.response.setBoolean(responseBoolean);
            this.response.notifyAll();
            logger.debug((Object)("Got response boolean from player: " + this.getId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResponseInteger(Integer responseInteger) {
        if (!this.waitResponseOpen()) {
            return;
        }
        PlayerResponse playerResponse = this.response;
        synchronized (playerResponse) {
            this.response.setInteger(responseInteger);
            this.response.notifyAll();
            logger.debug((Object)("Got response integer from player: " + this.getId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        this.abort = true;
        PlayerResponse playerResponse = this.response;
        synchronized (playerResponse) {
            this.response.notifyAll();
            logger.debug((Object)("Got cancel action from player: " + this.getId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalPlayerConcede(boolean stopCurrentChooseDialog) {
        PlayerResponse playerResponse = this.response;
        synchronized (playerResponse) {
            this.response.setAsyncWantConcede();
            if (stopCurrentChooseDialog) {
                this.response.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalPlayerCheat() {
        PlayerResponse playerResponse = this.response;
        synchronized (playerResponse) {
            this.response.setAsyncWantCheat();
            this.response.notifyAll();
            logger.debug((Object)("Set cheat for waiting player: " + this.getId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void skip() {
        PlayerResponse playerResponse = this.response;
        synchronized (playerResponse) {
            this.response.setInteger(0);
            this.response.notifyAll();
            logger.debug((Object)("Got skip action from player: " + this.getId()));
        }
    }

    public HumanPlayer copy() {
        return new HumanPlayer(this);
    }

    public void sendPlayerAction(PlayerAction playerAction, Game game, Object data) {
        switch (playerAction) {
            case RESET_AUTO_SELECT_REPLACEMENT_EFFECTS: {
                this.autoSelectReplacementEffects.clear();
                break;
            }
            case TRIGGER_AUTO_ORDER_ABILITY_FIRST: 
            case TRIGGER_AUTO_ORDER_ABILITY_LAST: 
            case TRIGGER_AUTO_ORDER_NAME_FIRST: 
            case TRIGGER_AUTO_ORDER_NAME_LAST: 
            case TRIGGER_AUTO_ORDER_RESET_ALL: {
                this.setTriggerAutoOrder(playerAction, game, data);
                break;
            }
            case REQUEST_AUTO_ANSWER_ID_NO: 
            case REQUEST_AUTO_ANSWER_ID_YES: 
            case REQUEST_AUTO_ANSWER_TEXT_NO: 
            case REQUEST_AUTO_ANSWER_TEXT_YES: 
            case REQUEST_AUTO_ANSWER_RESET_ALL: {
                this.setRequestAutoAnswer(playerAction, game, data);
                break;
            }
            case HOLD_PRIORITY: {
                this.holdingPriority = true;
                break;
            }
            case UNHOLD_PRIORITY: {
                this.holdingPriority = false;
                break;
            }
            case TOGGLE_RECORD_MACRO: {
                return;
            }
            case PASS_PRIORITY_UNTIL_STACK_RESOLVED: {
                if (this.recordingMacro) {
                    logger.debug((Object)"Adding a resolveStack");
                    PlayerResponse tResponse = new PlayerResponse();
                    tResponse.setString("resolveStack");
                    this.actionQueueSaved.add(tResponse);
                }
                super.sendPlayerAction(playerAction, game, data);
                break;
            }
            default: {
                super.sendPlayerAction(playerAction, game, data);
            }
        }
    }

    private void setRequestAutoAnswer(PlayerAction playerAction, Game game, Object data) {
        if (playerAction == PlayerAction.REQUEST_AUTO_ANSWER_RESET_ALL) {
            this.requestAutoAnswerId.clear();
            this.requestAutoAnswerText.clear();
            return;
        }
        if (data instanceof String) {
            String key = (String)data;
            switch (playerAction) {
                case REQUEST_AUTO_ANSWER_ID_NO: {
                    this.requestAutoAnswerId.put(key, false);
                    break;
                }
                case REQUEST_AUTO_ANSWER_TEXT_NO: {
                    this.requestAutoAnswerText.put(key, false);
                    break;
                }
                case REQUEST_AUTO_ANSWER_ID_YES: {
                    this.requestAutoAnswerId.put(key, true);
                    break;
                }
                case REQUEST_AUTO_ANSWER_TEXT_YES: {
                    this.requestAutoAnswerText.put(key, true);
                }
            }
        }
    }

    private void setTriggerAutoOrder(PlayerAction playerAction, Game game, Object data) {
        if (playerAction == PlayerAction.TRIGGER_AUTO_ORDER_RESET_ALL) {
            this.triggerAutoOrderAbilityFirst.clear();
            this.triggerAutoOrderAbilityLast.clear();
            this.triggerAutoOrderNameFirst.clear();
            this.triggerAutoOrderNameLast.clear();
            return;
        }
        if (data instanceof UUID) {
            UUID abilityId = (UUID)data;
            UUID originalId = null;
            for (TriggeredAbility ability : game.getState().getTriggered(this.getId())) {
                if (!ability.getId().equals(abilityId)) continue;
                originalId = ability.getOriginalId();
                break;
            }
            if (originalId != null) {
                switch (playerAction) {
                    case TRIGGER_AUTO_ORDER_ABILITY_FIRST: {
                        this.triggerAutoOrderAbilityFirst.add(originalId);
                        break;
                    }
                    case TRIGGER_AUTO_ORDER_ABILITY_LAST: {
                        this.triggerAutoOrderAbilityLast.add(originalId);
                    }
                }
            }
        } else if (data instanceof String) {
            String abilityName = (String)data;
            if (abilityName.contains("{this}")) {
                throw new IllegalArgumentException("Wrong code usage. Remembering trigger must contains full rules name without {this}.");
            }
            switch (playerAction) {
                case TRIGGER_AUTO_ORDER_NAME_FIRST: {
                    this.triggerAutoOrderNameFirst.add(abilityName);
                    break;
                }
                case TRIGGER_AUTO_ORDER_NAME_LAST: {
                    this.triggerAutoOrderNameLast.add(abilityName);
                }
            }
        }
    }

    protected boolean passWithManaPoolCheck(Game game) {
        String message;
        if (this.userData.confirmEmptyManaPool() && game.getStack().isEmpty() && this.getManaPool().count() > 0 && this.getManaPool().canLostManaOnEmpty() && !this.chooseUse(Outcome.Detriment, message = GameLog.getPlayerConfirmColoredText((String)"You still have mana in your mana pool and it will be lost. Pass anyway?"), null, game)) {
            this.sendPlayerAction(PlayerAction.PASS_PRIORITY_CANCEL_ALL_ACTIONS, game, null);
            return false;
        }
        this.pass(game);
        return true;
    }

    private boolean gameInCheckPlayableState(Game game) {
        return this.gameInCheckPlayableState(game, false);
    }

    private boolean gameInCheckPlayableState(Game game, boolean ignoreWarning) {
        if (game.inCheckPlayableState()) {
            if (!ignoreWarning) {
                logger.warn((Object)String.format("Current stack: %d - %s", game.getStack().size(), game.getStack().stream().map(Object::toString).collect(Collectors.joining(", "))));
                logger.warn((Object)"Player interaction in checkPlayableState", new Throwable());
            }
            return true;
        }
        return false;
    }

    public Player prepareControllableProxy(Player playerUnderControl) {
        HumanPlayer fakePlayer = new HumanPlayer((PlayerImpl)playerUnderControl, this.response);
        if (!fakePlayer.getTurnControlledBy().equals(this.getId())) {
            throw new IllegalArgumentException("Wrong code usage: controllable proxy must be controlled by " + this.getName());
        }
        return fakePlayer;
    }
}

