/*
 * Decompiled with CFR 0.152.
 */
package mage.game;

import mage.game.CommanderDuel;
import mage.game.Game;
import mage.game.GameException;
import mage.game.match.MatchImpl;
import mage.game.match.MatchOptions;
import mage.game.mulligan.Mulligan;

public class CommanderDuelMatch
extends MatchImpl {
    public CommanderDuelMatch(MatchOptions options) {
        super(options);
    }

    public void startGame() throws GameException {
        int startLife = 40;
        boolean checkCommanderDamage = true;
        if (this.options.getDeckType().equals("Variant Magic - Duel Commander")) {
            startLife = 20;
            checkCommanderDamage = false;
        }
        if (this.options.getDeckType().equals("Variant Magic - MTGO 1v1 Commander")) {
            startLife = 30;
        }
        if (this.options.getDeckType().equals("Variant Magic - Centurion Commander")) {
            startLife = 25;
        }
        Mulligan mulligan = this.options.getMulliganType().getMulligan(this.options.getFreeMulligans());
        startLife = this.options.isCustomStartLifeEnabled() ? this.options.getCustomStartLife() : startLife;
        int startHandSize = this.options.isCustomStartHandSizeEnabled() ? this.options.getCustomStartHandSize() : 7;
        CommanderDuel game = new CommanderDuel(this.options.getAttackOption(), this.options.getRange(), mulligan, startLife, startHandSize);
        game.setCheckCommanderDamage(checkCommanderDamage);
        game.setStartMessage(this.createGameStartMessage());
        this.initGame((Game)game);
        this.games.add(game);
    }
}

