/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.impl;

import org.ocpsoft.prettytime.Duration;
import org.ocpsoft.prettytime.TimeUnit;

public class DurationImpl
implements Duration {
    private long quantity;
    private long delta;
    private TimeUnit unit;

    public long getQuantity() {
        return this.quantity;
    }

    public void setQuantity(long quantity) {
        this.quantity = quantity;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public void setUnit(TimeUnit unit) {
        this.unit = unit;
    }

    public long getDelta() {
        return this.delta;
    }

    public void setDelta(long delta) {
        this.delta = delta;
    }

    public boolean isInPast() {
        return this.getQuantity() < 0L;
    }

    public boolean isInFuture() {
        return !this.isInPast();
    }

    public long getQuantityRounded(int tolerance) {
        double threshold;
        long quantity = Math.abs(this.getQuantity());
        if (this.getDelta() != 0L && (threshold = Math.abs((double)this.getDelta() / (double)this.getUnit().getMillisPerUnit() * 100.0)) > (double)tolerance) {
            ++quantity;
        }
        return quantity;
    }

    public String toString() {
        return "DurationImpl [" + this.quantity + " " + this.unit + ", delta=" + this.delta + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.delta ^ this.delta >>> 32);
        result = 31 * result + (int)(this.quantity ^ this.quantity >>> 32);
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DurationImpl other = (DurationImpl)obj;
        if (this.delta != other.delta) {
            return false;
        }
        if (this.quantity != other.quantity) {
            return false;
        }
        return !(this.unit == null ? other.unit != null : !this.unit.equals(other.unit));
    }
}

