/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.key.spec.prompting;

import java.net.URI;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import net.java.truecommons.key.spec.AbstractKeyProvider;
import net.java.truecommons.key.spec.PersistentUnknownKeyException;
import net.java.truecommons.key.spec.UnknownKeyException;
import net.java.truecommons.key.spec.prompting.PromptingKey;
import net.java.truecommons.key.spec.prompting.PromptingKeyManager;
import net.java.truecommons.key.spec.prompting.SharedKeyProvider;

@ThreadSafe
final class PromptingKeyProvider<K extends PromptingKey<K>>
extends AbstractKeyProvider<K> {
    private final PromptingKeyManager<K> manager;
    private final URI uri;
    private final SharedKeyProvider<K> provider;

    PromptingKeyProvider(PromptingKeyManager<K> manager, URI uri, SharedKeyProvider<K> provider) {
        this.manager = manager;
        this.uri = uri;
        this.provider = provider;
    }

    @Override
    public K getKeyForWriting() throws UnknownKeyException {
        return this.provider.getKeyCloneForWriting(this);
    }

    @Override
    public K getKeyForReading(boolean invalid) throws UnknownKeyException {
        return this.provider.getKeyCloneForReading(this, invalid);
    }

    @Override
    public void setKey(@Nullable K key) {
        this.provider.setKeyClone(key);
    }

    @Nullable
    PersistentUnknownKeyException getException() {
        return this.provider.getException();
    }

    void setException(@Nullable PersistentUnknownKeyException exception) {
        this.provider.setException(exception);
    }

    void resetCancelledKey() {
        this.provider.resetCancelledKey();
    }

    void resetUnconditionally() {
        this.provider.resetUnconditionally();
    }

    private PromptingKey.View<K> getView() {
        return this.manager.getView();
    }

    void promptKeyForWriting() throws UnknownKeyException {
        this.getView().promptKeyForWriting(new WriteController());
    }

    void promptKeyForReading(boolean invalid) throws UnknownKeyException {
        this.getView().promptKeyForReading(new ReadController(), invalid);
    }

    boolean isChangeRequested() {
        return this.provider.isChangeRequested();
    }

    @NotThreadSafe
    private final class ReadController
    extends AbstractController {
        private ReadController() {
        }

        @Override
        public K getKeyClone() {
            throw new IllegalStateException();
        }
    }

    @NotThreadSafe
    private final class WriteController
    extends AbstractController {
        private WriteController() {
        }

        @Override
        public K getKeyClone() {
            return PromptingKeyProvider.this.provider.getKeyClone();
        }
    }

    @NotThreadSafe
    private abstract class AbstractController
    implements PromptingKey.Controller<K> {
        private AbstractController() {
        }

        @Override
        public final URI getResource() {
            return PromptingKeyProvider.this.uri;
        }

        @Override
        public final void setKeyClone(@Nullable K key) {
            PromptingKeyProvider.this.provider.setKeyClone(key);
        }
    }
}

