/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.i18n;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListResourceBundle;
import java.util.ResourceBundle;
import org.ocpsoft.prettytime.Duration;
import org.ocpsoft.prettytime.TimeFormat;
import org.ocpsoft.prettytime.TimeUnit;
import org.ocpsoft.prettytime.format.SimpleTimeFormat;
import org.ocpsoft.prettytime.impl.TimeFormatProvider;
import org.ocpsoft.prettytime.units.Day;
import org.ocpsoft.prettytime.units.Hour;
import org.ocpsoft.prettytime.units.Minute;
import org.ocpsoft.prettytime.units.Month;
import org.ocpsoft.prettytime.units.Week;
import org.ocpsoft.prettytime.units.Year;

public class Resources_sk
extends ListResourceBundle
implements TimeFormatProvider {
    private static final Object[][] OBJECTS = new Object[][]{{"CenturyPattern", "%n %u"}, {"CenturyFuturePrefix", "o "}, {"CenturyFutureSuffix", ""}, {"CenturyPastPrefix", "pred "}, {"CenturyPastSuffix", ""}, {"CenturySingularName", "storo\u010die"}, {"CenturyPluralName", "storo\u010dia"}, {"CenturyPastSingularName", "storo\u010d\u00edm"}, {"CenturyPastPluralName", "storo\u010diami"}, {"CenturyFutureSingularName", "storo\u010d\u00ed"}, {"CenturyFuturePluralName", "storo\u010dia"}, {"DayPattern", "%n %u"}, {"DayFuturePrefix", "o "}, {"DayFutureSuffix", ""}, {"DayPastPrefix", "pred "}, {"DayPastSuffix", ""}, {"DaySingularName", "de\u0148"}, {"DayPluralName", "dni"}, {"DecadePattern", "%n %u"}, {"DecadeFuturePrefix", "o "}, {"DecadeFutureSuffix", ""}, {"DecadePastPrefix", "pred "}, {"DecadePastSuffix", ""}, {"DecadeSingularName", "desa\u0165ro\u010die"}, {"DecadePluralName", "desa\u0165ro\u010dia"}, {"DecadePastSingularName", "desa\u0165ro\u010d\u00edm"}, {"DecadePastPluralName", "desa\u0165ro\u010diami"}, {"DecadeFutureSingularName", "desa\u0165ro\u010d\u00ed"}, {"DecadeFuturePluralName", "desa\u0165ro\u010dia"}, {"HourPattern", "%n %u"}, {"HourFuturePrefix", "o "}, {"HourFutureSuffix", ""}, {"HourPastPrefix", "pred"}, {"HourPastSuffix", ""}, {"HourSingularName", "hodina"}, {"HourPluralName", "hodiny"}, {"JustNowPattern", "%u"}, {"JustNowFuturePrefix", ""}, {"JustNowFutureSuffix", "o chv\u00ed\u013eu"}, {"JustNowPastPrefix", "pred chv\u00ed\u013eou"}, {"JustNowPastSuffix", ""}, {"JustNowSingularName", ""}, {"JustNowPluralName", ""}, {"MillenniumPattern", "%n %u"}, {"MillenniumFuturePrefix", "o "}, {"MillenniumFutureSuffix", ""}, {"MillenniumPastPrefix", "pred "}, {"MillenniumPastSuffix", ""}, {"MillenniumSingularName", "t\u00eds\u00edcro\u010die"}, {"MillenniumPluralName", "tis\u00edcro\u010dia"}, {"MillisecondPattern", "%n %u"}, {"MillisecondFuturePrefix", "o "}, {"MillisecondFutureSuffix", ""}, {"MillisecondPastPrefix", "pred "}, {"MillisecondPastSuffix", ""}, {"MillisecondSingularName", "milisekunda"}, {"MillisecondPluralName", "milisekundy"}, {"MillisecondPastSingularName", "milisekundou"}, {"MillisecondPastPluralName", "milisekundami"}, {"MillisecondFutureSingularName", "milisekundu"}, {"MillisecondFuturePluralName", "milisek\u00fand"}, {"MinutePattern", "%n %u"}, {"MinuteFuturePrefix", "o "}, {"MinuteFutureSuffix", ""}, {"MinutePastPrefix", "pred "}, {"MinutePastSuffix", ""}, {"MinuteSingularName", "min\u00fata"}, {"MinutePluralName", "min\u00faty"}, {"MonthPattern", "%n %u"}, {"MonthFuturePrefix", "o "}, {"MonthFutureSuffix", ""}, {"MonthPastPrefix", "pred "}, {"MonthPastSuffix", ""}, {"MonthSingularName", "mesiac"}, {"MonthPluralName", "mesiace"}, {"SecondPattern", "%n %u"}, {"SecondFuturePrefix", "o "}, {"SecondFutureSuffix", ""}, {"SecondPastPrefix", "pred "}, {"SecondPastSuffix", ""}, {"SecondSingularName", "sekunda"}, {"SecondPluralName", "sekundy"}, {"WeekPattern", "%n %u"}, {"WeekFuturePrefix", "o "}, {"WeekFutureSuffix", ""}, {"WeekPastPrefix", "pred "}, {"WeekPastSuffix", ""}, {"WeekSingularName", "t\u00fd\u017ede\u0148"}, {"WeekPluralName", "t\u00fd\u017edne"}, {"YearPattern", "%n %u"}, {"YearFuturePrefix", "o "}, {"YearFutureSuffix", ""}, {"YearPastPrefix", "pred "}, {"YearPastSuffix", ""}, {"YearSingularName", "rok"}, {"YearPluralName", "roky"}, {"AbstractTimeUnitPattern", ""}, {"AbstractTimeUnitFuturePrefix", ""}, {"AbstractTimeUnitFutureSuffix", ""}, {"AbstractTimeUnitPastPrefix", ""}, {"AbstractTimeUnitPastSuffix", ""}, {"AbstractTimeUnitSingularName", ""}, {"AbstractTimeUnitPluralName", ""}};

    public Object[][] getContents() {
        return OBJECTS;
    }

    public TimeFormat getFormatFor(TimeUnit t) {
        if (t instanceof Minute) {
            return new CsTimeFormatBuilder("Minute").addFutureName("min\u00fatu", 1L).addFutureName("min\u00faty", 4L).addFutureName("min\u00fat", Long.MAX_VALUE).addPastName("min\u00fatou", 1L).addPastName("min\u00fatami", Long.MAX_VALUE).build(this);
        }
        if (t instanceof Hour) {
            return new CsTimeFormatBuilder("Hour").addFutureName("hodinu", 1L).addFutureName("hodiny", 4L).addFutureName("hod\u00edn", Long.MAX_VALUE).addPastName("hodinou", 1L).addPastName("hodinami", Long.MAX_VALUE).build(this);
        }
        if (t instanceof Day) {
            return new CsTimeFormatBuilder("Day").addFutureName("de\u0148", 1L).addFutureName("dni", 4L).addFutureName("dn\u00ed", Long.MAX_VALUE).addPastName("d\u0148om", 1L).addPastName("d\u0148ami", Long.MAX_VALUE).build(this);
        }
        if (t instanceof Week) {
            return new CsTimeFormatBuilder("Week").addFutureName("t\u00fd\u017ede\u0148", 1L).addFutureName("t\u00fd\u017edne", 4L).addFutureName("t\u00fd\u017ed\u0148ov", Long.MAX_VALUE).addPastName("t\u00fd\u017ed\u0148om", 1L).addPastName("t\u00fd\u017ed\u0148ami", Long.MAX_VALUE).build(this);
        }
        if (t instanceof Month) {
            return new CsTimeFormatBuilder("Month").addFutureName("mesiac", 1L).addFutureName("mesiace", 4L).addFutureName("mesiacov", Long.MAX_VALUE).addPastName("mesiacom", 1L).addPastName("mesiacmi", Long.MAX_VALUE).build(this);
        }
        if (t instanceof Year) {
            return new CsTimeFormatBuilder("Year").addFutureName("rok", 1L).addFutureName("roky", 4L).addFutureName("rokov", Long.MAX_VALUE).addPastName("rokom", 1L).addPastName("rokmi", Long.MAX_VALUE).build(this);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CsName
    implements Comparable<CsName> {
        private final boolean isFuture;
        private final String value;
        private final Long threshold;

        public CsName(boolean isFuture, String value, Long threshold) {
            this.isFuture = isFuture;
            this.value = value;
            this.threshold = threshold;
        }

        public boolean isFuture() {
            return this.isFuture;
        }

        public String get() {
            return this.value;
        }

        public long getThreshold() {
            return this.threshold;
        }

        @Override
        public int compareTo(CsName o) {
            return this.threshold.compareTo(o.getThreshold());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CsTimeFormat
    extends SimpleTimeFormat
    implements TimeFormat {
        private final List<CsName> futureNames = new ArrayList<CsName>();
        private final List<CsName> pastNames = new ArrayList<CsName>();

        public CsTimeFormat(String resourceKeyPrefix, ResourceBundle bundle, Collection<CsName> names) {
            this.setPattern(bundle.getString(resourceKeyPrefix + "Pattern"));
            this.setFuturePrefix(bundle.getString(resourceKeyPrefix + "FuturePrefix"));
            this.setFutureSuffix(bundle.getString(resourceKeyPrefix + "FutureSuffix"));
            this.setPastPrefix(bundle.getString(resourceKeyPrefix + "PastPrefix"));
            this.setPastSuffix(bundle.getString(resourceKeyPrefix + "PastSuffix"));
            this.setSingularName(bundle.getString(resourceKeyPrefix + "SingularName"));
            this.setPluralName(bundle.getString(resourceKeyPrefix + "PluralName"));
            try {
                this.setFuturePluralName(bundle.getString(resourceKeyPrefix + "FuturePluralName"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.setFutureSingularName(bundle.getString(resourceKeyPrefix + "FutureSingularName"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.setPastPluralName(bundle.getString(resourceKeyPrefix + "PastPluralName"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.setPastSingularName(bundle.getString(resourceKeyPrefix + "PastSingularName"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (CsName name : names) {
                if (name.isFuture()) {
                    this.futureNames.add(name);
                    continue;
                }
                this.pastNames.add(name);
            }
            Collections.sort(this.futureNames);
            Collections.sort(this.pastNames);
        }

        @Override
        protected String getGramaticallyCorrectName(Duration d, boolean round) {
            long quantity = Math.abs(this.getQuantity(d, round));
            if (d.isInFuture()) {
                return this.getGramaticallyCorrectName(quantity, this.futureNames);
            }
            return this.getGramaticallyCorrectName(quantity, this.pastNames);
        }

        private String getGramaticallyCorrectName(long quantity, List<CsName> names) {
            for (CsName name : names) {
                if (name.getThreshold() < quantity) continue;
                return name.get();
            }
            throw new IllegalStateException("Invalid resource bundle configuration");
        }
    }

    private static class CsTimeFormatBuilder {
        private List<CsName> names = new ArrayList<CsName>();
        private String resourceKeyPrefix;

        CsTimeFormatBuilder(String resourceKeyPrefix) {
            this.resourceKeyPrefix = resourceKeyPrefix;
        }

        CsTimeFormatBuilder addFutureName(String name, long limit) {
            return this.addName(true, name, limit);
        }

        CsTimeFormatBuilder addPastName(String name, long limit) {
            return this.addName(false, name, limit);
        }

        private CsTimeFormatBuilder addName(boolean isFuture, String name, long limit) {
            if (name == null) {
                throw new IllegalArgumentException();
            }
            this.names.add(new CsName(isFuture, name, limit));
            return this;
        }

        CsTimeFormat build(ResourceBundle bundle) {
            return new CsTimeFormat(this.resourceKeyPrefix, bundle, this.names);
        }
    }
}

