/*
 * Decompiled with CFR 0.152.
 */
package mage.cards;

import java.awt.Color;

public class MageCardSpace {
    public static final MageCardSpace empty = new MageCardSpace(0, 0, 0, 0);
    int left;
    int right;
    int top;
    int bottom;
    Color debugColor = null;

    public MageCardSpace(int left, int right, int top, int bottom) {
        this.left = left;
        this.right = right;
        this.top = top;
        this.bottom = bottom;
    }

    public MageCardSpace withDebugColor(Color color) {
        this.debugColor = color;
        return this;
    }

    public int getLeft() {
        return this.left;
    }

    public int getRight() {
        return this.right;
    }

    public int getTop() {
        return this.top;
    }

    public int getBottom() {
        return this.bottom;
    }

    public int getWidth() {
        return this.left + this.right;
    }

    public int getHeight() {
        return this.top + this.bottom;
    }

    public Color getDebugColor() {
        return this.debugColor;
    }

    public static MageCardSpace combine(MageCardSpace ... spaces) {
        MageCardSpace res = new MageCardSpace(0, 0, 0, 0);
        for (MageCardSpace space : spaces) {
            res.left += space.left;
            res.right += space.right;
            res.top += space.top;
            res.bottom += space.bottom;
        }
        return res;
    }
}

