/*
 * Decompiled with CFR 0.152.
 */
package mage.db;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.jdbc.JdbcConnectionSource;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.TableUtils;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mage.cards.repository.DatabaseUtils;
import mage.db.model.Feedback;

public enum EntityManager {
    instance;

    private Dao<Feedback, Object> feedbackDao;

    private EntityManager() {
        File file = new File("db");
        if (!file.exists()) {
            file.mkdirs();
        }
        try {
            JdbcConnectionSource feedbackConnectionSource = new JdbcConnectionSource(DatabaseUtils.prepareH2Connection((String)"feedback.h2", (boolean)false));
            TableUtils.createTableIfNotExists((ConnectionSource)feedbackConnectionSource, Feedback.class);
            this.feedbackDao = DaoManager.createDao((ConnectionSource)feedbackConnectionSource, Feedback.class);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    public void insertFeedback(String username, String title, String type, String message, String email, String host, Date created) throws SQLException {
        Feedback feedback = new Feedback(username, title, type, message, email, host, created, "new");
        this.feedbackDao.create((Object)feedback);
    }

    public List<Feedback> getAllFeedbacks() {
        List<Feedback> feedbacks = new ArrayList<Feedback>();
        try {
            feedbacks = this.feedbackDao.queryForAll();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return feedbacks;
    }
}

