/*
 * Decompiled with CFR 0.152.
 */
package mage.utils.testers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mage.abilities.Ability;
import mage.game.Game;
import mage.players.Player;
import mage.util.DebugUtil;
import mage.utils.testers.AmountTestableResult;
import mage.utils.testers.BaseTestableDialog;
import mage.utils.testers.TestableDialogsRunner;

class GetAmountTestableDialog
extends BaseTestableDialog {
    boolean isYou;
    int min;
    int max;

    public GetAmountTestableDialog(boolean isYou, int min, int max) {
        super(String.format("player.getAmount(%s)", isYou ? "you" : "AI"), String.format("from %d to %d", min, max), "", new AmountTestableResult());
        this.isYou = isYou;
        this.min = min;
        this.max = max;
    }

    private GetAmountTestableDialog aiMustChoose(int minAmount, int maxAmount) {
        AmountTestableResult res = (AmountTestableResult)this.getResult();
        res.aiAssertEnabled = true;
        res.aiAssertMinAmount = minAmount;
        res.aiAssertMaxAmount = maxAmount;
        return this;
    }

    @Override
    public void showDialog(Player player, Ability source, Game game, Player opponent) {
        Player choosingPlayer = this.isYou ? player : opponent;
        String message = "<font color=green>message</font> with html";
        String chooseDebugSource = DebugUtil.getMethodNameWithSource((int)0, (String)"class");
        int chooseRes = choosingPlayer.getAmount(this.min, this.max, message, source, game);
        ArrayList<String> res = new ArrayList<String>();
        res.add(this.getGroup() + " - " + this.getName() + " selected " + chooseRes);
        ((AmountTestableResult)this.getResult()).onFinish(chooseDebugSource, true, res, chooseRes);
    }

    public static void register(TestableDialogsRunner runner) {
        List<Boolean> isYous = Arrays.asList(false, true);
        for (boolean isYou : isYous) {
            runner.registerDialog(new GetAmountTestableDialog(isYou, 0, 0).aiMustChoose(0, 0));
            runner.registerDialog(new GetAmountTestableDialog(isYou, 0, 1).aiMustChoose(0, 1));
            runner.registerDialog(new GetAmountTestableDialog(isYou, 0, 3).aiMustChoose(0, 3));
            runner.registerDialog(new GetAmountTestableDialog(isYou, 0, 50).aiMustChoose(0, 50));
            runner.registerDialog(new GetAmountTestableDialog(isYou, 0, 500).aiMustChoose(0, 500));
            runner.registerDialog(new GetAmountTestableDialog(isYou, 1, 1).aiMustChoose(1, 1));
            runner.registerDialog(new GetAmountTestableDialog(isYou, 1, 3).aiMustChoose(1, 3));
            runner.registerDialog(new GetAmountTestableDialog(isYou, 1, 50).aiMustChoose(1, 50));
            runner.registerDialog(new GetAmountTestableDialog(isYou, 3, 3).aiMustChoose(3, 3));
            runner.registerDialog(new GetAmountTestableDialog(isYou, 3, 10).aiMustChoose(3, 10));
            runner.registerDialog(new GetAmountTestableDialog(isYou, 10, 10).aiMustChoose(10, 10));
        }
    }
}

