/*
 * Decompiled with CFR 0.152.
 */
package mage.utils.testers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import mage.abilities.Ability;
import mage.constants.MultiAmountType;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.DebugUtil;
import mage.util.MultiAmountMessage;
import mage.utils.testers.BaseTestableDialog;
import mage.utils.testers.MultiAmountTestableResult;
import mage.utils.testers.TestableDialogsRunner;

class GetMultiAmountTestableDialog
extends BaseTestableDialog {
    boolean isYou;
    int totalMin;
    int totalMax;
    List<MultiAmountMessage> amountOptions = new ArrayList<MultiAmountMessage>();

    public GetMultiAmountTestableDialog(boolean isYou, String info, int totalMin, int totalMax, List<List<Integer>> options) {
        super(String.format("player.getMultiAmount(%s)", isYou ? "you" : "AI"), String.format("%s, %d options from [%d-%d]", info, options.size(), totalMin, totalMax), "", new MultiAmountTestableResult());
        this.isYou = isYou;
        this.totalMin = totalMin;
        this.totalMax = totalMax;
        int optionNumber = 0;
        for (List<Integer> single : options) {
            String mes = "<font color=green>option</font> " + ++optionNumber + " with html";
            this.amountOptions.add(new MultiAmountMessage(mes, single.get(0).intValue(), single.get(1).intValue(), single.get(2).intValue()));
        }
    }

    private GetMultiAmountTestableDialog aiMustChoose(Integer ... needValues) {
        MultiAmountTestableResult res = (MultiAmountTestableResult)this.getResult();
        res.aiAssertEnabled = true;
        res.aiAssertValues = Arrays.stream(needValues).collect(Collectors.toList());
        return this;
    }

    private GetMultiAmountTestableDialog aiMustChooseMany(Integer options, Integer perOption) {
        ArrayList<Integer> need = new ArrayList<Integer>();
        IntStream.rangeClosed(1, options).forEach(x -> need.add(perOption));
        MultiAmountTestableResult res = (MultiAmountTestableResult)this.getResult();
        res.aiAssertEnabled = true;
        res.aiAssertValues = need;
        return this;
    }

    @Override
    public void showDialog(Player player, Ability source, Game game, Player opponent) {
        Player choosingPlayer = this.isYou ? player : opponent;
        List options = this.amountOptions.stream().map(MultiAmountMessage::copy).collect(Collectors.toList());
        String chooseDebugSource = DebugUtil.getMethodNameWithSource((int)0, (String)"class");
        List chooseRes = choosingPlayer.getMultiAmountWithIndividualConstraints(Outcome.Benefit, options, this.totalMin, this.totalMax, MultiAmountType.DAMAGE, game);
        ArrayList<String> res = new ArrayList<String>();
        res.add(this.getGroup() + " - " + this.getName());
        int selectedIndex = -1;
        int selectedTotal = 0;
        for (Integer selectedValue : chooseRes) {
            selectedTotal += selectedValue.intValue();
            MultiAmountMessage option = this.amountOptions.get(++selectedIndex);
            res.add(String.format("%d from [%d-%d, def %d]", selectedValue, option.min, option.max, option.defaultValue));
        }
        res.add("total selected: " + selectedTotal);
        ((MultiAmountTestableResult)this.getResult()).onFinish(chooseDebugSource, true, res, chooseRes);
    }

    public static void register(TestableDialogsRunner runner) {
        List<Boolean> isYous = Arrays.asList(false, true);
        for (boolean isYou : isYous) {
            runner.registerDialog(new GetMultiAmountTestableDialog(isYou, "one, 0 def", 0, 1, GetMultiAmountTestableDialog.genSameOptions(1, 0, 1, 0)).aiMustChoose(1));
            runner.registerDialog(new GetMultiAmountTestableDialog(isYou, "one, 0 def", 0, 3, GetMultiAmountTestableDialog.genSameOptions(1, 0, 3, 0)).aiMustChoose(3));
            runner.registerDialog(new GetMultiAmountTestableDialog(isYou, "one, 1 def", 1, 1, GetMultiAmountTestableDialog.genSameOptions(1, 1, 1, 1)).aiMustChoose(1));
            runner.registerDialog(new GetMultiAmountTestableDialog(isYou, "one, 1 def", 1, 3, GetMultiAmountTestableDialog.genSameOptions(1, 1, 3, 1)).aiMustChoose(3));
            runner.registerDialog(new GetMultiAmountTestableDialog(isYou, "one, 5 def", 0, 10, GetMultiAmountTestableDialog.genSameOptions(1, 0, 10, 5)).aiMustChoose(10));
            runner.registerDialog(new GetMultiAmountTestableDialog(isYou, "one, 10 def", 10, 10, GetMultiAmountTestableDialog.genSameOptions(1, 0, 10, 10)).aiMustChoose(10));
            runner.registerDialog(new GetMultiAmountTestableDialog(isYou, "many, 0 def", 0, 5, GetMultiAmountTestableDialog.genSameOptions(3, 0, 3, 0)).aiMustChoose(2, 2, 1));
            runner.registerDialog(new GetMultiAmountTestableDialog(isYou, "many, 1 def", 1, 5, GetMultiAmountTestableDialog.genSameOptions(3, 1, 3, 1)).aiMustChoose(2, 2, 1));
            runner.registerDialog(new GetMultiAmountTestableDialog(isYou, "many, 20 def", 0, 60, GetMultiAmountTestableDialog.genSameOptions(3, 0, 60, 20)).aiMustChoose(20, 20, 20));
            runner.registerDialog(new GetMultiAmountTestableDialog(isYou, "many, 20 def", 60, 60, GetMultiAmountTestableDialog.genSameOptions(3, 0, 60, 20)).aiMustChoose(20, 20, 20));
            runner.registerDialog(new GetMultiAmountTestableDialog(isYou, "big list", 0, 100, GetMultiAmountTestableDialog.genSameOptions(20, 0, 100, 0)).aiMustChooseMany(20, 5));
            runner.registerDialog(new GetMultiAmountTestableDialog(isYou, "big list", 0, 100, GetMultiAmountTestableDialog.genSameOptions(100, 0, 100, 0)).aiMustChooseMany(100, 1));
        }
    }

    private static List<List<Integer>> genSameOptions(int options, int min, int max, int def) {
        ArrayList<List<Integer>> res = new ArrayList<List<Integer>>();
        for (int i = 0; i < options; ++i) {
            res.add(Arrays.asList(min, max, def));
        }
        return res;
    }
}

