/*
 * Decompiled with CFR 0.152.
 */
package mage.utils.timer;

import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import mage.MageException;
import mage.interfaces.Action;
import org.apache.log4j.Logger;

public class PriorityTimer
extends TimerTask {
    private static final Logger logger = Logger.getLogger(PriorityTimer.class);
    private final long delay;
    private final Action taskOnTimeout;
    private int count;
    private int bufferCount = 0;
    private Action taskOnTick;
    private States state = States.NONE;

    public PriorityTimer(int count, long delay, Action taskOnTimeout) {
        this.count = count;
        this.delay = delay;
        this.taskOnTimeout = taskOnTimeout;
    }

    public void init(UUID gameId) {
        this.state = States.INIT;
        Timer timer = new Timer("Priority Timer-" + gameId.toString(), false);
        long delayMs = this.delay * (long)((int)(1000L / this.delay));
        timer.scheduleAtFixedRate((TimerTask)this, delayMs, delayMs);
    }

    public void start() {
        if (this.state == States.NONE) {
            throw new IllegalStateException("Timer should have been initialized first");
        }
        if (this.state == States.FINISHED) {
            throw new IllegalStateException("Timer has already finished its work");
        }
        this.state = States.RUNNING;
    }

    public void pause() {
        this.state = States.PAUSED;
    }

    public void stop() {
        this.state = States.FINISHED;
        this.count = 0;
    }

    public void resume() {
        if (this.state == States.FINISHED) {
            throw new IllegalStateException("Timer has already finished its work");
        }
        this.state = States.RUNNING;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public int getBufferCount() {
        return this.bufferCount;
    }

    public void setBufferCount(int count) {
        this.bufferCount = count;
    }

    public void setTaskOnTick(Action taskOnTick) {
        this.taskOnTick = taskOnTick;
    }

    @Override
    public void run() {
        if (this.state == States.RUNNING) {
            if (this.bufferCount > 0) {
                --this.bufferCount;
            } else {
                --this.count;
            }
            if (this.taskOnTick != null) {
                try {
                    this.taskOnTick.execute();
                }
                catch (MageException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Count is: " + this.count));
        }
        if (this.count <= 0) {
            this.cancel();
            try {
                this.taskOnTimeout.execute();
            }
            catch (MageException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static enum States {
        NONE,
        INIT,
        RUNNING,
        PAUSED,
        FINISHED;

    }
}

