/*
 * Decompiled with CFR 0.152.
 */
package mage.view;

import com.google.gson.annotations.Expose;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageInt;
import mage.MageObject;
import mage.ObjectColor;
import mage.abilities.Abilities;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.SpellAbility;
import mage.abilities.dynamicvalue.common.GetXValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.Effects;
import mage.abilities.icon.CardIcon;
import mage.abilities.icon.CardIconImpl;
import mage.abilities.icon.CardIconType;
import mage.abilities.keyword.AftermathAbility;
import mage.abilities.keyword.ForetellAbility;
import mage.cards.ArtRect;
import mage.cards.Card;
import mage.cards.CardWithSpellOption;
import mage.cards.FrameStyle;
import mage.cards.MeldCard;
import mage.cards.ModalDoubleFacedCard;
import mage.cards.SpellOptionCard;
import mage.cards.SplitCard;
import mage.cards.SplitCardHalf;
import mage.cards.mock.MockCard;
import mage.cards.repository.CardInfo;
import mage.cards.repository.TokenInfo;
import mage.cards.repository.TokenRepository;
import mage.constants.AbilityType;
import mage.constants.CardType;
import mage.constants.MageObjectType;
import mage.constants.Rarity;
import mage.constants.SpellAbilityType;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.constants.Zone;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.designations.Designation;
import mage.filter.FilterMana;
import mage.game.Game;
import mage.game.command.Dungeon;
import mage.game.command.Emblem;
import mage.game.command.Plane;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentToken;
import mage.game.permanent.token.Token;
import mage.game.stack.Spell;
import mage.game.stack.StackAbility;
import mage.game.stack.StackObject;
import mage.players.Player;
import mage.target.Target;
import mage.target.Targets;
import mage.util.CardUtil;
import mage.util.ManaUtil;
import mage.util.SubTypes;
import mage.view.CounterView;
import mage.view.DungeonView;
import mage.view.EmblemView;
import mage.view.PermanentView;
import mage.view.PlaneView;
import mage.view.SimpleCardView;

public class CardView
extends SimpleCardView {
    private static final long serialVersionUID = 1L;
    protected UUID parentId;
    @Expose
    protected String name;
    @Expose
    protected String displayName;
    @Expose
    protected String displayFullName;
    @Expose
    protected List<String> rules;
    @Expose
    protected String power;
    @Expose
    protected String toughness;
    @Expose
    protected String loyalty;
    @Expose
    protected String defense;
    protected String startingLoyalty;
    protected String startingDefense;
    protected List<CardType> cardTypes;
    protected SubTypes subTypes;
    protected List<SuperType> superTypes;
    protected ObjectColor color;
    protected ObjectColor frameColor;
    protected FrameStyle frameStyle;
    protected List<String> manaCostLeftStr;
    protected List<String> manaCostRightStr;
    protected int manaValue;
    protected Rarity rarity;
    protected MageObjectType mageObjectType;
    protected boolean isAbility;
    protected AbilityType abilityType;
    protected boolean isToken;
    protected CardView ability;
    protected String imageFileName;
    protected int imageNumber;
    protected boolean extraDeckCard;
    protected boolean transformable;
    protected CardView secondCardFace;
    protected boolean transformed;
    protected boolean flipCard;
    protected boolean faceDown;
    protected String alternateName;
    protected boolean isSplitCard;
    protected String leftSplitName;
    protected String leftSplitCostsStr;
    protected List<String> leftSplitRules;
    protected String leftSplitTypeLine;
    protected String rightSplitName;
    protected String rightSplitCostsStr;
    protected List<String> rightSplitRules;
    protected String rightSplitTypeLine;
    protected boolean isModalDoubleFacedCard;
    protected ArtRect artRect;
    protected List<UUID> targets;
    protected UUID pairedCard;
    protected List<UUID> bandedCards;
    protected boolean paid;
    protected List<CounterView> counters;
    protected boolean controlledByOwner;
    protected Zone zone;
    protected boolean rotate;
    protected boolean hideInfo;
    protected boolean canAttack;
    protected boolean canBlock;
    protected boolean inViewerOnly;
    protected List<CardIcon> cardIcons;
    protected MageInt originalPower;
    protected MageInt originalToughness;
    protected String originalColorIdentity;
    protected boolean originalIsCopy;

    public CardView(Card card) {
        this(card, (Game)null);
    }

    public CardView(Card card, Game game) {
        this(card, game, false);
    }

    public CardView(Card card, Game game, boolean showAsControlled) {
        this(card, game, showAsControlled, false);
    }

    public CardView(Card card, SimpleCardView simpleCardView) {
        this(card, null, false);
        this.id = simpleCardView.getId();
        this.playableStats = simpleCardView.playableStats.copy();
        this.isChoosable = simpleCardView.isChoosable;
        this.isSelected = simpleCardView.isSelected;
    }

    public CardView(CardView cardView) {
        super(cardView);
        this.loyalty = "";
        this.defense = "";
        this.mageObjectType = MageObjectType.NULL;
        this.imageFileName = "";
        this.imageNumber = 0;
        this.artRect = ArtRect.NORMAL;
        this.controlledByOwner = true;
        this.cardIcons = new ArrayList<CardIcon>();
        this.originalPower = null;
        this.originalToughness = null;
        this.originalColorIdentity = null;
        this.originalIsCopy = false;
        this.id = UUID.randomUUID();
        this.parentId = cardView.parentId;
        this.name = cardView.name;
        this.displayName = cardView.displayName;
        this.displayFullName = cardView.displayFullName;
        this.rules = new ArrayList<String>(cardView.rules);
        this.power = cardView.power;
        this.toughness = cardView.toughness;
        this.loyalty = cardView.loyalty;
        this.startingLoyalty = cardView.startingLoyalty;
        this.defense = cardView.defense;
        this.startingDefense = cardView.startingDefense;
        this.cardTypes = new ArrayList<CardType>(cardView.cardTypes);
        this.subTypes = cardView.subTypes.copy();
        this.superTypes = cardView.superTypes;
        this.expansionSetCode = cardView.expansionSetCode;
        this.cardNumber = cardView.cardNumber;
        this.imageFileName = cardView.imageFileName;
        this.imageNumber = cardView.imageNumber;
        this.color = cardView.color.copy();
        this.frameColor = cardView.frameColor.copy();
        this.frameStyle = cardView.frameStyle;
        this.manaCostLeftStr = cardView.manaCostLeftStr;
        this.manaCostRightStr = cardView.manaCostRightStr;
        this.manaValue = cardView.manaValue;
        this.rarity = cardView.rarity;
        this.mageObjectType = cardView.mageObjectType;
        this.isAbility = cardView.isAbility;
        this.abilityType = cardView.abilityType;
        this.isToken = cardView.isToken;
        this.ability = cardView.ability;
        this.extraDeckCard = cardView.extraDeckCard;
        this.transformable = cardView.transformable;
        this.secondCardFace = cardView.secondCardFace == null ? null : new CardView(cardView.secondCardFace);
        this.transformed = cardView.transformed;
        this.flipCard = cardView.flipCard;
        this.faceDown = cardView.faceDown;
        this.alternateName = cardView.alternateName;
        this.isSplitCard = cardView.isSplitCard;
        this.leftSplitName = cardView.leftSplitName;
        this.leftSplitCostsStr = cardView.leftSplitCostsStr;
        this.leftSplitRules = cardView.leftSplitRules == null ? null : new ArrayList<String>(cardView.leftSplitRules);
        this.leftSplitTypeLine = cardView.leftSplitTypeLine;
        this.rightSplitName = cardView.rightSplitName;
        this.rightSplitCostsStr = cardView.rightSplitCostsStr;
        this.rightSplitRules = cardView.rightSplitRules == null ? null : new ArrayList<String>(cardView.rightSplitRules);
        this.rightSplitTypeLine = cardView.rightSplitTypeLine;
        this.isModalDoubleFacedCard = cardView.isModalDoubleFacedCard;
        this.artRect = cardView.artRect;
        this.targets = cardView.targets == null ? null : new ArrayList<UUID>(cardView.targets);
        this.pairedCard = cardView.pairedCard;
        this.bandedCards = cardView.bandedCards == null ? null : new ArrayList<UUID>(cardView.bandedCards);
        this.paid = cardView.paid;
        if (cardView.counters != null) {
            this.counters = new ArrayList<CounterView>();
            cardView.counters.forEach(c -> this.counters.add(new CounterView((CounterView)c)));
        }
        this.controlledByOwner = cardView.controlledByOwner;
        this.zone = cardView.zone;
        this.rotate = cardView.rotate;
        this.hideInfo = cardView.hideInfo;
        this.canAttack = cardView.canAttack;
        this.canBlock = cardView.canBlock;
        this.inViewerOnly = cardView.inViewerOnly;
        if (cardView.cardIcons != null) {
            cardView.cardIcons.forEach(icon -> this.cardIcons.add((CardIcon)icon.copy()));
        }
        this.originalPower = cardView.originalPower;
        this.originalToughness = cardView.originalToughness;
        this.originalColorIdentity = cardView.originalColorIdentity;
        this.originalIsCopy = cardView.originalIsCopy;
        this.playableStats = cardView.playableStats.copy();
        this.isChoosable = cardView.isChoosable;
        this.isSelected = cardView.isSelected;
    }

    private static String getCardTypeLine(Game game, Card card) {
        StringBuilder sbType = new StringBuilder();
        for (SuperType superType : card.getSuperType(game)) {
            sbType.append(superType).append(' ');
        }
        for (CardType cardType : card.getCardType(game)) {
            sbType.append(cardType.toString()).append(' ');
        }
        if (!card.getSubtype(game).isEmpty()) {
            sbType.append("- ");
            for (SubType subType : card.getSubtype(game)) {
                sbType.append(subType).append(' ');
            }
        }
        return sbType.toString();
    }

    public CardView(Card sourceCard, Game game, boolean showAsControlled, boolean storeZone) {
        Spell spell;
        boolean showFaceUp;
        Card card;
        block58: {
            block57: {
                super(sourceCard.getId(), sourceCard.getExpansionSetCode(), sourceCard.getCardNumber(), sourceCard.getUsesVariousArt(), game != null);
                this.loyalty = "";
                this.defense = "";
                this.mageObjectType = MageObjectType.NULL;
                this.imageFileName = "";
                this.imageNumber = 0;
                this.artRect = ArtRect.NORMAL;
                this.controlledByOwner = true;
                this.cardIcons = new ArrayList<CardIcon>();
                this.originalPower = null;
                this.originalToughness = null;
                this.originalColorIdentity = null;
                this.originalIsCopy = false;
                String sourceName = sourceCard.getMainCard().getName();
                card = sourceCard.copy();
                if (game != null && card instanceof Spell) {
                    card = ((Spell)card).getSpellAbility().getCharacteristics(game);
                }
                this.faceDown = game != null && sourceCard.isFaceDown(game);
                showFaceUp = !this.faceDown;
                boolean showHiddenFaceDownData = showAsControlled || game != null && game.hasEnded();
                this.expansionSetCode = card.getExpansionSetCode();
                this.cardNumber = card.getCardNumber();
                this.imageFileName = card.getImageFileName();
                this.imageNumber = card.getImageNumber();
                this.usesVariousArt = card.getUsesVariousArt();
                if (showFaceUp) {
                    this.setOriginalValues((MageObject)card);
                }
                if (game != null) {
                    Zone cardZone = game.getState().getZone(card.getId());
                    if (storeZone) {
                        this.zone = cardZone;
                    }
                }
                if (!showFaceUp) {
                    String visibleName;
                    this.fillEmptyWithImageInfo(game, card, true);
                    this.name = visibleName = CardUtil.getCardNameForGUI((String)(showHiddenFaceDownData ? sourceName : ""), (String)this.imageFileName);
                    this.displayName = visibleName;
                    this.displayFullName = visibleName;
                    this.alternateName = visibleName;
                    if (sourceCard instanceof Spell || card instanceof Permanent) {
                        this.power = Integer.toString(card.getPower().getValue());
                        this.toughness = Integer.toString(card.getToughness().getValue());
                        this.cardTypes = new ArrayList<CardType>(card.getCardType());
                        this.color = card.getColor(null).copy();
                        this.superTypes = new ArrayList<SuperType>(card.getSuperType());
                        this.subTypes = card.getSubtype().copy();
                        this.rules = new ArrayList<String>(card.getRules());
                    }
                    if (showHiddenFaceDownData) {
                        this.transformable = true;
                        this.secondCardFace = new CardView(sourceCard.getMainCard());
                        this.alternateName = sourceCard.getMainCard().getName();
                    }
                }
                if (showFaceUp) {
                    ModalDoubleFacedCard mainCard;
                    Object fullCardName;
                    SplitCard splitCard = null;
                    if (card instanceof SplitCard) {
                        splitCard = (SplitCard)card;
                        this.rotate = card.getSpellAbility().getSpellAbilityType() != SpellAbilityType.SPLIT_AFTERMATH;
                    } else if (card instanceof Spell) {
                        switch (card.getSpellAbility().getSpellAbilityType()) {
                            case SPLIT_FUSED: {
                                splitCard = (SplitCard)((Spell)card).getCard();
                                this.rotate = true;
                                break;
                            }
                            case SPLIT_AFTERMATH: {
                                splitCard = (SplitCard)((Spell)card).getCard();
                                this.rotate = false;
                                break;
                            }
                            case SPLIT_LEFT: 
                            case SPLIT_RIGHT: {
                                this.rotate = true;
                                break;
                            }
                            case MODAL_LEFT: 
                            case MODAL_RIGHT: {
                                this.rotate = false;
                            }
                        }
                    }
                    if (splitCard != null) {
                        this.isSplitCard = true;
                        this.leftSplitName = splitCard.getLeftHalfCard().getName();
                        this.leftSplitCostsStr = String.join((CharSequence)"", splitCard.getLeftHalfCard().getManaCostSymbols());
                        this.leftSplitRules = splitCard.getLeftHalfCard().getRules(game);
                        this.leftSplitTypeLine = CardView.getCardTypeLine(game, (Card)splitCard.getLeftHalfCard());
                        this.rightSplitName = splitCard.getRightHalfCard().getName();
                        this.rightSplitCostsStr = String.join((CharSequence)"", splitCard.getRightHalfCard().getManaCostSymbols());
                        this.rightSplitRules = splitCard.getRightHalfCard().getRules(game);
                        this.rightSplitTypeLine = CardView.getCardTypeLine(game, (Card)splitCard.getRightHalfCard());
                        fullCardName = card.getName();
                        this.manaCostLeftStr = splitCard.getLeftHalfCard().getManaCostSymbols();
                        this.manaCostRightStr = splitCard.getRightHalfCard().getManaCostSymbols();
                    } else if (card instanceof ModalDoubleFacedCard) {
                        this.isModalDoubleFacedCard = true;
                        mainCard = (ModalDoubleFacedCard)card;
                        fullCardName = mainCard.getLeftHalfCard().getName() + MockCard.MODAL_DOUBLE_FACES_NAME_SEPARATOR + mainCard.getRightHalfCard().getName();
                        this.manaCostLeftStr = mainCard.getLeftHalfCard().getManaCostSymbols();
                        this.manaCostRightStr = mainCard.getRightHalfCard().getManaCostSymbols();
                    } else if (card instanceof CardWithSpellOption) {
                        this.isSplitCard = true;
                        mainCard = (CardWithSpellOption)card;
                        this.leftSplitName = mainCard.getName();
                        this.leftSplitCostsStr = String.join((CharSequence)"", mainCard.getManaCostSymbols());
                        this.leftSplitRules = mainCard.getSharedRules(game);
                        this.leftSplitTypeLine = CardView.getCardTypeLine(game, (Card)mainCard);
                        SpellOptionCard spellOptionCard = mainCard.getSpellCard();
                        this.rightSplitName = spellOptionCard.getName();
                        this.rightSplitCostsStr = String.join((CharSequence)"", spellOptionCard.getManaCostSymbols());
                        this.rightSplitRules = spellOptionCard.getRules(game);
                        this.rightSplitTypeLine = CardView.getCardTypeLine(game, (Card)spellOptionCard);
                        fullCardName = mainCard.getName() + MockCard.CARD_WITH_SPELL_OPTION_NAME_SEPARATOR + spellOptionCard.getName();
                        this.manaCostLeftStr = mainCard.getManaCostSymbols();
                        this.manaCostRightStr = spellOptionCard.getManaCostSymbols();
                    } else if (card instanceof MockCard) {
                        fullCardName = ((MockCard)card).getFullName(true);
                        this.manaCostLeftStr = ((MockCard)card).getManaCostStr(CardInfo.ManaCostSide.LEFT);
                        this.manaCostRightStr = ((MockCard)card).getManaCostStr(CardInfo.ManaCostSide.RIGHT);
                    } else {
                        fullCardName = card.getName();
                        this.manaCostLeftStr = card.getManaCostSymbols();
                        this.manaCostRightStr = new ArrayList<String>();
                    }
                    this.name = card.getName();
                    this.displayName = card.getName();
                    this.displayFullName = fullCardName;
                    this.rules = new ArrayList<String>(card.getRules(game));
                    this.manaValue = card.getManaValue();
                }
                if (!(card instanceof Permanent)) break block57;
                this.mageObjectType = MageObjectType.PERMANENT;
                Permanent permanent = (Permanent)card;
                if (game == null) break block58;
                if (permanent.getCounters(game) != null && !permanent.getCounters(game).isEmpty()) {
                    this.loyalty = Integer.toString(permanent.getCounters(game).getCount(CounterType.LOYALTY));
                    this.defense = Integer.toString(permanent.getCounters(game).getCount(CounterType.DEFENSE));
                    this.counters = new ArrayList<CounterView>();
                    for (Counter counter : permanent.getCounters(game).values()) {
                        this.counters.add(new CounterView(counter));
                    }
                }
                this.pairedCard = permanent.getPairedCard() != null ? permanent.getPairedCard().getSourceId() : null;
                this.bandedCards = new ArrayList<UUID>();
                for (UUID bandedCard : permanent.getBandedCards()) {
                    this.bandedCards.add(bandedCard);
                }
                if (!permanent.getControllerId().equals(permanent.getOwnerId())) {
                    this.controlledByOwner = false;
                }
                if (!permanent.isTransformed()) break block58;
                this.transformed = true;
                break block58;
            }
            this.mageObjectType = card.isCopy() ? MageObjectType.COPY_CARD : MageObjectType.CARD;
            this.loyalty = "";
            this.defense = "";
            if (game != null && card.getCounters(game) != null && !card.getCounters(game).isEmpty()) {
                this.counters = new ArrayList<CounterView>();
                for (Counter counter : card.getCounters(game).values()) {
                    this.counters.add(new CounterView(counter));
                }
            }
        }
        if (showFaceUp) {
            MeldCard meldsToCard;
            this.power = Integer.toString(card.getPower().getValue());
            this.toughness = Integer.toString(card.getToughness().getValue());
            this.cardTypes = new ArrayList<CardType>(card.getCardType(game));
            this.subTypes = card.getSubtype(game).copy();
            this.superTypes = card.getSuperType(game);
            this.color = card.getColor(game).copy();
            this.flipCard = card.isFlipCard();
            if (card instanceof PermanentToken) {
                this.isToken = true;
                this.mageObjectType = MageObjectType.TOKEN;
                this.rarity = Rarity.SPECIAL;
                this.rules = new ArrayList<String>(card.getRules(game));
            } else {
                this.rarity = card.getRarity();
                this.isToken = false;
            }
            this.extraDeckCard = card.isExtraDeckCard();
            this.transformable = card.isTransformable();
            Card secondSideCard = card.getSecondCardFace();
            if (secondSideCard != null) {
                this.secondCardFace = new CardView(secondSideCard, game);
                this.alternateName = this.secondCardFace.getName();
            }
            this.flipCard = card.isFlipCard();
            if (card.isFlipCard() && card.getFlipCardName() != null) {
                this.alternateName = card.getFlipCardName();
            }
            if (card instanceof ModalDoubleFacedCard) {
                this.transformable = true;
                ModalDoubleFacedCard mdfCard = (ModalDoubleFacedCard)card;
                this.secondCardFace = new CardView((Card)mdfCard.getRightHalfCard(), game);
                this.alternateName = mdfCard.getRightHalfCard().getName();
            }
            if ((meldsToCard = card.getMeldsToCard()) != null) {
                this.transformable = true;
                this.secondCardFace = new CardView((Card)meldsToCard, game);
                this.alternateName = meldsToCard.getName();
            }
            if (card instanceof PermanentToken && card.isTransformable()) {
                Token backFace = (Token)((PermanentToken)card).getOtherFace();
                this.secondCardFace = new CardView(backFace, game);
                this.alternateName = backFace.getName();
            }
        }
        if (card instanceof Spell) {
            this.mageObjectType = MageObjectType.SPELL;
            spell = (Spell)card;
            for (SpellAbility spellAbility : spell.getSpellAbilities()) {
                for (UUID modeId : spellAbility.getModes().getSelectedModes()) {
                    Mode mode = spellAbility.getModes().get((Object)modeId);
                    if (mode.getTargets().isEmpty()) continue;
                    this.addTargets(mode.getTargets(), mode.getEffects(), (Ability)spellAbility, game);
                }
            }
            if (spell.getSpellAbility().isModal()) {
                for (Object modeId : spell.getSpellAbility().getModes().getSelectedModes()) {
                    Mode mode = spell.getSpellAbility().getModes().get(modeId);
                    this.rules.add("<span color='green'><i>Chosen mode: " + mode.getEffects().getText(mode) + "</i></span>");
                }
            }
            if (!spell.getSpellAbility().getTargets().isEmpty()) {
                StackObject stackObjectTarget = null;
                for (Target target : spell.getSpellAbility().getTargets()) {
                    for (UUID targetId : target.getTargets()) {
                        MageObject mo = game.getObject(targetId);
                        if (mo instanceof StackObject) {
                            stackObjectTarget = (StackObject)mo;
                        }
                        if (stackObjectTarget == null) continue;
                        this.rules.add("<span color='green'><i>Target on stack: " + stackObjectTarget.getIdName());
                    }
                }
            }
        }
        if (showFaceUp) {
            SpellAbilityType ty;
            if (card instanceof Spell && ((ty = (spell = (Spell)card).getSpellAbility().getSpellAbilityType()) == SpellAbilityType.SPLIT_RIGHT || ty == SpellAbilityType.SPLIT_LEFT || ty == SpellAbilityType.SPLIT_FUSED)) {
                if (ty == SpellAbilityType.SPLIT_FUSED) {
                    this.artRect = ArtRect.SPLIT_FUSED;
                } else if (spell.getCard() != null) {
                    SplitCard wholeCard = (SplitCard)((SplitCardHalf)spell.getCard()).getParentCard();
                    Abilities aftermathHalfAbilities = wholeCard.getRightHalfCard().getAbilities(game);
                    this.artRect = aftermathHalfAbilities.stream().anyMatch(AftermathAbility.class::isInstance) ? (ty == SpellAbilityType.SPLIT_RIGHT ? ArtRect.AFTERMATH_BOTTOM : ArtRect.AFTERMATH_TOP) : (ty == SpellAbilityType.SPLIT_RIGHT ? ArtRect.SPLIT_RIGHT : ArtRect.SPLIT_LEFT);
                }
            }
            if (card.getSubtype(game).contains((Object)SubType.CASE) || card.getSubtype(game).contains((Object)SubType.CLASS)) {
                this.artRect = ArtRect.FULL_LENGTH_LEFT;
            } else if (card.getSubtype(game).contains((Object)SubType.SAGA)) {
                this.artRect = ArtRect.FULL_LENGTH_RIGHT;
            }
            if (card.getFrameStyle() == FrameStyle.RETRO) {
                this.artRect = ArtRect.RETRO;
            }
            this.frameColor = card.getFrameColor(game).copy();
            this.frameStyle = card.getFrameStyle();
            this.startingLoyalty = CardUtil.convertLoyaltyOrDefense((int)card.getStartingLoyalty());
            this.startingDefense = CardUtil.convertLoyaltyOrDefense((int)card.getStartingDefense());
            this.generateCardIcons(null, (MageObject)card, game);
        }
    }

    protected final void generateCardIcons(Ability ability, MageObject object, Game game) {
        if (object instanceof Permanent) {
            this.generateCardIconsForPermanent((Permanent)object, game);
        }
        this.generateCardIconsForAny(object, ability, game);
    }

    private void generateCardIconsForPermanent(Permanent permanent, Game game) {
        Player owner;
        if (game == null) {
            return;
        }
        permanent.getAbilities(game).forEach(ability -> this.cardIcons.addAll(ability.getIcons(game)));
        if (permanent.isFaceDown(game)) {
            this.cardIcons.add((CardIcon)CardIconImpl.FACE_DOWN);
        }
        if ((owner = game.getPlayer(game.getOwnerId((MageObject)permanent))) != null && game.isCommanderObject(owner, (MageObject)permanent)) {
            this.cardIcons.add((CardIcon)CardIconImpl.COMMANDER);
        }
        if (permanent.isRingBearer()) {
            this.cardIcons.add((CardIcon)CardIconImpl.RINGBEARER);
        }
        ArrayList restricts = new ArrayList();
        this.rules.forEach(r -> {
            if (r.startsWith("ICON_RESTRICT") || r.startsWith("ICON_REQUIRE")) {
                restricts.add(r.replace("ICON_RESTRICT", "").replace("ICON_REQUIRE", "").trim());
            }
        });
        if (!restricts.isEmpty()) {
            restricts.sort(String::compareTo);
            this.cardIcons.add((CardIcon)new CardIconImpl(CardIconType.OTHER_HAS_RESTRICTIONS, String.join((CharSequence)"<br>", restricts)));
        }
    }

    private void generateCardIconsForAny(MageObject object, Ability ability, Game game) {
        if (game == null) {
            return;
        }
        Card showCard = object instanceof Card ? (Card)object : null;
        Zone showZone = ability instanceof StackAbility ? Zone.STACK : game.getState().getZone(object.getId());
        if (showZone == null) {
            return;
        }
        Object showAbility = ability != null ? ability : (showCard != null ? showCard.getSpellAbility() : null);
        if (showCard != null && showAbility != null && (showCard.getManaCost().containsX() || CardUtil.checkSourceCostsTagExists((Game)game, (Ability)showAbility, (String)"X")) && (showZone.match(Zone.BATTLEFIELD) || showZone.match(Zone.STACK))) {
            int costX = GetXValue.instance.calculate(game, showAbility, null);
            this.cardIcons.add((CardIcon)CardIconImpl.variableCost((int)costX));
        }
        if (showZone.match(Zone.STACK) && this.getTargets() != null && !this.getTargets().isEmpty()) {
            ArrayList targets = new ArrayList();
            this.getTargets().stream().map(t -> {
                Player targetPlayer;
                MageObject targetObject = game.getObject(t);
                String info = targetObject != null ? targetObject.getIdName() : ((targetPlayer = game.getPlayer(t)) != null ? targetPlayer.getName() : "Unknown");
                return info;
            }).sorted().forEach(targets::add);
            this.cardIcons.add((CardIcon)new CardIconImpl(CardIconType.OTHER_HAS_TARGETS, String.format("Has %d target(s). Move mouse over card to see target arrows:", this.getTargets().size()) + "<br><br>" + String.join((CharSequence)"<br>", targets), "T-" + this.getTargets().size()));
        }
    }

    @Deprecated
    public CardView(MageObject object, Game game) {
        super(object.getId(), object.getExpansionSetCode(), object.getCardNumber(), false, true);
        this.loyalty = "";
        this.defense = "";
        this.mageObjectType = MageObjectType.NULL;
        this.imageFileName = "";
        this.imageNumber = 0;
        this.artRect = ArtRect.NORMAL;
        this.controlledByOwner = true;
        this.cardIcons = new ArrayList<CardIcon>();
        this.originalPower = null;
        this.originalToughness = null;
        this.originalColorIdentity = null;
        this.originalIsCopy = false;
        this.setOriginalValues(object);
        this.imageFileName = object.getImageFileName();
        this.imageNumber = object.getImageNumber();
        this.name = object.getName();
        this.displayName = object.getName();
        this.displayFullName = object.getName();
        if (object instanceof Permanent) {
            this.mageObjectType = MageObjectType.PERMANENT;
            this.power = Integer.toString(object.getPower().getValue());
            this.toughness = Integer.toString(object.getToughness().getValue());
            this.loyalty = Integer.toString(((Permanent)object).getCounters((Game)null).getCount(CounterType.LOYALTY));
            this.defense = Integer.toString(((Permanent)object).getCounters((Game)null).getCount(CounterType.DEFENSE));
        } else {
            this.power = object.getPower().toString();
            this.toughness = object.getToughness().toString();
            this.loyalty = "";
            this.defense = "";
        }
        this.cardTypes = new ArrayList<CardType>(object.getCardType(game));
        this.subTypes = object.getSubtype(game).copy();
        this.superTypes = new ArrayList<SuperType>(object.getSuperType(game));
        this.color = object.getColor(game).copy();
        this.manaCostLeftStr = object.getManaCostSymbols();
        this.manaCostRightStr = new ArrayList<String>();
        this.manaValue = object.getManaCost().manaValue();
        if (object instanceof PermanentToken) {
            this.mageObjectType = MageObjectType.TOKEN;
            PermanentToken permanentToken = (PermanentToken)object;
            this.rarity = Rarity.SPECIAL;
            this.rules = new ArrayList<String>(permanentToken.getRules(game));
        } else if (object instanceof Emblem) {
            this.mageObjectType = MageObjectType.EMBLEM;
            Emblem emblem = (Emblem)object;
            this.rarity = Rarity.SPECIAL;
            this.rules = new ArrayList<String>(emblem.getAbilities().getRules(game, (MageObject)emblem));
        } else if (object instanceof Dungeon) {
            this.mageObjectType = MageObjectType.DUNGEON;
            Dungeon dungeon = (Dungeon)object;
            this.rarity = Rarity.SPECIAL;
            this.rules = new ArrayList<String>(dungeon.getRules());
        } else if (object instanceof Plane) {
            this.mageObjectType = MageObjectType.PLANE;
            Plane plane = (Plane)object;
            this.rarity = Rarity.SPECIAL;
            this.frameStyle = FrameStyle.M15_NORMAL;
            this.rotate = true;
            this.rules = new ArrayList<String>(plane.getAbilities().getRules(game, (MageObject)plane));
        } else if (object instanceof Designation) {
            this.mageObjectType = MageObjectType.DESIGNATION;
            Designation designation = (Designation)object;
            this.rarity = Rarity.SPECIAL;
            this.frameStyle = FrameStyle.M15_NORMAL;
            this.rules = new ArrayList<String>(designation.getAbilities().getRules(game, (MageObject)designation));
        }
        if (this.rarity == null && object instanceof StackAbility) {
            StackAbility stackAbility = (StackAbility)object;
            this.rarity = Rarity.SPECIAL;
            this.rules = new ArrayList<String>();
            this.rules.add(stackAbility.getRule());
        }
        if (object.getSubtype().contains((Object)SubType.CASE) || object.getSubtype().contains((Object)SubType.CLASS)) {
            this.artRect = ArtRect.FULL_LENGTH_LEFT;
        } else if (object.getSubtype().contains((Object)SubType.SAGA)) {
            this.artRect = ArtRect.FULL_LENGTH_RIGHT;
        }
        this.frameColor = object.getFrameColor(game).copy();
        this.frameStyle = object.getFrameStyle();
        this.startingLoyalty = CardUtil.convertLoyaltyOrDefense((int)object.getStartingLoyalty());
        this.startingDefense = CardUtil.convertLoyaltyOrDefense((int)object.getStartingDefense());
    }

    protected CardView() {
        super(null, "", "0", false, true);
        this.loyalty = "";
        this.defense = "";
        this.mageObjectType = MageObjectType.NULL;
        this.imageFileName = "";
        this.imageNumber = 0;
        this.artRect = ArtRect.NORMAL;
        this.controlledByOwner = true;
        this.cardIcons = new ArrayList<CardIcon>();
        this.originalPower = null;
        this.originalToughness = null;
        this.originalColorIdentity = null;
        this.originalIsCopy = false;
    }

    public CardView(EmblemView emblem) {
        this(true);
        this.gameObject = true;
        this.id = emblem.getId();
        this.mageObjectType = MageObjectType.EMBLEM;
        this.displayName = this.name = emblem.getName();
        this.displayFullName = this.name;
        this.rules = new ArrayList<String>(emblem.getRules());
        this.frameStyle = FrameStyle.M15_NORMAL;
        this.expansionSetCode = emblem.getExpansionSetCode();
        this.cardNumber = emblem.getCardNumber();
        this.imageFileName = emblem.getImageFileName();
        this.imageNumber = emblem.getImageNumber();
        this.usesVariousArt = emblem.getUsesVariousArt();
        this.rarity = Rarity.SPECIAL;
        this.playableStats = emblem.playableStats.copy();
        this.isChoosable = emblem.isChoosable();
        this.isSelected = emblem.isSelected();
    }

    public CardView(DungeonView dungeon) {
        this(true);
        this.gameObject = true;
        this.id = dungeon.getId();
        this.mageObjectType = MageObjectType.DUNGEON;
        this.displayName = this.name = dungeon.getName();
        this.displayFullName = this.name;
        this.rules = new ArrayList<String>(dungeon.getRules());
        this.frameStyle = FrameStyle.M15_NORMAL;
        this.expansionSetCode = dungeon.getExpansionSetCode();
        this.cardNumber = "";
        this.imageFileName = dungeon.getImageFileName();
        this.imageNumber = dungeon.getImageNumber();
        this.rarity = Rarity.SPECIAL;
        this.playableStats = dungeon.playableStats.copy();
        this.isChoosable = dungeon.isChoosable();
        this.isSelected = dungeon.isSelected();
    }

    public CardView(PlaneView plane) {
        this(true);
        this.gameObject = true;
        this.id = plane.getId();
        this.mageObjectType = MageObjectType.PLANE;
        this.displayName = this.name = plane.getName();
        this.displayFullName = this.name;
        this.rules = new ArrayList<String>(plane.getRules());
        this.rotate = true;
        this.frameStyle = FrameStyle.M15_NORMAL;
        this.expansionSetCode = plane.getExpansionSetCode();
        this.cardNumber = "";
        this.imageFileName = "";
        this.imageNumber = 0;
        this.rarity = Rarity.SPECIAL;
        this.playableStats = plane.playableStats.copy();
        this.isChoosable = plane.isChoosable();
        this.isSelected = plane.isSelected();
    }

    public CardView(Designation designation, StackAbility stackAbility) {
        this(true);
        this.gameObject = true;
        this.id = designation.getId();
        this.mageObjectType = MageObjectType.DESIGNATION;
        this.displayName = this.name = designation.getName();
        this.displayFullName = this.name;
        this.rules = new ArrayList<String>();
        this.rules.add(stackAbility.getRule(designation.getName()));
        this.frameStyle = FrameStyle.M15_NORMAL;
        this.cardNumber = designation.getCardNumber();
        this.expansionSetCode = designation.getExpansionSetCode();
        this.imageFileName = designation.getImageFileName();
        this.imageNumber = designation.getImageNumber();
        this.rarity = Rarity.SPECIAL;
    }

    public CardView(boolean empty) {
        super(null, "", "0", false);
        this.loyalty = "";
        this.defense = "";
        this.mageObjectType = MageObjectType.NULL;
        this.imageFileName = "";
        this.imageNumber = 0;
        this.artRect = ArtRect.NORMAL;
        this.controlledByOwner = true;
        this.cardIcons = new ArrayList<CardIcon>();
        this.originalPower = null;
        this.originalToughness = null;
        this.originalColorIdentity = null;
        this.originalIsCopy = false;
        if (!empty) {
            throw new IllegalArgumentException("Not supported.");
        }
        this.fillEmptyWithImageInfo(null, null, false);
    }

    public static boolean cardViewEquals(CardView a, CardView b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null || a.getClass() != b.getClass()) {
            return false;
        }
        if (!(a.getDisplayName().equals(b.getDisplayName()) && a.getPower().equals(b.getPower()) && a.getToughness().equals(b.getToughness()) && a.getLoyalty().equals(b.getLoyalty()) && a.getDefense().equals(b.getDefense()) && 0 == a.getColor().compareTo(b.getColor()) && a.getCardTypes().equals(b.getCardTypes()) && a.getSubTypes().equals((Object)b.getSubTypes()) && a.getSuperTypes().equals(b.getSuperTypes()) && a.getManaCostStr().equals(b.getManaCostStr()) && a.getRules().equals(b.getRules()) && Objects.equals(a.getRarity(), b.getRarity()) && a.getFrameStyle() == b.getFrameStyle() && Objects.equals(a.getCounters(), b.getCounters()) && a.isFaceDown() == b.isFaceDown())) {
            return false;
        }
        if (!(Objects.equals(a.getExpansionSetCode(), b.getExpansionSetCode()) && Objects.equals(a.getCardNumber(), b.getCardNumber()) && Objects.equals(a.getImageNumber(), b.getImageNumber()) && Objects.equals(a.getImageFileName(), b.getImageFileName()) && Objects.equals(a.getUsesVariousArt(), b.getUsesVariousArt()))) {
            return false;
        }
        if (!(a instanceof PermanentView)) {
            return true;
        }
        PermanentView aa = (PermanentView)a;
        PermanentView bb = (PermanentView)b;
        return aa.hasSummoningSickness() == bb.hasSummoningSickness() && aa.getDamage() == bb.getDamage();
    }

    private void fillEmptyWithImageInfo(Game game, Card imageSourceCard, boolean isFaceDown) {
        this.name = "";
        this.displayName = "";
        this.displayFullName = "";
        this.expansionSetCode = "";
        this.cardNumber = "0";
        this.imageFileName = "";
        this.imageNumber = 0;
        this.usesVariousArt = false;
        this.rules = new ArrayList<String>();
        this.power = "";
        this.toughness = "";
        this.loyalty = "";
        this.startingLoyalty = "";
        this.defense = "";
        this.startingDefense = "";
        this.cardTypes = new ArrayList<CardType>();
        this.subTypes = new SubTypes(new SubType[0]);
        this.superTypes = new ArrayList<SuperType>();
        this.color = new ObjectColor();
        this.frameColor = new ObjectColor();
        this.frameStyle = FrameStyle.M15_NORMAL;
        this.manaCostLeftStr = new ArrayList<String>();
        this.manaCostRightStr = new ArrayList<String>();
        this.manaValue = 0;
        this.rarity = Rarity.SPECIAL;
        if (imageSourceCard != null) {
            String imageSetCode = imageSourceCard.getExpansionSetCode();
            String imageCardNumber = imageSourceCard.getCardNumber();
            String imageFileName = imageSourceCard.getImageFileName();
            Integer imageNumber = imageSourceCard.getImageNumber();
            boolean imageUsesVariousArt = imageSourceCard.getUsesVariousArt();
            if (imageSetCode.equals("XMAGE")) {
                this.expansionSetCode = imageSetCode;
                this.cardNumber = imageCardNumber;
                this.imageFileName = imageFileName;
                this.imageNumber = imageNumber;
                this.usesVariousArt = imageUsesVariousArt;
            }
            this.mageObjectType = imageSourceCard instanceof PermanentToken ? MageObjectType.TOKEN : (imageSourceCard instanceof Permanent ? MageObjectType.PERMANENT : (imageSourceCard.isCopy() ? MageObjectType.COPY_CARD : (imageSourceCard instanceof Spell ? MageObjectType.SPELL : MageObjectType.CARD)));
        }
        if (isFaceDown && this.imageFileName.isEmpty()) {
            TokenInfo tokenInfo;
            this.displayName = this.name = "";
            this.displayFullName = this.name;
            if (game != null && imageSourceCard != null && ForetellAbility.isCardInForetell((Card)imageSourceCard, (Game)game)) {
                tokenInfo = TokenRepository.instance.findPreferredTokenInfoForXmage("Foretell", this.getId());
                if (tokenInfo != null) {
                    this.expansionSetCode = tokenInfo.getSetCode();
                    this.cardNumber = "0";
                    this.imageFileName = tokenInfo.getName();
                    this.imageNumber = tokenInfo.getImageNumber();
                    this.usesVariousArt = false;
                }
                return;
            }
            tokenInfo = TokenRepository.instance.findPreferredTokenInfoForXmage("Face Down", this.getId());
            if (tokenInfo != null) {
                this.expansionSetCode = tokenInfo.getSetCode();
                this.cardNumber = "0";
                this.imageFileName = tokenInfo.getName();
                this.imageNumber = tokenInfo.getImageNumber();
                this.usesVariousArt = false;
            }
        }
    }

    CardView(Token token, Game game) {
        super(token.getId(), "", "0", false);
        this.loyalty = "";
        this.defense = "";
        this.mageObjectType = MageObjectType.NULL;
        this.imageFileName = "";
        this.imageNumber = 0;
        this.artRect = ArtRect.NORMAL;
        this.controlledByOwner = true;
        this.cardIcons = new ArrayList<CardIcon>();
        this.originalPower = null;
        this.originalToughness = null;
        this.originalColorIdentity = null;
        this.originalIsCopy = false;
        this.isToken = true;
        this.id = token.getId();
        this.name = token.getName();
        this.displayName = token.getName();
        this.displayFullName = token.getName();
        this.rules = new ArrayList<String>(token.getAbilities().getRules(game, (MageObject)token));
        this.power = token.getPower().toString();
        this.toughness = token.getToughness().toString();
        this.loyalty = "";
        this.startingLoyalty = "";
        this.defense = "";
        this.startingDefense = "";
        this.cardTypes = new ArrayList<CardType>(token.getCardType(game));
        this.subTypes = token.getSubtype(game).copy();
        this.superTypes = new ArrayList<SuperType>(token.getSuperType(game));
        this.color = token.getColor(game).copy();
        this.frameColor = token.getFrameColor(game).copy();
        this.frameStyle = token.getFrameStyle();
        this.manaCostLeftStr = token.getManaCostSymbols();
        this.manaCostRightStr = new ArrayList<String>();
        this.rarity = Rarity.SPECIAL;
        this.expansionSetCode = token.getExpansionSetCode();
        this.cardNumber = token.getCardNumber();
        this.imageFileName = token.getImageFileName();
        this.imageNumber = token.getImageNumber();
    }

    protected final void addTargets(Targets targets, Effects effects, Ability source, Game game) {
        if (this.targets == null) {
            this.targets = new ArrayList<UUID>();
        }
        LinkedHashSet uniqueTarget = new LinkedHashSet();
        for (Target target : targets) {
            if (!target.isChosen(game)) continue;
            uniqueTarget.addAll(target.getTargets());
        }
        List fromPointers = effects.stream().map(Effect::getTargetPointer).filter(Objects::nonNull).map(p -> p.getTargets(game, source)).flatMap(Collection::stream).collect(Collectors.toList());
        uniqueTarget.addAll(fromPointers);
        this.targets.addAll(uniqueTarget);
    }

    private void setOriginalValues(MageObject object) {
        if (object == null) {
            return;
        }
        if (object instanceof Card || object instanceof Token) {
            this.originalPower = object.getPower();
            this.originalToughness = object.getToughness();
            this.originalIsCopy = object.isCopy();
            this.originalColorIdentity = object instanceof Card ? this.findColorIdentityStr(((Card)object).getColorIdentity()) : this.findColorIdentityStr(ManaUtil.getColorIdentity((Token)((Token)object)));
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDisplayFullName() {
        return this.displayFullName;
    }

    public List<String> getRules() {
        return this.rules;
    }

    public void overrideRules(List<String> rules) {
        this.rules = new ArrayList<String>(rules);
    }

    public void setIsAbility(boolean isAbility) {
        this.isAbility = isAbility;
    }

    public boolean isAbility() {
        return this.isAbility;
    }

    public AbilityType getAbilityType() {
        return this.abilityType;
    }

    public void setAbilityType(AbilityType abilityType) {
        this.abilityType = abilityType;
    }

    public String getPower() {
        return this.power;
    }

    public String getToughness() {
        return this.toughness;
    }

    public String getLoyalty() {
        return this.loyalty;
    }

    public String getStartingLoyalty() {
        return this.startingLoyalty;
    }

    public String getDefense() {
        return this.defense;
    }

    public String getStartingDefense() {
        return this.startingDefense;
    }

    public List<CardType> getCardTypes() {
        return this.cardTypes;
    }

    public SubTypes getSubTypes() {
        return this.subTypes;
    }

    public List<SuperType> getSuperTypes() {
        return this.superTypes;
    }

    public ObjectColor getColor() {
        return this.color;
    }

    public ObjectColor getFrameColor() {
        return this.frameColor;
    }

    public FrameStyle getFrameStyle() {
        return this.frameStyle;
    }

    public String getManaCostStr() {
        return CardUtil.concatManaSymbols((String)"{*}", (String)String.join((CharSequence)"", this.manaCostLeftStr), (String)String.join((CharSequence)"", this.manaCostRightStr));
    }

    public List<String> getManaCostSymbols() {
        ArrayList<String> symbols = new ArrayList<String>();
        for (String symbol : this.manaCostLeftStr) {
            symbols.add(symbol);
        }
        for (String symbol : this.manaCostRightStr) {
            symbols.add(symbol);
        }
        return symbols;
    }

    public int getManaValue() {
        return this.manaValue;
    }

    public Rarity getRarity() {
        return this.rarity;
    }

    public String findColorIdentityStr(FilterMana colorInfo) {
        if (colorInfo == null) {
            colorInfo = new FilterMana();
        }
        String colorRes = colorInfo.getColorCount() == 0 ? "{C}" : colorInfo.toString();
        return CardUtil.concatManaSymbols((String)"{*}", (String)colorRes, (String)"");
    }

    @Override
    public String getExpansionSetCode() {
        if (this.expansionSetCode == null) {
            this.expansionSetCode = "";
        }
        return this.expansionSetCode;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public String getCardNumber() {
        return this.cardNumber;
    }

    public List<UUID> getTargets() {
        return this.targets;
    }

    public void overrideTargets(List<UUID> newTargets) {
        this.targets = newTargets;
    }

    public void overrideId(UUID id) {
        if (this.parentId == null) {
            this.parentId = this.id;
        }
        this.id = id;
    }

    public UUID getParentId() {
        if (this.parentId != null) {
            return this.parentId;
        }
        return this.id;
    }

    public void setAbility(CardView ability) {
        this.ability = ability;
    }

    public CardView getAbility() {
        return this.ability;
    }

    public String toString() {
        return this.getName() + " [" + this.getId() + ']';
    }

    public boolean isFaceDown() {
        return this.faceDown;
    }

    public boolean canTransform() {
        return this.transformable;
    }

    public boolean isSplitCard() {
        return this.isSplitCard;
    }

    public String getAlternateName() {
        return this.alternateName;
    }

    public void setAlternateName(String alternateName) {
        this.alternateName = alternateName;
    }

    public String getLeftSplitName() {
        return this.leftSplitName;
    }

    public String getLeftSplitCostsStr() {
        return this.leftSplitCostsStr;
    }

    public List<String> getLeftSplitRules() {
        return this.leftSplitRules;
    }

    public String getLeftSplitTypeLine() {
        return this.leftSplitTypeLine;
    }

    public String getRightSplitName() {
        return this.rightSplitName;
    }

    public String getRightSplitCostsStr() {
        return this.rightSplitCostsStr;
    }

    public List<String> getRightSplitRules() {
        return this.rightSplitRules;
    }

    public String getRightSplitTypeLine() {
        return this.rightSplitTypeLine;
    }

    public ArtRect getArtRect() {
        return this.artRect;
    }

    public CardView getSecondCardFace() {
        return this.secondCardFace;
    }

    public boolean isToken() {
        return this.isToken;
    }

    public void setTransformed(boolean transformed) {
        this.transformed = transformed;
    }

    public boolean isTransformed() {
        return this.transformed;
    }

    public UUID getPairedCard() {
        return this.pairedCard;
    }

    public List<UUID> getBandedCards() {
        return this.bandedCards;
    }

    public String getImageFileName() {
        return this.imageFileName;
    }

    public int getImageNumber() {
        return this.imageNumber;
    }

    public MageObjectType getMageObjectType() {
        return this.mageObjectType;
    }

    public void setMageObjectType(MageObjectType mageObjectType) {
        this.mageObjectType = mageObjectType;
    }

    public boolean isPaid() {
        return this.paid;
    }

    public void setPaid(boolean paid) {
        this.paid = paid;
    }

    public List<CounterView> getCounters() {
        return this.counters;
    }

    public boolean isControlledByOwner() {
        return this.controlledByOwner;
    }

    public Zone getZone() {
        return this.zone;
    }

    public boolean isFlipCard() {
        return this.flipCard;
    }

    public boolean isToRotate() {
        return this.rotate;
    }

    public boolean hideInfo() {
        return this.hideInfo;
    }

    public boolean isCanAttack() {
        return this.canAttack;
    }

    public void setCanAttack(boolean canAttack) {
        this.canAttack = canAttack;
    }

    public boolean isCanBlock() {
        return this.canBlock;
    }

    public void setCanBlock(boolean canBlock) {
        this.canBlock = canBlock;
    }

    public boolean isCreature() {
        return this.cardTypes.contains(CardType.CREATURE);
    }

    public boolean isPlaneswalker() {
        return this.cardTypes.contains(CardType.PLANESWALKER);
    }

    public boolean isBattle() {
        return this.cardTypes.contains(CardType.BATTLE);
    }

    public String getColorText() {
        return CardUtil.getTextWithFirstCharUpperCase((String)this.getColor().getDescription());
    }

    public String getTypeText() {
        StringBuilder typeText = new StringBuilder();
        if (!this.getSuperTypes().isEmpty()) {
            typeText.append(String.join((CharSequence)" ", this.getSuperTypes().stream().map(SuperType::toString).collect(Collectors.toList())));
            typeText.append(" ");
        }
        if (!this.getCardTypes().isEmpty()) {
            typeText.append(String.join((CharSequence)" ", this.getCardTypes().stream().map(CardType::toString).collect(Collectors.toList())));
            typeText.append(" ");
        }
        if (!this.getSubTypes().isEmpty()) {
            typeText.append(" - ");
            typeText.append(String.join((CharSequence)" ", this.getSubTypes().stream().map(SubType::toString).collect(Collectors.toList())));
        }
        return typeText.toString();
    }

    public boolean isExtraDeckCard() {
        return this.extraDeckCard;
    }

    public boolean isLand() {
        return this.cardTypes.contains(CardType.LAND);
    }

    public boolean isInstant() {
        return this.cardTypes.contains(CardType.INSTANT);
    }

    public boolean isSorcery() {
        return this.cardTypes.contains(CardType.SORCERY);
    }

    public boolean isEnchantment() {
        return this.cardTypes.contains(CardType.ENCHANTMENT);
    }

    public boolean isArtifact() {
        return this.cardTypes.contains(CardType.ARTIFACT);
    }

    public boolean isKindred() {
        return this.cardTypes.contains(CardType.KINDRED);
    }

    public void setInViewerOnly(boolean inViewerOnly) {
        this.inViewerOnly = inViewerOnly;
    }

    public boolean inViewerOnly() {
        return this.inViewerOnly;
    }

    public MageInt getOriginalPower() {
        return this.originalPower;
    }

    public MageInt getOriginalToughness() {
        return this.originalToughness;
    }

    public String getOriginalColorIdentity() {
        return this.originalColorIdentity != null ? this.originalColorIdentity : "";
    }

    public boolean isOriginalACopy() {
        return this.originalIsCopy;
    }

    public List<CardIcon> getCardIcons() {
        return this.cardIcons;
    }

    public boolean showPT() {
        return this.isCreature() || this.getSubTypes().contains((Object)SubType.VEHICLE);
    }

    public String getIdName() {
        return this.getName() + " [" + this.getId().toString().substring(0, 3) + ']';
    }
}

