/*
 * Decompiled with CFR 0.152.
 */
package mage.view;

import java.io.Serializable;
import java.util.Date;
import mage.game.Game;
import mage.util.CardUtil;

public class ChatMessage
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String username;
    private Date time;
    private String turnInfo;
    private String message;
    private MessageColor color;
    private SoundToPlay soundToPlay;
    private MessageType messageType;

    public ChatMessage(String username, String message, Date time, Game game, MessageColor color) {
        this(username, message, time, game, color, null);
    }

    public ChatMessage(String username, String message, Date time, Game game, MessageColor color, SoundToPlay soundToPlay) {
        this(username, message, time, null, color, MessageType.TALK, soundToPlay);
    }

    public ChatMessage(String username, String message, Date time, Game game, MessageColor color, MessageType messageType, SoundToPlay soundToPlay) {
        this.username = username;
        this.message = message;
        this.time = time;
        this.turnInfo = CardUtil.getTurnInfo((Game)game);
        this.color = color;
        this.messageType = messageType;
        this.soundToPlay = soundToPlay;
    }

    public String getMessage() {
        return this.message;
    }

    public MessageColor getColor() {
        return this.color;
    }

    public boolean isUserMessage() {
        return this.color != null && (this.color == MessageColor.BLUE || this.color == MessageColor.YELLOW);
    }

    public boolean isStatusMessage() {
        return this.color != null && this.color == MessageColor.ORANGE;
    }

    public String getUsername() {
        return this.username;
    }

    public Date getTime() {
        return this.time;
    }

    public String getTurnInfo() {
        return this.turnInfo;
    }

    public SoundToPlay getSoundToPlay() {
        return this.soundToPlay;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public static enum SoundToPlay {
        PlayerLeft,
        PlayerQuitTournament,
        PlayerSubmittedDeck,
        PlayerWhispered;

    }

    public static enum MessageType {
        USER_INFO,
        STATUS,
        GAME,
        TALK,
        WHISPER_FROM,
        WHISPER_TO;

    }

    public static enum MessageColor {
        BLACK,
        RED,
        GREEN,
        BLUE,
        ORANGE,
        YELLOW;

    }
}

