/*
 * Decompiled with CFR 0.152.
 */
package mage.view;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.costs.Cost;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.PhaseStep;
import mage.constants.TurnPhase;
import mage.constants.Zone;
import mage.designations.Designation;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.GameState;
import mage.game.combat.CombatGroup;
import mage.game.command.Dungeon;
import mage.game.command.Emblem;
import mage.game.command.Plane;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentCard;
import mage.game.permanent.PermanentToken;
import mage.game.stack.Spell;
import mage.game.stack.StackAbility;
import mage.game.stack.StackObject;
import mage.players.PlayableObjectsList;
import mage.players.Player;
import mage.util.CardUtil;
import mage.view.CardView;
import mage.view.CardsView;
import mage.view.CombatGroupView;
import mage.view.DungeonView;
import mage.view.EmblemView;
import mage.view.ExileView;
import mage.view.LookedAtView;
import mage.view.PlaneView;
import mage.view.PlayerView;
import mage.view.RevealedView;
import mage.view.SimpleCardsView;
import mage.view.StackAbilityView;
import org.apache.log4j.Logger;

public class GameView
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(GameView.class);
    private final int priorityTime;
    private final int bufferTime;
    private final List<PlayerView> players = new ArrayList<PlayerView>();
    private UUID myPlayerId = null;
    private final CardsView myHand = new CardsView();
    private final CardsView myHelperEmblems = new CardsView();
    private PlayableObjectsList canPlayObjects;
    private final Map<String, SimpleCardsView> opponentHands = new HashMap<String, SimpleCardsView>();
    private final Map<String, SimpleCardsView> watchedHands = new HashMap<String, SimpleCardsView>();
    private final CardsView stack = new CardsView();
    private final List<ExileView> exiles = new ArrayList<ExileView>();
    private final List<RevealedView> revealed = new ArrayList<RevealedView>();
    private final List<LookedAtView> lookedAt = new ArrayList<LookedAtView>();
    private final List<RevealedView> companion = new ArrayList<RevealedView>();
    private final List<CombatGroupView> combat = new ArrayList<CombatGroupView>();
    private final TurnPhase phase;
    private final PhaseStep step;
    private final UUID activePlayerId;
    private String activePlayerName = "";
    private final String priorityPlayerName;
    private final int turn;
    private boolean special = false;
    private final boolean rollbackTurnsAllowed;
    private int totalErrorsCount;
    private int totalEffectsCount;
    private int gameCycle;

    public GameView(GameState state, Game game, UUID createdForPlayerId, UUID watcherUserId) {
        Player createdForPlayer = null;
        this.priorityTime = game.getPriorityTime();
        this.bufferTime = game.getBufferTime();
        for (Player player : state.getPlayers().values()) {
            PlayerView playerView = new PlayerView(player, state, game, createdForPlayerId, watcherUserId);
            this.players.add(playerView);
            if (!player.getId().equals(createdForPlayerId)) continue;
            createdForPlayer = player;
            this.myPlayerId = player.getId();
            this.myHand.putAll(new CardsView(game, player.getHand().getCards(game), createdForPlayerId));
            state.getHelperEmblems().stream().filter(emblem -> emblem.isControlledBy(player.getId())).forEach(emblem -> this.myHelperEmblems.put(emblem.getId(), new CardView(new EmblemView((Emblem)emblem, game))));
        }
        for (StackObject stackObject : state.getStack()) {
            if (stackObject instanceof Spell) {
                Spell spell = (Spell)stackObject;
                CardView spellView = new CardView((Card)spell, game, CardUtil.canShowAsControlled((Card)spell, (UUID)createdForPlayerId));
                spellView.paid = spell.getSpellAbility().getManaCostsToPay().isPaid();
                this.stack.put(spell.getId(), spellView);
                continue;
            }
            if (stackObject instanceof StackAbility) {
                MageObject object = game.getObject(stackObject.getSourceId());
                Card card = game.getCard(stackObject.getSourceId());
                if (card == null && object instanceof PermanentCard) {
                    card = ((PermanentCard)object).getCard();
                }
                if (card != null) {
                    if (object != null) {
                        if (object instanceof Permanent) {
                            boolean controlled = ((Permanent)object).getControllerId().equals(createdForPlayerId);
                            this.stack.put(stackObject.getId(), new StackAbilityView(game, (StackAbility)stackObject, object.getName(), object, new CardView((Card)((Permanent)object), game, controlled, false)));
                        } else {
                            this.stack.put(stackObject.getId(), new StackAbilityView(game, (StackAbility)stackObject, card.getName(), (MageObject)card, new CardView(card, game, false, false)));
                        }
                    } else {
                        this.stack.put(stackObject.getId(), new StackAbilityView(game, (StackAbility)stackObject, "", (MageObject)card, new CardView(card, game)));
                    }
                    if (card.isTransformable()) {
                        this.updateLatestCardView(game, card, stackObject.getId());
                    }
                    this.checkPaid(stackObject.getId(), (StackAbility)stackObject);
                    continue;
                }
                if (object != null) {
                    if (object instanceof PermanentToken) {
                        PermanentToken token = (PermanentToken)object;
                        this.stack.put(stackObject.getId(), new StackAbilityView(game, (StackAbility)stackObject, token.getName(), (MageObject)token, new CardView((Card)token, game)));
                        this.checkPaid(stackObject.getId(), (StackAbility)stackObject);
                        continue;
                    }
                    if (object instanceof Emblem) {
                        CardView cardView = new CardView(new EmblemView((Emblem)object, game));
                        stackObject.setName(object.getName());
                        this.stack.put(stackObject.getId(), new StackAbilityView(game, (StackAbility)stackObject, object.getName(), object, cardView));
                        this.checkPaid(stackObject.getId(), (StackAbility)stackObject);
                        continue;
                    }
                    if (object instanceof Dungeon) {
                        CardView cardView = new CardView(new DungeonView((Dungeon)object));
                        stackObject.setName(object.getName());
                        this.stack.put(stackObject.getId(), new StackAbilityView(game, (StackAbility)stackObject, object.getName(), object, cardView));
                        this.checkPaid(stackObject.getId(), (StackAbility)stackObject);
                        continue;
                    }
                    if (object instanceof Plane) {
                        CardView cardView = new CardView(new PlaneView((Plane)object, game));
                        stackObject.setName(object.getName());
                        this.stack.put(stackObject.getId(), new StackAbilityView(game, (StackAbility)stackObject, object.getName(), object, cardView));
                        this.checkPaid(stackObject.getId(), (StackAbility)stackObject);
                        continue;
                    }
                    if (object instanceof Designation) {
                        Designation designation = (Designation)game.getObject(object.getId());
                        if (designation != null) {
                            this.stack.put(stackObject.getId(), new StackAbilityView(game, (StackAbility)stackObject, designation.getName(), (MageObject)designation, new CardView(designation, (StackAbility)stackObject)));
                            continue;
                        }
                        throw new IllegalArgumentException("Designation object not found: " + object + " - " + object.getClass().toString());
                    }
                    if (object instanceof StackAbility) {
                        StackAbility stackAbility = (StackAbility)object;
                        stackAbility.newId();
                        this.stack.put(stackObject.getId(), new CardView((MageObject)stackObject, game));
                        this.checkPaid(stackObject.getId(), (StackAbility)stackObject);
                        continue;
                    }
                    throw new IllegalArgumentException("Object can't be cast to StackAbility: " + object + " - " + object.getClass().toString());
                }
                LOGGER.debug((Object)("Stack Object for stack ability not found: " + stackObject.getStackAbility().getRule()));
                continue;
            }
            if (stackObject == null) continue;
            throw new IllegalArgumentException("Unknown type of StackObject: " + stackObject + " - " + stackObject.getClass().toString());
        }
        for (ExileZone exileZone : state.getExile().getExileZones()) {
            this.exiles.add(new ExileView(exileZone, game, createdForPlayerId));
        }
        for (String name : state.getRevealed().keySet()) {
            this.revealed.add(new RevealedView(name, (Cards)state.getRevealed().get((Object)name), game));
        }
        if (this.myPlayerId != null) {
            for (String name : state.getLookedAt(this.myPlayerId).keySet()) {
                this.lookedAt.add(new LookedAtView(name, (Cards)state.getLookedAt(this.myPlayerId).get((Object)name), game));
            }
        }
        for (String name : state.getCompanion().keySet()) {
            if (!((Cards)state.getCompanion().get((Object)name)).stream().anyMatch(cardId -> state.getZone(cardId) == Zone.OUTSIDE)) continue;
            this.companion.add(new RevealedView(name, (Cards)state.getCompanion().get((Object)name), game));
        }
        this.phase = state.getTurnPhaseType();
        this.step = state.getTurnStepType();
        this.turn = state.getTurnNum();
        this.activePlayerId = state.getActivePlayerId();
        this.activePlayerName = state.getActivePlayerId() != null ? state.getPlayer(state.getActivePlayerId()).getName() : "";
        Player priorityPlayer = null;
        this.priorityPlayerName = state.getPriorityPlayerId() != null ? ((priorityPlayer = state.getPlayer(state.getPriorityPlayerId())) != null ? priorityPlayer.getName() : "") : "";
        for (CombatGroup combatGroup : state.getCombat().getGroups()) {
            this.combat.add(new CombatGroupView(combatGroup, game));
        }
        if (this.myPlayerId != null) {
            if (priorityPlayer != null && createdForPlayer != null && createdForPlayer.isGameUnderControl() && (createdForPlayerId.equals(priorityPlayer.getId()) || createdForPlayer.getPlayersUnderYourControl().contains(priorityPlayer.getId()))) {
                this.special = !state.getSpecialActions().getControlledBy(priorityPlayer.getId(), priorityPlayer.isInPayManaMode()).isEmpty();
            }
        } else {
            this.special = false;
        }
        this.rollbackTurnsAllowed = game.getOptions().rollbackTurnsAllowed;
        this.totalErrorsCount = game.getTotalErrorsCount();
        this.totalEffectsCount = game.getTotalEffectsCount();
        this.gameCycle = game.getState().getApplyEffectsCounter();
    }

    private void checkPaid(UUID uuid, StackAbility stackAbility) {
        for (Cost cost : stackAbility.getManaCostsToPay()) {
            if (cost.isPaid()) continue;
            return;
        }
        CardView cardView = (CardView)this.stack.get(uuid);
        cardView.paid = true;
    }

    private void updateLatestCardView(Game game, Card card, UUID stackId) {
        if (!card.isTransformable()) {
            return;
        }
        Permanent permanent = game.getPermanent(card.getId());
        if (permanent == null) {
            permanent = (Permanent)game.getLastKnownInformation(card.getId(), Zone.BATTLEFIELD);
        }
        if (permanent != null && permanent.isTransformed()) {
            StackAbilityView stackAbilityView = (StackAbilityView)this.stack.get(stackId);
            stackAbilityView.getSourceCard().setTransformed(true);
        }
    }

    public List<PlayerView> getPlayers() {
        return this.players;
    }

    public CardsView getMyHand() {
        return this.myHand;
    }

    public CardsView getMyHelperEmblems() {
        return this.myHelperEmblems;
    }

    public PlayerView getMyPlayer() {
        if (this.myPlayerId == null) {
            return null;
        }
        return this.players.stream().filter(p -> p.getPlayerId().equals(this.myPlayerId)).findFirst().orElse(null);
    }

    public Map<String, SimpleCardsView> getOpponentHands() {
        return this.opponentHands;
    }

    public Map<String, SimpleCardsView> getWatchedHands() {
        return this.watchedHands;
    }

    public TurnPhase getPhase() {
        return this.phase;
    }

    public PhaseStep getStep() {
        return this.step;
    }

    public CardsView getStack() {
        return this.stack;
    }

    public List<ExileView> getExile() {
        return this.exiles;
    }

    public List<RevealedView> getRevealed() {
        return this.revealed;
    }

    public List<LookedAtView> getLookedAt() {
        return this.lookedAt;
    }

    public List<RevealedView> getCompanion() {
        return this.companion;
    }

    public List<CombatGroupView> getCombat() {
        return this.combat;
    }

    public int getTurn() {
        return this.turn;
    }

    public String getActivePlayerName() {
        return this.activePlayerName;
    }

    public String getPriorityPlayerName() {
        return this.priorityPlayerName;
    }

    public boolean getSpecial() {
        return this.special;
    }

    public int getPriorityTime() {
        return this.priorityTime;
    }

    public int getBufferTime() {
        return this.bufferTime;
    }

    public UUID getActivePlayerId() {
        return this.activePlayerId;
    }

    public boolean isPlayer() {
        return this.myPlayerId != null;
    }

    public PlayableObjectsList getCanPlayObjects() {
        return this.canPlayObjects;
    }

    public void setCanPlayObjects(PlayableObjectsList canPlayObjects) {
        this.canPlayObjects = canPlayObjects;
    }

    public boolean isRollbackTurnsAllowed() {
        return this.rollbackTurnsAllowed;
    }

    public String toJson() {
        Gson gson = new GsonBuilder().create();
        return gson.toJson((Object)this);
    }

    public int getTotalErrorsCount() {
        return this.totalErrorsCount;
    }

    public int getTotalEffectsCount() {
        return this.totalEffectsCount;
    }

    public int getGameCycle() {
        return this.gameCycle;
    }
}

