/*
 * Decompiled with CFR 0.152.
 */
package mage.view;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import mage.game.Game;
import mage.game.GameInfo;
import mage.game.tournament.Round;
import mage.game.tournament.TournamentPairing;
import mage.view.TournamentGameView;

public class RoundView
implements Serializable {
    private static final long serialVersionUID = 1L;
    List<TournamentGameView> games = new ArrayList<TournamentGameView>();

    public RoundView(Round round) {
        try {
            for (TournamentPairing pair : round.getPairs()) {
                if (pair.getMatch() == null) continue;
                for (GameInfo gameInfo : pair.getMatch().getGamesInfo()) {
                    this.games.add(new TournamentGameView(round.getRoundNumber(), gameInfo.getMatchId(), gameInfo.getGameId(), gameInfo.getState(), gameInfo.getResult(), gameInfo.getPlayers(), gameInfo.getTableId()));
                }
                if (pair.getMatch().hasEnded()) continue;
                int numberSavedGames = pair.getMatch().getGamesInfo().size();
                if (pair.getMatch() == null) continue;
                int gameCount = 0;
                for (Game game : pair.getMatch().getGames()) {
                    if (++gameCount <= numberSavedGames) continue;
                    this.games.add(new TournamentGameView(round.getRoundNumber(), pair, game));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public List<TournamentGameView> getGames() {
        return this.games;
    }
}

