/*
 * Decompiled with CFR 0.152.
 */
package mage.view;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.Modes;
import mage.abilities.effects.Effect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.HintUtils;
import mage.cards.Card;
import mage.constants.AbilityType;
import mage.constants.CardType;
import mage.constants.MageObjectType;
import mage.game.Game;
import mage.game.stack.StackAbility;
import mage.game.stack.StackObject;
import mage.target.Target;
import mage.target.targetpointer.TargetPointer;
import mage.util.GameLog;
import mage.view.CardView;

public class StackAbilityView
extends CardView {
    private static final long serialVersionUID = 1L;
    private final CardView sourceCard;

    public StackAbilityView(Game game, StackAbility ability, String sourceName, MageObject sourceObject, CardView sourceView) {
        String nameToShow;
        this.id = ability.getId();
        this.mageObjectType = sourceView.getMageObjectType().isUseTokensRepository() ? MageObjectType.ABILITY_STACK_FROM_TOKEN : MageObjectType.ABILITY_STACK_FROM_CARD;
        this.abilityType = ability.getStackAbility().getAbilityType();
        this.sourceCard = sourceView;
        this.sourceCard.setMageObjectType(this.mageObjectType);
        this.name = "Ability";
        this.loyalty = "";
        this.defense = "";
        this.cardTypes = ability.getCardType(game);
        this.subTypes = ability.getSubtype(game);
        this.superTypes = ability.getSuperType(game);
        this.color = ability.getColor(game);
        this.manaCostLeftStr = ability.getManaCostSymbols();
        this.manaCostRightStr = new ArrayList();
        this.cardTypes = ability.getCardType(game);
        this.subTypes = ability.getSubtype(game);
        this.superTypes = ability.getSuperType(game);
        this.color = ability.getColor(game);
        this.power = ability.getPower().toString();
        this.toughness = ability.getToughness().toString();
        if (this.sourceCard.isFaceDown()) {
            CardView tmpSourceCard = this.getSourceCard();
            tmpSourceCard.displayName = "Face Down";
            tmpSourceCard.superTypes.clear();
            tmpSourceCard.subTypes.clear();
            tmpSourceCard.cardTypes.clear();
            tmpSourceCard.cardTypes.add(CardType.CREATURE);
            tmpSourceCard.manaCostLeftStr = new ArrayList<String>();
            tmpSourceCard.manaCostRightStr = new ArrayList<String>();
            tmpSourceCard.power = "2";
            tmpSourceCard.toughness = "2";
            nameToShow = "creature without name";
        } else {
            nameToShow = sourceName;
        }
        this.rules = new ArrayList();
        this.rules.add(ability.getRule(nameToShow));
        this.counters = this.sourceCard.getCounters();
        this.updateTargets(game, ability);
        this.generateCardIcons((Ability)ability, sourceObject, game);
    }

    private void updateTargets(Game game, StackAbility ability) {
        ArrayList<String> names = new ArrayList<String>();
        for (UUID modeId : ability.getModes().getSelectedModes()) {
            Mode mode = ability.getModes().get((Object)modeId);
            if (!mode.getTargets().isEmpty()) {
                this.addTargets(mode.getTargets(), mode.getEffects(), (Ability)ability, game);
                continue;
            }
            LinkedHashSet uniqueTargets = new LinkedHashSet();
            for (Effect effect : mode.getEffects()) {
                TargetPointer targetPointer = effect.getTargetPointer();
                uniqueTargets.addAll(targetPointer.getTargets(game, (Ability)ability));
            }
            if (uniqueTargets.isEmpty()) continue;
            this.overrideTargets(new ArrayList<UUID>(uniqueTargets));
            for (UUID uuid : uniqueTargets) {
                String newName;
                MageObject mageObject = game.getObject(uuid);
                if (mageObject == null || mageObject instanceof Card && ((Card)mageObject).isFaceDown(game) || names.contains(newName = GameLog.getColoredObjectIdNameForTooltip((MageObject)mageObject))) continue;
                names.add(newName);
            }
        }
        if (!names.isEmpty()) {
            this.getRules().add("<i>Related objects: " + names + "</i>");
        }
        if (ability.isModal()) {
            Modes modes = ability.getModes();
            for (UUID modeId : modes.getSelectedModes()) {
                Mode mode = modes.get((Object)modeId);
                this.rules.add("<span color='green'><i>Chosen mode: " + mode.getEffects().getText(mode) + "</i></span>");
            }
        }
        ArrayList<String> abilityHints = new ArrayList<String>();
        for (Hint hint : ability.getHints()) {
            abilityHints.add(hint.getText(game, (Ability)ability));
        }
        if (!abilityHints.isEmpty()) {
            this.rules.add("<br/><hintstart/>");
            HintUtils.appendHints((List)this.rules, abilityHints);
        }
        if (!ability.getTargets().isEmpty() && names.isEmpty()) {
            StackObject stackObjectTarget = null;
            for (Target target : ability.getTargets()) {
                for (UUID targetId : target.getTargets()) {
                    MageObject mo = game.getObject(targetId);
                    if (mo instanceof StackObject) {
                        stackObjectTarget = (StackObject)mo;
                    }
                    if (stackObjectTarget == null) continue;
                    this.rules.add("<span color='green'><i>Target on stack: " + stackObjectTarget.getIdName());
                }
            }
        }
    }

    public CardView getSourceCard() {
        return this.sourceCard;
    }

    @Override
    public AbilityType getAbilityType() {
        return this.abilityType;
    }
}

