/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.DeathtouchAbility;
import mage.cards.a.ChooseHumanMerfolkOrGoblinEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class AKillerAmongUsEffect
extends OneShotEffect {
    AKillerAmongUsEffect() {
        super(Outcome.Benefit);
        this.staticText = "If target attacking creature token is the chosen type, put three +1/+1 counters on it and it gains deathtouch until end of turn.";
    }

    private AKillerAmongUsEffect(AKillerAmongUsEffect effect) {
        super((OneShotEffect)effect);
    }

    public AKillerAmongUsEffect copy() {
        return new AKillerAmongUsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent creature = game.getPermanent(source.getFirstTarget());
        if (creature == null) {
            return false;
        }
        SubType creatureType = ChooseHumanMerfolkOrGoblinEffect.getSecretCreatureType(source, game);
        if (creatureType != null && creature.hasSubtype(creatureType, game)) {
            creature.addCounters(CounterType.P1P1.createInstance(3), source, game);
            game.addEffect((ContinuousEffect)new GainAbilityTargetEffect((Ability)DeathtouchAbility.getInstance(), Duration.EndOfTurn), source);
        }
        return true;
    }
}

