/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.TransformSourceEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class AberrantResearcherEffect
extends OneShotEffect {
    AberrantResearcherEffect() {
        super(Outcome.Benefit);
        this.staticText = "mill a card. If an instant or sorcery card was milled this way, transform {this}";
    }

    private AberrantResearcherEffect(AberrantResearcherEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null || controller.millCards(1, source, game).getCards(game).stream().noneMatch(card -> card.isInstantOrSorcery(game))) {
            return false;
        }
        new TransformSourceEffect().apply(game, source);
        return true;
    }

    public AberrantResearcherEffect copy() {
        return new AberrantResearcherEffect(this);
    }
}

