/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Optional;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;

class AbeyanceEffect
extends ContinuousRuleModifyingEffectImpl {
    AbeyanceEffect() {
        super(Duration.EndOfTurn, Outcome.Detriment);
        this.staticText = "Until end of turn, target player can't cast instant or sorcery spells, and that player can't activate abilities that aren't mana abilities";
    }

    private AbeyanceEffect(AbeyanceEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public AbeyanceEffect copy() {
        return new AbeyanceEffect(this);
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        MageObject mageObject = game.getObject(source);
        if (mageObject != null) {
            return "You can't cast instant or sorcery spells or activate abilities that aren't mana abilities this turn (" + mageObject.getIdName() + ").";
        }
        return null;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL || event.getType() == GameEvent.EventType.ACTIVATE_ABILITY;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (source.getFirstTarget() != null && !source.getFirstTarget().equals(event.getPlayerId())) {
            return false;
        }
        MageObject object = game.getObject(event.getSourceId());
        if (object == null) {
            return false;
        }
        if (event.getType() == GameEvent.EventType.CAST_SPELL && object.isInstantOrSorcery(game)) {
            return true;
        }
        if (event.getType() == GameEvent.EventType.ACTIVATE_ABILITY) {
            Optional ability = game.getAbility(event.getTargetId(), event.getSourceId());
            return ability.isPresent() && !((Ability)ability.get()).isManaActivatedAbility();
        }
        return false;
    }
}

