/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CopyStackObjectEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.StackObject;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class AbolethSpawnTriggeredAbility
extends TriggeredAbilityImpl {
    AbolethSpawnTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CopyStackObjectEffect(), true);
        this.setTriggerPhrase("Whenever a creature entering the battlefield under an opponent's control causes a triggered ability of that creature to trigger, ");
    }

    private AbolethSpawnTriggeredAbility(AbolethSpawnTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TRIGGERED_ABILITY;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        StackObject stackObject = game.getStack().getStackObject(event.getTargetId());
        Permanent permanent = game.getPermanent(event.getSourceId());
        if (stackObject == null || permanent == null || !permanent.isCreature(game)) {
            return false;
        }
        if (!game.getOpponents(this.getControllerId()).contains(permanent.getControllerId())) {
            return false;
        }
        Ability stackAbility = stackObject.getStackAbility();
        if (!stackAbility.isTriggeredAbility()) {
            return false;
        }
        GameEvent triggerEvent = ((TriggeredAbility)stackAbility).getTriggerEvent();
        if (triggerEvent == null || triggerEvent.getType() != GameEvent.EventType.ENTERS_THE_BATTLEFIELD) {
            return false;
        }
        if (triggerEvent.getSourceId() != permanent.getId()) {
            return false;
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId(), game));
        return true;
    }

    public AbolethSpawnTriggeredAbility copy() {
        return new AbolethSpawnTriggeredAbility(this);
    }
}

