/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.functions.CopyApplier;
import mage.util.functions.EmptyCopyApplier;

class AbsorbIdentityEffect
extends OneShotEffect {
    AbsorbIdentityEffect() {
        super(Outcome.Copy);
        this.staticText = "You may have Shapeshifters you control become copies of that creature until end of turn.";
    }

    private AbsorbIdentityEffect(AbsorbIdentityEffect effect) {
        super((OneShotEffect)effect);
    }

    public AbsorbIdentityEffect copy() {
        return new AbsorbIdentityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent copyFrom = game.getPermanentOrLKIBattlefield(source.getFirstTarget());
        if (controller == null || copyFrom == null) {
            return false;
        }
        if (controller.chooseUse(this.outcome, "Have Shapeshifters you control become copies of " + copyFrom.getLogName() + " until end of turn?", source, game)) {
            FilterCreaturePermanent filter = new FilterCreaturePermanent("shapeshifter");
            filter.add((Predicate)SubType.SHAPESHIFTER.getPredicate());
            for (Permanent copyTo : game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, controller.getId(), game)) {
                game.copyPermanent(Duration.EndOfTurn, copyFrom, copyTo.getId(), source, (CopyApplier)new EmptyCopyApplier());
            }
        }
        return true;
    }
}

